/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.dom.EquippableWrapper;
import me.athlaeos.valhallammo.dom.ItemRarityWrapper;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Structures;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.nms.CrafterCraftListener;
import me.athlaeos.valhallammo.nms.JumpInputListener;
import me.athlaeos.valhallammo.nms.NMS;
import me.athlaeos.valhallammo.nms.NMS_v1_20_R4;
import me.athlaeos.valhallammo.nms.NMS_v1_21_R1;
import me.athlaeos.valhallammo.nms.VaultLootListener;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.tag.DamageTypeTags;

public final class NMS_v1_21_R2
implements NMS {
    @Override
    public void onEnable() {
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new CrafterCraftListener(), (Plugin)ValhallaMMO.getInstance());
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new VaultLootListener(), (Plugin)ValhallaMMO.getInstance());
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new JumpInputListener(), (Plugin)ValhallaMMO.getInstance());
    }

    @Override
    public void forceAttack(Player player, LivingEntity victim) {
        ((CraftPlayer)player).getHandle().e(((CraftEntity)victim).getHandle());
    }

    @Override
    public Pair<Location, Structures> getNearestStructure(World world, Location location, Map<Structures, Integer> structuresToFind) {
        HashSet<Pair<Integer, Integer>> chunksToScan = new HashSet<Pair<Integer, Integer>>();
        int cX = location.getChunk().getX();
        int cZ = location.getChunk().getZ();
        int maxRadius = Collections.max(structuresToFind.values());
        for (int x = cX - maxRadius; x <= cX + maxRadius; ++x) {
            for (int z = cZ - maxRadius; z <= cZ + maxRadius; ++z) {
                chunksToScan.add(new Pair<Integer, Integer>(x, z));
            }
        }
        Pair<Location, Structures> found = null;
        int closest = Integer.MAX_VALUE;
        for (Pair pair : chunksToScan) {
            Map structures = ((CraftWorld)world).getHandle().a(((Integer)pair.getOne()).intValue(), ((Integer)pair.getTwo()).intValue(), ChunkStatus.e).g();
            for (Structure s : structures.keySet()) {
                int maxDistance;
                Structures structure = Structures.fromStructure(CraftStructureType.minecraftToBukkit((StructureType)s.e()));
                if (structure == null) continue;
                StructureStart start = (StructureStart)structures.get(s);
                int distance = Utils.getManhattanDistance(cX, cZ, (Integer)pair.getOne(), (Integer)pair.getTwo());
                if (!structuresToFind.containsKey((Object)structure) || distance > (maxDistance = structuresToFind.get((Object)structure).intValue()) || distance > closest) continue;
                closest = distance;
                BlockPosition pos = start.a().g();
                Location loc = new Location(location.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
                found = new Pair<Location, Structures>(loc, structure);
            }
        }
        return found;
    }

    @Override
    public PotionType getPotionType(PotionMeta meta) {
        return meta.getBasePotionType();
    }

    @Override
    public boolean isUpgraded(PotionMeta meta) {
        return false;
    }

    @Override
    public boolean isExtended(PotionMeta meta) {
        return false;
    }

    @Override
    public void setPotionType(PotionMeta meta, PotionType type) {
        meta.setBasePotionType(type);
    }

    @Override
    public void addUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type, double amount, AttributeModifier.Operation operation) {
        NMS_v1_21_R1.addAttribute(e, identifier, type, amount, operation);
    }

    @Override
    public boolean hasUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_21_R1.hasAttribute(e, identifier, type);
    }

    @Override
    public double getUniqueAttributeValue(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_21_R1.getAttributeValue(e, identifier, type);
    }

    @Override
    public void removeUniqueAttribute(LivingEntity e, String identifier, Attribute type) {
        NMS_v1_21_R1.removeAttribute(e, identifier, type);
    }

    @Override
    public Channel channel(Player p) {
        try {
            Field c = PlayerConnection.class.getSuperclass().getDeclaredField("e");
            c.setAccessible(true);
            return ((NetworkManager)c.get((Object)((CraftPlayer)p).getHandle().f)).n;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DigPacketInfo readDiggingPacket(Player p, Object packet) {
        if (!(packet instanceof PacketPlayInBlockDig)) {
            return null;
        }
        PacketPlayInBlockDig digPacket = (PacketPlayInBlockDig)packet;
        BlockPosition pos = digPacket.b();
        return new DigPacketInfo(p, pos.u(), pos.v(), pos.w(), DigPacketInfo.fromName(digPacket.f().name()));
    }

    @Override
    public void blockBreakAnimation(Player p, org.bukkit.block.Block b, int id, int stage) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        PlayerConnection playerConnection = entityPlayer.f;
        BlockPosition blockPosition = new BlockPosition(b.getX(), b.getY(), b.getZ());
        playerConnection.b((Packet)new PacketPlayOutBlockBreakAnimation(id, blockPosition, stage));
    }

    @Override
    public void blockParticleAnimation(org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK, b.getLocation().add(0.5, 0.0, 0.5), 10, (Object)b.getBlockData());
    }

    @Override
    public float toolPower(ItemStack tool, org.bukkit.block.Block b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            Block nmsBlock = ((CraftWorld)b.getWorld()).getHandle().a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            return craftItemStack.a(nmsBlock.m());
        }
        return 1.0f;
    }

    @Override
    public float toolPower(ItemStack tool, Material b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            CraftBlockData data = (CraftBlockData)b.createBlockData();
            return craftItemStack.a(data.getState());
        }
        return 1.0f;
    }

    @Override
    public void breakBlock(Player p, org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK, b.getLocation().add(0.5, 0.5, 0.5), 100, 0.1, 0.1, 0.1, 4.0, (Object)b.getBlockData());
        b.getWorld().playSound(b.getLocation(), b.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
        ((CraftPlayer)p).getHandle().h.a(new BlockPosition(b.getX(), b.getY(), b.getZ()));
    }

    @Override
    public Sound blockSound(org.bukkit.block.Block b) {
        try {
            Block nmsBlock = ((CraftWorld)b.getWorld()).getHandle().a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            SoundEffectType soundEffectType = nmsBlock.m().A();
            Field soundEffectField = soundEffectType.getClass().getDeclaredField("fallSound");
            soundEffectField.setAccessible(true);
            SoundEffect soundEffect = (SoundEffect)soundEffectField.get(soundEffectType);
            Field keyField = SoundEffect.class.getDeclaredField("CODEC");
            keyField.setAccessible(true);
            MinecraftKey minecraftKey = (MinecraftKey)keyField.get(soundEffect);
            return Sound.valueOf((String)minecraftKey.a().toUpperCase(Locale.US).replace(".", "_").replace("_FALL", "_HIT"));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return Sound.BLOCK_STONE_HIT;
        }
    }

    @Override
    public void resetAttackCooldown(Player p) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        entityPlayer.gD();
    }

    @Override
    public void setEdible(ItemBuilder meta, boolean edible, boolean canAlwaysEat, float eatTimeSeconds) {
        if (ValhallaMMO.getPaper() != null) {
            ValhallaMMO.getPaper().setConsumable(meta, edible, canAlwaysEat, eatTimeSeconds);
            return;
        }
        if (edible) {
            FoodComponent food = meta.getMeta().getFood();
            food.setCanAlwaysEat(canAlwaysEat);
            meta.getMeta().setFood(food);
        } else {
            meta.getMeta().setFood(null);
        }
    }

    @Override
    public void setGlint(ItemMeta meta, boolean glint) {
        meta.setEnchantmentGlintOverride(Boolean.valueOf(glint));
    }

    @Override
    public void setMaxStackSize(ItemMeta meta, int stackSize) {
        meta.setMaxStackSize(Integer.valueOf(stackSize));
    }

    @Override
    public int getMaxStackSize(ItemMeta meta, Material defaultType) {
        return meta.hasMaxStackSize() ? meta.getMaxStackSize() : defaultType.getMaxStackSize();
    }

    @Override
    public void setFireResistant(ItemMeta meta, boolean fireResistant) {
        meta.setDamageResistant(DamageTypeTags.IS_FIRE);
    }

    @Override
    public void setHideTooltip(ItemMeta meta, boolean hideToolTip) {
        meta.setHideTooltip(hideToolTip);
    }

    @Override
    public void setBookContents(ItemStack book, List<BaseComponent[]> pages) {
    }

    @Override
    public Enchantment getEnchantment(EnchantmentMappings mappedTo) {
        return NMS_v1_20_R4.newMappings(mappedTo);
    }

    @Override
    public PotionEffectType getPotionEffectType(PotionEffectMappings mappedTo) {
        return NMS_v1_20_R4.newMappings(mappedTo);
    }

    @Override
    public Attribute getAttribute(AttributeMappings mappedTo) {
        return NMS_v1_21_R1.getMappedAttribute(mappedTo);
    }

    @Override
    public void setItemModel(ItemMeta meta, String model) {
        meta.setItemModel(StringUtils.isEmpty(model) ? null : NamespacedKey.fromString((String)model));
    }

    @Override
    public void setEquippable(ItemMeta meta, String modelKey, EquipmentSlot slot, String cameraOverlayKey, Sound equipSound, List<EntityType> allowedTypes) {
        if (slot == null || StringUtils.isEmpty(modelKey)) {
            meta.setEquippable(null);
        } else {
            EquippableComponent equippableComponent = meta.getEquippable();
            equippableComponent.setModel(NamespacedKey.fromString((String)modelKey));
            equippableComponent.setSlot(slot);
            equippableComponent.setAllowedEntities(allowedTypes == null || allowedTypes.isEmpty() ? null : allowedTypes);
            equippableComponent.setCameraOverlay(StringUtils.isEmpty(cameraOverlayKey) ? null : NamespacedKey.fromString((String)cameraOverlayKey));
            equippableComponent.setSwappable(true);
            equippableComponent.setEquipSound(equipSound == null ? Sound.ITEM_ARMOR_EQUIP_GENERIC : equipSound);
            equippableComponent.setDamageOnHurt(true);
            meta.setEquippable(equippableComponent);
        }
    }

    @Override
    public void setToolTipStyle(ItemMeta meta, String namespacedKey) {
        meta.setTooltipStyle(StringUtils.isEmpty(namespacedKey) ? null : NamespacedKey.fromString((String)namespacedKey));
    }

    @Override
    public String getItemModel(ItemMeta meta) {
        return !meta.hasItemModel() || meta.getItemModel() == null ? null : meta.getItemModel().toString();
    }

    @Override
    public EquippableWrapper getEquippable(ItemMeta meta) {
        if (!meta.hasEquippable() || meta.getEquippable().getModel() == null) {
            return null;
        }
        EquippableComponent e = meta.getEquippable();
        return new EquippableWrapper(e.getModel().toString(), e.getSlot(), e.getCameraOverlay() == null ? null : e.getCameraOverlay().toString(), e.getEquipSound(), e.getAllowedEntities());
    }

    @Override
    public String getToolTipStyle(ItemMeta meta) {
        return !meta.hasTooltipStyle() || meta.getTooltipStyle() == null ? null : meta.getTooltipStyle().toString();
    }

    @Override
    public void addToolBlockRule(ItemMeta meta, Material blockType, float efficiency) {
        ToolComponent tool = meta.getTool();
        tool.addRule(blockType, Float.valueOf(efficiency), Boolean.valueOf(true));
        meta.setTool(tool);
    }

    @Override
    public void setTool(ItemBuilder meta, float miningSpeed, boolean canDestroyInCreative) {
        if (ValhallaMMO.getPaper() != null) {
            ValhallaMMO.getPaper().setTool(meta, miningSpeed, canDestroyInCreative);
            return;
        }
        ToolComponent tool = meta.getMeta().getTool();
        tool.setDefaultMiningSpeed(miningSpeed);
        meta.getMeta().setTool(tool);
    }

    @Override
    public EntityExplodeEvent getExplosionEvent(Entity tnt, Location at, List<org.bukkit.block.Block> blockList, float yield, int result) {
        return new EntityExplodeEvent(tnt, at, blockList, yield, ExplosionResult.values()[result]);
    }

    @Override
    public ItemRarityWrapper getItemRarity(ItemMeta meta) {
        return switch (meta.getRarity()) {
            default -> throw new IncompatibleClassChangeError();
            case ItemRarity.COMMON -> ItemRarityWrapper.COMMON;
            case ItemRarity.UNCOMMON -> ItemRarityWrapper.UNCOMMON;
            case ItemRarity.RARE -> ItemRarityWrapper.RARE;
            case ItemRarity.EPIC -> ItemRarityWrapper.EPIC;
        };
    }

    @Override
    public void setItemRarity(ItemMeta meta, ItemRarityWrapper rarity) {
        switch (rarity) {
            case COMMON: {
                meta.setRarity(ItemRarity.COMMON);
                break;
            }
            case UNCOMMON: {
                meta.setRarity(ItemRarity.UNCOMMON);
                break;
            }
            case RARE: {
                meta.setRarity(ItemRarity.RARE);
                break;
            }
            case EPIC: {
                meta.setRarity(ItemRarity.EPIC);
            }
        }
    }
}

