/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.persistence;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.listeners.JoinLeaveListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.LeaderboardEntry;
import me.athlaeos.valhallammo.playerstats.LeaderboardManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.ResetType;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.skills.skills.Perk;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class ProfilePersistence {
    private static final Map<UUID, Collection<Class<? extends Profile>>> PROFILES_TO_SAVE = new HashMap<UUID, Collection<Class<? extends Profile>>>();
    public final ScheduledExecutorService profileThreads;
    protected final AsyncLoadingCache<UUID, ClassToInstanceMap<Profile>> persistentProfiles;
    protected final Map<UUID, ClassToInstanceMap<Profile>> skillProfiles;
    protected final Set<UUID> saving = new HashSet<UUID>();
    private static Map<UUID, Collection<Class<? extends Profile>>> resetProfiles = new HashMap<UUID, Collection<Class<? extends Profile>>>();

    protected ProfilePersistence() {
        int timeout = ValhallaMMO.getPluginConfig().getInt("profile-thread-timeout", 180000);
        int threads = ValhallaMMO.getPluginConfig().getInt("profile-thread-count", 32);
        if (threads < this.minimumProfileThreadCount()) {
            ValhallaMMO.logWarning("Profile thread count is set to " + threads + ", but the minimum for your db type is " + this.minimumProfileThreadCount() + ". Setting to minimum.");
            threads = this.minimumProfileThreadCount();
        }
        this.profileThreads = Utils.threadPool("Profile", timeout, false, threads);
        this.persistentProfiles = Caffeine.newBuilder().executor(this.profileThreads).buildAsync((uuid, executor) -> CompletableFuture.supplyAsync(() -> this.loadProfile((UUID)uuid), executor));
        this.skillProfiles = new HashMap<UUID, ClassToInstanceMap<Profile>>();
    }

    public void requestProfile(UUID p) {
        this.persistentProfiles.get(p).exceptionally(ex -> {
            ValhallaMMO.logWarning("Exception when trying to load profile for " + String.valueOf(p) + ": ");
            ex.printStackTrace();
            Player player = Bukkit.getPlayer((UUID)p);
            if (player != null) {
                Utils.sendMessage((CommandSender)player, TranslationManager.getTranslation("status_profiles_load_failed"));
            }
            return null;
        });
    }

    public <T extends Profile> boolean fillProfile(UUID player, T profile) {
        Class<?> clazz = profile.getClass();
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement("SELECT * FROM " + profile.getTableName() + " WHERE owner = ?;");
            stmt.setString(1, player.toString());
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                for (String s : profile.getAllStatNames()) {
                    String lower = s.toLowerCase(Locale.US);
                    if (profile.isInt(s)) {
                        profile.setInt(s, result.getInt(lower));
                        if (!result.wasNull()) continue;
                        profile.setInt(s, profile.getDefaultInt(s));
                        continue;
                    }
                    if (profile.isDouble(s)) {
                        profile.setDouble(s, result.getDouble(lower));
                        if (!result.wasNull()) continue;
                        profile.setDouble(s, profile.getDefaultDouble(s));
                        continue;
                    }
                    if (profile.isFloat(s)) {
                        profile.setFloat(s, result.getFloat(lower));
                        if (!result.wasNull()) continue;
                        profile.setFloat(s, profile.getDefaultFloat(s));
                        continue;
                    }
                    if (profile.isStringSet(s)) {
                        profile.setStringSet(s, ProfilePersistence.deserializeStringSet(Objects.requireNonNullElse(result.getString(lower), "")));
                        continue;
                    }
                    if (profile.isBoolean(s)) {
                        profile.setBoolean(s, result.getBoolean(lower));
                        if (!result.wasNull()) continue;
                        profile.setBoolean(s, profile.getDefaultBoolean(s));
                        continue;
                    }
                    ValhallaMMO.logWarning("Stat " + s + " in " + clazz.getSimpleName() + " was not found in database");
                }
                return true;
            }
        }
        catch (SQLException ex) {
            ValhallaMMO.logSevere("SQLException when trying to fetch " + String.valueOf(player) + "'s profile of type " + clazz.getSimpleName() + ". ");
            ex.printStackTrace();
        }
        return false;
    }

    public <T extends Profile> void insertOrUpdateProfile(UUID player, T profile) {
        StringBuilder query = new StringBuilder("REPLACE INTO ").append(profile.getTableName()).append(" (owner");
        HashMap<Integer, String> indexMap = new HashMap<Integer, String>();
        int index = 2;
        for (String s : profile.getAllStatNames()) {
            query.append(", ").append(s);
            indexMap.put(index, s);
            ++index;
        }
        query.append(") VALUES (?");
        query.append(", ?".repeat(profile.getAllStatNames().size()));
        query.append(");");
        try (PreparedStatement stmt = this.getConnection().prepareStatement(query.toString());){
            stmt.setString(1, player.toString());
            Iterator iterator = indexMap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String s = (String)indexMap.get(i);
                if (profile.isInt(s)) {
                    stmt.setInt(i, profile.getInt(s));
                    continue;
                }
                if (profile.isDouble(s)) {
                    stmt.setDouble(i, profile.getDouble(s));
                    continue;
                }
                if (profile.isFloat(s)) {
                    stmt.setFloat(i, profile.getFloat(s));
                    continue;
                }
                if (profile.isStringSet(s)) {
                    stmt.setString(i, ProfilePersistence.serializeStringSet(profile.getStringSet(s)));
                    continue;
                }
                if (profile.isBoolean(s)) {
                    stmt.setBoolean(i, profile.getBoolean(s));
                    continue;
                }
                ValhallaMMO.logWarning("Stat " + s + " from " + profile.getClass().getSimpleName() + " did not belong to a valid data type");
            }
            stmt.execute();
        }
        catch (SQLException exception) {
            ValhallaMMO.getInstance().getServer().getLogger().severe("SQLException when trying to save profile for profile type " + profile.getClass().getName() + ". ");
            exception.printStackTrace();
        }
    }

    public static String leaderboardQuery(Profile p, Pair<String, Double> stat, Map<String, Pair<String, Double>> extraStats) {
        String query = "SELECT %s.owner AS owner%s, %s.%s AS main_stat\nFROM %s%s ORDER BY %s DESC%s;\n";
        String t = p.getTableName();
        String c = stat.getOne().toLowerCase(Locale.US);
        return String.format(query, t, extraStats.keySet().stream().map(e -> String.format(", %s.%s", t, e)).collect(Collectors.joining()), t, c, t, ProfilePersistence.whereClause(stat, extraStats), c, extraStats.keySet().stream().map(e -> String.format(", %s DESC", e)).collect(Collectors.joining()));
    }

    private static String whereClause(Pair<String, Double> mainStat, Map<String, Pair<String, Double>> extraStats) {
        HashSet<String> whereClauses = new HashSet<String>();
        if (mainStat.getTwo() != null) {
            whereClauses.add(String.format("%s >= FORMAT(%.2f, 'D', 'en-US')", mainStat.getOne(), mainStat.getTwo()));
        }
        for (String stat : extraStats.keySet()) {
            Pair<String, Double> statWithMinimum = extraStats.get(stat);
            if (statWithMinimum == null || statWithMinimum.getTwo() == null) continue;
            whereClauses.add(String.format("%s >= FORMAT(%.2f, 'D', 'en-US')", stat, statWithMinimum.getTwo()));
        }
        return whereClauses.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", whereClauses);
    }

    public void createProfileTable(Profile type) {
        String lower;
        StringBuilder query = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        query.append(type.getTableName()).append(" (");
        query.append("owner VARCHAR(40) PRIMARY KEY");
        for (String s : type.getAllStatNames()) {
            if (type.getTablesToUpdate().contains(s)) continue;
            lower = s.toLowerCase(Locale.US);
            if (type.isInt(s)) {
                query.append(", ").append(lower).append(" INTEGER default ").append(type.getDefaultInt(s));
            }
            if (type.isDouble(s)) {
                query.append(", ").append(lower).append(" DOUBLE(24,12) default ").append(type.getDefaultDouble(s));
            }
            if (type.isFloat(s)) {
                query.append(", ").append(lower).append(" FLOAT default ").append(type.getDefaultFloat(s));
            }
            if (type.isStringSet(s)) {
                query.append(", ").append(lower).append(" TEXT");
            }
            if (!type.isBoolean(s)) continue;
            query.append(", ").append(lower).append(" BOOLEAN default ").append(type.getDefaultBoolean(s));
        }
        query.append(");");
        try (PreparedStatement stmt = this.getConnection().prepareStatement(query.toString());){
            stmt.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        for (String s : type.getAllStatNames()) {
            lower = s.toLowerCase(Locale.US);
            if (type.isInt(s)) {
                this.addColumnIfNotExists(type.getTableName(), lower, "INTEGER default " + type.getDefaultInt(s));
            }
            if (type.isDouble(s)) {
                this.addColumnIfNotExists(type.getTableName(), lower, "DOUBLE default " + type.getDefaultDouble(s));
            }
            if (type.isFloat(s)) {
                this.addColumnIfNotExists(type.getTableName(), lower, "FLOAT default " + type.getDefaultFloat(s));
            }
            if (type.isStringSet(s)) {
                this.addColumnIfNotExists(type.getTableName(), lower, "TEXT");
            }
            if (!type.isBoolean(s)) continue;
            this.addColumnIfNotExists(type.getTableName(), lower, "BOOLEAN default " + type.getDefaultBoolean(s));
        }
    }

    public boolean hasProfileTable(Profile type) {
        boolean bl;
        block8: {
            ResultSet rs = this.getConnection().getMetaData().getTables(null, null, type.getTableName(), null);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    ValhallaMMO.logWarning("Could not check if profile table exists for " + type.getTableName() + " " + String.valueOf(e));
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    public boolean deleteProfileTable(Profile profile) {
        boolean bl;
        block8: {
            PreparedStatement stmt = this.getConnection().prepareStatement("DROP TABLE IF EXISTS " + profile.getTableName() + ";");
            try {
                stmt.execute();
                bl = true;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    ValhallaMMO.logSevere("SQLException when trying to delete profile table for " + profile.getTableName() + ". ");
                    e.printStackTrace();
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    public ClassToInstanceMap<Profile> loadProfile(UUID uuid) {
        MutableClassToInstanceMap profiles = MutableClassToInstanceMap.create();
        boolean runPersistentStartingPerks = false;
        for (Class<? extends Profile> clazz : ProfileRegistry.getRegisteredProfiles().keySet()) {
            Profile profile = ProfileRegistry.getBlankProfile(uuid, clazz);
            if (!this.fillProfile(uuid, profile)) {
                runPersistentStartingPerks = true;
            }
            profiles.put(clazz, (Object)profile);
        }
        AccumulativeStatManager.resetAllCaches(uuid);
        JoinLeaveListener.getLoadedProfiles().add(uuid);
        boolean finalRunPersistentStartingPerks = runPersistentStartingPerks;
        Bukkit.getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                Utils.sendMessage((CommandSender)player, TranslationManager.getTranslation("status_profiles_loaded"));
                SkillRegistry.updateSkillProgression(player, finalRunPersistentStartingPerks);
            } else {
                this.uncacheProfile(uuid);
            }
        });
        return profiles;
    }

    public void saveAllProfiles(boolean async) {
        for (UUID uuid : this.persistentProfiles.asMap().keySet()) {
            if (async) {
                this.saveProfileAsync(uuid);
                continue;
            }
            this.saveProfile(uuid, true);
        }
    }

    public void saveProfileAsync(UUID p) {
        if (!this.saving.add(p)) {
            return;
        }
        CompletableFuture.runAsync(() -> this.saveProfile(p, false), this.profileThreads).whenComplete((ignored, ex) -> {
            if (ex != null) {
                ValhallaMMO.logWarning("Exception when trying to save profile for " + String.valueOf(p) + ": ");
                ex.printStackTrace();
            }
            this.saving.remove(p);
        });
    }

    public void saveProfile(UUID p, boolean localLock) {
        Player player;
        if (!this.isLoaded(p)) {
            return;
        }
        if (localLock && !this.saving.add(p)) {
            return;
        }
        ClassToInstanceMap<Profile> profiles = this.persistentProfiles.get(p).join();
        for (Profile profile : profiles.values()) {
            if (!this.shouldPersist(profile)) continue;
            this.insertOrUpdateProfile(p, profile);
        }
        if (localLock) {
            this.saving.remove(p);
        }
        if ((player = Bukkit.getPlayer((UUID)p)) == null || !player.isOnline()) {
            this.uncacheProfile(p);
        }
    }

    public void uncacheProfile(UUID p) {
        this.persistentProfiles.synchronous().invalidate(p);
        this.skillProfiles.remove(p);
        JoinLeaveListener.getLoadedProfiles().remove(p);
        ProfileCache.resetCache(p);
    }

    public void uncacheAllProfiles() {
        this.persistentProfiles.synchronous().invalidateAll();
        this.skillProfiles.clear();
        JoinLeaveListener.getLoadedProfiles().clear();
        ProfileCache.resetAllCaches();
    }

    public abstract int minimumProfileThreadCount();

    public Connection getConnection() {
        return this.getConnection(false);
    }

    public abstract Connection getConnection(boolean var1);

    public abstract void addColumnIfNotExists(String var1, String var2, String var3);

    public abstract String getType();

    public boolean isLoaded(UUID p) {
        CompletableFuture future = this.persistentProfiles.getIfPresent(p);
        return future != null && future.isDone();
    }

    public <T extends Profile> void trySetPersistentProfile(UUID p, Profile profile, Class<T> type) {
        if (type.isInstance(profile)) {
            this.setPersistentProfile(p, (Profile)type.cast(profile), type);
        } else {
            ValhallaMMO.logWarning("Tried to set persistent profile of type " + type.getSimpleName() + " for player " + String.valueOf(p) + ", but the profile is of type " + profile.getClass().getSimpleName() + ". This is likely a bug in the plugin, please report it.");
        }
    }

    public <T extends Profile> void trySetSkillProfile(UUID p, Profile profile, Class<T> type) {
        if (type.isInstance(profile)) {
            this.setSkillProfile(p, (Profile)type.cast(profile), type);
        } else {
            ValhallaMMO.logWarning("Tried to set skill profile of type " + type.getSimpleName() + " for player " + String.valueOf(p) + ", but the profile is of type " + profile.getClass().getSimpleName() + ". This is likely a bug in the plugin, please report it.");
        }
    }

    public <T extends Profile> void setPersistentProfile(UUID p, T profile, Class<T> type) {
        ClassToInstanceMap<Profile> profiles = this.persistentProfiles.get(p).join();
        profiles.put(type, profile);
        this.persistentProfiles.put(p, CompletableFuture.completedFuture(profiles));
        ProfilePersistence.scheduleProfilePersisting(p, type);
    }

    public <T extends Profile> void setSkillProfile(UUID p, T profile, Class<T> type) {
        ClassToInstanceMap<Profile> profiles = this.skillProfiles.getOrDefault(p, (ClassToInstanceMap<Profile>)MutableClassToInstanceMap.create());
        profiles.put(type, profile);
        this.skillProfiles.put(p, profiles);
    }

    public <T extends Profile> T getPersistentProfile(UUID p, Class<T> type) {
        CompletableFuture future = this.persistentProfiles.getIfPresent(p);
        if (future == null || !future.isDone()) {
            return null;
        }
        ClassToInstanceMap profiles = (ClassToInstanceMap)future.join();
        return (T)(profiles == null ? null : (Profile)profiles.getInstance(type));
    }

    public <T extends Profile> T getSkillProfile(UUID p, Class<T> type) {
        Player player;
        MutableClassToInstanceMap profiles = this.skillProfiles.get(p);
        if (profiles == null && this.isLoaded(p) && (player = Bukkit.getPlayer((UUID)p)) != null) {
            profiles = MutableClassToInstanceMap.create();
            for (Class<? extends Profile> pr : ProfileRegistry.getRegisteredProfiles().keySet()) {
                Profile instance = ProfileRegistry.getBlankProfile(p, pr);
                profiles.put(pr, (Object)instance);
            }
            this.skillProfiles.put(p, (ClassToInstanceMap<Profile>)profiles);
            SkillRegistry.updateSkillProgression(player, false);
            ValhallaMMO.logWarning("An experimental method of stat recalculation was used on " + player.getName() + " to ensure they still have the stats they are supposed to (as opposed to nothing). Please keep an eye out for issues and report them to me :)");
        }
        return (T)(profiles == null ? null : (Profile)profiles.getInstance(type));
    }

    public Map<Integer, LeaderboardEntry> queryLeaderboardEntries(LeaderboardManager.Leaderboard leaderboard) {
        HashMap<Integer, LeaderboardEntry> entries = new HashMap<Integer, LeaderboardEntry>();
        Profile profile = ProfileRegistry.getRegisteredProfiles().get(leaderboard.profile());
        String query = ProfilePersistence.leaderboardQuery(profile, leaderboard.mainStat(), leaderboard.extraStats());
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(query);
            ResultSet set = stmt.executeQuery();
            int rank = 1;
            while (set.next()) {
                double value = set.getDouble("main_stat");
                UUID uuid = UUID.fromString(set.getString("owner"));
                OfflinePlayer player = ValhallaMMO.getInstance().getServer().getOfflinePlayer(uuid);
                if (LeaderboardManager.getExcludedPlayers().contains(player.getName())) continue;
                HashMap<String, Double> extraStat = new HashMap<String, Double>();
                for (Pair<String, Double> e : leaderboard.extraStats().values()) {
                    extraStat.put(e.getOne(), set.getDouble(e.getOne()));
                }
                entries.put(rank, new LeaderboardEntry(player.getName(), player.getUniqueId(), value, rank, extraStat));
                ++rank;
            }
        }
        catch (SQLException ex) {
            ValhallaMMO.logWarning("Could not fetch leaderboard due to an exception: ");
            ValhallaMMO.logWarning("Query used: \n" + query);
            ex.printStackTrace();
        }
        return entries;
    }

    public void resetProfile(Player p, ResetType resetType) {
        UUID uuid = p.getUniqueId();
        boolean runPersistentStartingPerks = false;
        switch (resetType) {
            case STATS_ONLY: {
                for (Profile profileType : ProfileRegistry.getRegisteredProfiles().values()) {
                    Object persistentProfile = ProfileRegistry.getPersistentProfile(p, profileType.getClass());
                    double totalEXP = ((Profile)persistentProfile).getTotalEXP();
                    double EXP = ((Profile)persistentProfile).getEXP();
                    int level = ((Profile)persistentProfile).getLevel();
                    int ngPlus = ((Profile)persistentProfile).getNewGamePlus();
                    Profile resetProfile = profileType.getBlankProfile(p.getUniqueId());
                    resetProfile.setTotalEXP(totalEXP);
                    resetProfile.setEXP(EXP);
                    resetProfile.setLevel(level);
                    resetProfile.setNewGamePlus(ngPlus);
                    runPersistentStartingPerks = true;
                    this.trySetPersistentProfile(uuid, resetProfile, profileType.getClass());
                }
                ProfilePersistence.markProfilesReset(p.getUniqueId(), ProfileRegistry.getRegisteredProfiles().keySet());
                break;
            }
            case SKILLS_ONLY: {
                PowerProfile powerProfile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
                for (Profile profileType : ProfileRegistry.getRegisteredProfiles().values()) {
                    Object profile = this.getPersistentProfile(uuid, profileType.getClass());
                    ((Profile)profile).setEXP(0.0);
                    ((Profile)profile).setTotalEXP(0.0);
                    ((Profile)profile).setLevel(0);
                    ((Profile)profile).setNewGamePlus(0);
                    this.trySetPersistentProfile(uuid, (Profile)profile, profileType.getClass());
                    Skill associatedSkill = SkillRegistry.getSkill(profileType.getSkillType());
                    associatedSkill.getPerks().forEach(perk -> {
                        Collection<String> unlockedPerks = powerProfile.getUnlockedPerks();
                        unlockedPerks.remove(perk.getName());
                        powerProfile.setUnlockedPerks(unlockedPerks);
                    });
                    this.trySetSkillProfile(uuid, profileType.getBlankProfile(p), profileType.getClass());
                }
                this.setPersistentProfile(uuid, powerProfile, PowerProfile.class);
                ProfilePersistence.markProfilesReset(p.getUniqueId(), ProfileRegistry.getRegisteredProfiles().keySet());
                break;
            }
            case SKILLS_AND_STATS: {
                for (Profile profileType : ProfileRegistry.getRegisteredProfiles().values()) {
                    this.trySetPersistentProfile(uuid, profileType.getBlankProfile(p), profileType.getClass());
                    this.trySetSkillProfile(uuid, profileType.getBlankProfile(p), profileType.getClass());
                }
                runPersistentStartingPerks = true;
                ProfilePersistence.markProfilesReset(p.getUniqueId(), ProfileRegistry.getRegisteredProfiles().keySet());
                break;
            }
            case SKILLS_REFUND_EXP: {
                PowerProfile powerProfile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
                powerProfile.setUnlockedPerks(new HashSet<String>());
                powerProfile.setFakeUnlockedPerks(new HashSet<String>());
                powerProfile.setPermanentlyLockedPerks(new HashSet<String>());
                ProfileRegistry.setPersistentProfile(p, powerProfile, PowerProfile.class);
                this.setSkillProfile(uuid, ProfileRegistry.getBlankProfile(p, PowerProfile.class), PowerProfile.class);
                for (Profile profileType : ProfileRegistry.getRegisteredProfiles().values()) {
                    if (profileType instanceof PowerProfile) continue;
                    this.trySetSkillProfile(uuid, profileType.getBlankProfile(p), profileType.getClass());
                }
                ProfilePersistence.markProfilesReset(p.getUniqueId(), ProfileRegistry.getRegisteredProfiles().keySet());
            }
        }
        SkillRegistry.updateSkillProgression(p, runPersistentStartingPerks);
    }

    public <S extends Skill> void resetSkillProgress(Player p, Class<S> resetSkill) {
        UUID uuid = p.getUniqueId();
        PowerProfile powerProfile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        Skill associatedSkill = SkillRegistry.getSkill(resetSkill);
        Profile profile = this.getPersistentProfile(uuid, associatedSkill.getProfileType());
        profile.setEXP(0.0);
        profile.setLevel(0);
        this.trySetPersistentProfile(uuid, profile, associatedSkill.getProfileType());
        Collection<String> unlockedPerks = powerProfile.getUnlockedPerks();
        HashSet<String> unlockedPerksCopy = new HashSet<String>(powerProfile.getUnlockedPerks());
        unlockedPerks.removeAll(associatedSkill.getPerks().stream().map(Perk::getName).collect(Collectors.toSet()));
        powerProfile.setUnlockedPerks(unlockedPerks);
        this.setPersistentProfile(uuid, powerProfile, PowerProfile.class);
        ArrayList<Perk> invertedPerks = new ArrayList<Perk>(associatedSkill.getPerks());
        Collections.reverse(invertedPerks);
        invertedPerks.forEach(perk -> {
            if (!unlockedPerksCopy.contains(perk.getName())) {
                return;
            }
            for (ResourceExpense expense : perk.getExpenses()) {
                if (!expense.isRefundable()) continue;
                expense.refund(p);
            }
        });
        this.trySetSkillProfile(uuid, profile.getBlankProfile(uuid), associatedSkill.getProfileType());
        SkillRegistry.updateSkillProgression(p, false);
        Collection profilesToReset = resetProfiles.getOrDefault(p.getUniqueId(), new HashSet());
        profilesToReset.add(profile.getClass());
        ProfilePersistence.markProfilesReset(p.getUniqueId(), profilesToReset);
    }

    public static void scheduleProfilePersisting(UUID p, Class<? extends Profile> typeToSave) {
        Collection types = PROFILES_TO_SAVE.getOrDefault(p, new HashSet());
        types.add(typeToSave);
        PROFILES_TO_SAVE.put(p, types);
    }

    public boolean shouldPersist(Profile profile) {
        PowerProfile p;
        Collection profilesToReset = resetProfiles.getOrDefault(profile.getOwner(), new HashSet());
        if (profilesToReset.contains(profile.getClass())) {
            profilesToReset.remove(profile.getClass());
            resetProfiles.put(profile.getOwner(), profilesToReset);
            return true;
        }
        if (profile.getOwner() == null || !(profile instanceof PowerProfile) && profile.getLevel() == 0 && profile.getNewGamePlus() == 0 && !profile.shouldForcePersist()) {
            return false;
        }
        if (profile instanceof PowerProfile && (p = (PowerProfile)profile).getUnlockedPerks().isEmpty() && p.getTotalEXP() <= 0.0) {
            return false;
        }
        return ((Collection)PROFILES_TO_SAVE.getOrDefault(profile.getOwner(), Set.of())).contains(profile.getClass());
    }

    public static String serializeStringSet(Collection<String> stringSet) {
        return String.join((CharSequence)"<>", stringSet);
    }

    public static Set<String> deserializeStringSet(String serializedStringSet) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(serializedStringSet.split("<>")));
        set.removeIf(String::isEmpty);
        return set;
    }

    public static void markProfilesReset(UUID owner, Collection<Class<? extends Profile>> profileTypes) {
        resetProfiles.put(owner, profileTypes);
    }
}

