/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.persistence.implementations;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.persistence.ProfilePersistence;

public class SQLite
extends ProfilePersistence {
    private Connection conn;

    @Override
    public int minimumProfileThreadCount() {
        return 2;
    }

    @Override
    public Connection getConnection(boolean migrating) {
        File dataFolder = new File(ValhallaMMO.getInstance().getDataFolder(), "player_data.db");
        if (!dataFolder.exists()) {
            if (migrating) {
                ValhallaMMO.logWarning("SQLite database file player_data.db does not exist, cannot migrate from it.");
                return null;
            }
            try {
                if (dataFolder.createNewFile()) {
                    ValhallaMMO.logInfo("New player_data.db file created!");
                }
            }
            catch (IOException e) {
                ValhallaMMO.logSevere("Could not create SQLite database file player_data.db");
            }
        }
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                return this.conn;
            }
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dataFolder));
            ValhallaMMO.logFine(migrating ? "Old SQLite connection created for migration!" : "SQLite connection created! Deleting this file will reset everyone's progress, so back this file up or ignore it in case you want to delete/reset the configs.");
            return this.conn;
        }
        catch (SQLException ex) {
            ValhallaMMO.logSevere("SQLite exception on initialize " + String.valueOf(ex));
        }
        catch (ClassNotFoundException ex) {
            ValhallaMMO.logInfo("You do not have the SQLite JDBC library on your server");
        }
        return null;
    }

    @Override
    public void addColumnIfNotExists(String tableName, String columnName, String columnType) {
        try {
            PreparedStatement procedureCreationStatement = this.conn.prepareStatement("SELECT " + columnName + " FROM " + tableName + ";");
            procedureCreationStatement.execute();
        }
        catch (SQLException e) {
            try {
                PreparedStatement procedureCreationStatement = this.conn.prepareStatement("ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + columnType + ";");
                procedureCreationStatement.execute();
            }
            catch (SQLException ex) {
                ValhallaMMO.logSevere("SQLException when trying to add column " + columnName + " " + columnType + " to " + tableName + ". ");
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getType() {
        return "sqlite";
    }
}

