/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.placeholder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.hooks.PAPIHook;
import me.athlaeos.valhallammo.placeholder.Placeholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyDescriptionPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyExpPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyExpRequiredPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyExpSharingPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyItemSharingPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyLeaderPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyLevelNumericPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyLevelPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyLevelRomanPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyMemberCapPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyMemberCountPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyMembersPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyNamePlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyNearbyMembersPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyOnlineMembersPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyOpenPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.PartyRankPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.RegionalDifficultyLevelPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.RegionalDifficultyLevelRoundedPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.SpendablePrestigePointsPlaceholder;
import me.athlaeos.valhallammo.placeholder.placeholders.SpendableSkillPointsPlaceholder;
import org.bukkit.entity.Player;

public class PlaceholderRegistry {
    private static final Map<String, Placeholder> placeholders = new HashMap<String, Placeholder>();
    private static final Map<String, Collection<Placeholder>> placeholderCache;

    public static void registerPlaceholder(Placeholder p) {
        placeholders.put(p.getPlaceholder(), p);
    }

    public static Map<String, Placeholder> getPlaceholders() {
        return placeholders;
    }

    public static String parse(String stringToParse, Player p) {
        String result = stringToParse;
        boolean cache = !placeholderCache.containsKey(stringToParse);
        HashSet<Placeholder> placeholdersToCache = new HashSet<Placeholder>();
        for (Placeholder s : placeholderCache.getOrDefault(stringToParse, placeholders.values())) {
            if (!stringToParse.contains(s.getPlaceholder())) continue;
            result = s.parse(result, p);
            if (!cache) continue;
            placeholdersToCache.add(s);
        }
        if (cache) {
            placeholderCache.put(stringToParse, placeholdersToCache);
        }
        return result;
    }

    public static String parsePapi(String stringToParse, Player p) {
        if (ValhallaMMO.isHookFunctional(PAPIHook.class)) {
            return PAPIHook.parse(p, stringToParse);
        }
        return stringToParse;
    }

    static {
        PlaceholderRegistry.registerPlaceholder(new SpendableSkillPointsPlaceholder("%skillpoints%"));
        PlaceholderRegistry.registerPlaceholder(new SpendablePrestigePointsPlaceholder("%prestigepoints%"));
        PlaceholderRegistry.registerPlaceholder(new RegionalDifficultyLevelPlaceholder("%difficulty_regional%"));
        PlaceholderRegistry.registerPlaceholder(new RegionalDifficultyLevelRoundedPlaceholder("%difficulty_regional_rounded%"));
        PlaceholderRegistry.registerPlaceholder(new PartyNamePlaceholder("%party_name%"));
        PlaceholderRegistry.registerPlaceholder(new PartyDescriptionPlaceholder("%party_description%"));
        PlaceholderRegistry.registerPlaceholder(new PartyExpPlaceholder("%party_current_exp%"));
        PlaceholderRegistry.registerPlaceholder(new PartyExpRequiredPlaceholder("%party_exp_next_level%"));
        PlaceholderRegistry.registerPlaceholder(new PartyExpSharingPlaceholder("%party_exp_sharing_enabled%"));
        PlaceholderRegistry.registerPlaceholder(new PartyItemSharingPlaceholder("%party_item_sharing_enabled%"));
        PlaceholderRegistry.registerPlaceholder(new PartyLeaderPlaceholder("%party_leader%"));
        PlaceholderRegistry.registerPlaceholder(new PartyLevelNumericPlaceholder("%party_level_numeric%"));
        PlaceholderRegistry.registerPlaceholder(new PartyLevelPlaceholder("%party_level_name%"));
        PlaceholderRegistry.registerPlaceholder(new PartyLevelRomanPlaceholder("%party_level_roman%"));
        PlaceholderRegistry.registerPlaceholder(new PartyMemberCapPlaceholder("%party_member_capacity%"));
        PlaceholderRegistry.registerPlaceholder(new PartyMemberCountPlaceholder("%party_member_count%"));
        PlaceholderRegistry.registerPlaceholder(new PartyMembersPlaceholder("%party_members%"));
        PlaceholderRegistry.registerPlaceholder(new PartyNearbyMembersPlaceholder("%party_members_nearby%"));
        PlaceholderRegistry.registerPlaceholder(new PartyOnlineMembersPlaceholder("%party_members_online%"));
        PlaceholderRegistry.registerPlaceholder(new PartyOpenPlaceholder("%party_open%"));
        PlaceholderRegistry.registerPlaceholder(new PartyRankPlaceholder("%party_rank%"));
        placeholderCache = new HashMap<String, Collection<Placeholder>>();
    }
}

