/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.utility.EntityUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class EntityCache {
    private static final long CACHE_REFRESH_DELAY = 10000L;
    private static final long CACHE_CLEANUP_DELAY = 600000L;
    private static final Map<UUID, EntityProperties> cachedProperties = new HashMap<UUID, EntityProperties>();
    private static final Map<UUID, Long> lastCacheRefreshMap = new HashMap<UUID, Long>();
    private static long lastCacheCleanup = System.currentTimeMillis();

    public static EntityProperties getAndCacheProperties(LivingEntity entity) {
        EntityCache.attemptCacheCleanup();
        Long lastCached = lastCacheRefreshMap.get(entity.getUniqueId());
        EntityProperties cached = cachedProperties.get(entity.getUniqueId());
        if (lastCached == null || cached == null || lastCached + 10000L <= System.currentTimeMillis()) {
            lastCacheRefreshMap.put(entity.getUniqueId(), System.currentTimeMillis());
            cachedProperties.put(entity.getUniqueId(), EntityUtils.getEntityProperties(entity, true, true, true));
        }
        return cachedProperties.get(entity.getUniqueId());
    }

    public static void resetHands(LivingEntity entity) {
        cachedProperties.computeIfPresent(entity.getUniqueId(), (uuid, cached) -> EntityUtils.updateProperties(cached, entity, false, true, false));
    }

    public static void resetEquipment(LivingEntity entity) {
        cachedProperties.computeIfPresent(entity.getUniqueId(), (uuid, cached) -> EntityUtils.updateProperties(cached, entity, true, false, false));
    }

    public static void resetPotionEffects(LivingEntity entity) {
        cachedProperties.computeIfPresent(entity.getUniqueId(), (uuid, cached) -> EntityUtils.updateProperties(cached, entity, false, false, true));
    }

    public static void removeProperties(LivingEntity entity) {
        cachedProperties.remove(entity.getUniqueId());
    }

    public static void attemptCacheCleanup() {
        Bukkit.getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            if (lastCacheCleanup + 600000L < System.currentTimeMillis()) {
                for (UUID uuid : new HashSet<UUID>(cachedProperties.keySet())) {
                    Entity entity = Bukkit.getEntity((UUID)uuid);
                    if (entity != null && entity.isValid()) continue;
                    cachedProperties.remove(uuid);
                    lastCacheRefreshMap.remove(uuid);
                }
                lastCacheCleanup = System.currentTimeMillis();
            }
        });
    }
}

