/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.PermanentPotionEffects;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class EntityProperties {
    private ItemBuilder helmet = null;
    private Map<String, AttributeWrapper> helmetAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> helmetPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private ItemBuilder chestplate = null;
    private Map<String, AttributeWrapper> chestplateAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> chestplatePotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private ItemBuilder leggings = null;
    private Map<String, AttributeWrapper> leggingsAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> leggingsPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private ItemBuilder boots = null;
    private Map<String, AttributeWrapper> bootsAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> bootsPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private ItemBuilder mainHand = null;
    private Map<String, AttributeWrapper> mainHandAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> mainHandPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private ItemBuilder offHand = null;
    private Map<String, AttributeWrapper> offHandAttributes = new HashMap<String, AttributeWrapper>();
    private Map<String, List<PotionEffectWrapper>> offHandPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private final List<ItemBuilder> miscEquipment = new ArrayList<ItemBuilder>();
    private final Map<ItemBuilder, Map<String, AttributeWrapper>> miscEquipmentAttributes = new HashMap<ItemBuilder, Map<String, AttributeWrapper>>();
    private final Map<ItemBuilder, Map<String, List<PotionEffectWrapper>>> miscEquipmentPotionEffects = new HashMap<ItemBuilder, Map<String, List<PotionEffectWrapper>>>();
    private Map<String, List<PotionEffectWrapper>> powerPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();
    private int heavyArmorCount = 0;
    private int lightArmorCount = 0;
    private int weightlessArmorCount = 0;
    private int noWeightArmorCount = 0;
    private final Map<String, CustomPotionEffect> activePotionEffects = new HashMap<String, CustomPotionEffect>();
    private final Map<Enchantment, Integer> combinedEnchantments = new HashMap<Enchantment, Integer>();
    private final Map<String, List<PotionEffectWrapper>> permanentPotionEffects = new HashMap<String, List<PotionEffectWrapper>>();

    public EntityProperties() {
    }

    public EntityProperties(ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots, ItemStack mainHand, ItemStack offHand) {
        this.helmet = ItemUtils.isEmpty(helmet) ? null : new ItemBuilder(helmet);
        this.chestplate = ItemUtils.isEmpty(chestplate) ? null : new ItemBuilder(chestplate);
        this.leggings = ItemUtils.isEmpty(leggings) ? null : new ItemBuilder(leggings);
        this.boots = ItemUtils.isEmpty(boots) ? null : new ItemBuilder(boots);
        this.mainHand = ItemUtils.isEmpty(mainHand) ? null : new ItemBuilder(mainHand);
        this.offHand = ItemUtils.isEmpty(offHand) ? null : new ItemBuilder(offHand);
    }

    public void addCombinedEnchantments(ItemBuilder builder) {
        if (builder == null) {
            return;
        }
        for (Map.Entry entry : builder.getItem().getEnchantments().entrySet()) {
            int existingLevel = this.combinedEnchantments.getOrDefault(entry.getKey(), 0);
            this.combinedEnchantments.put((Enchantment)entry.getKey(), existingLevel + (Integer)entry.getValue());
        }
    }

    public Map<String, CustomPotionEffect> getActivePotionEffects() {
        return this.activePotionEffects;
    }

    public int getHeavyArmorCount() {
        return this.heavyArmorCount;
    }

    public void setHeavyArmorCount(int heavyArmorCount) {
        this.heavyArmorCount = heavyArmorCount;
    }

    public int getLightArmorCount() {
        return this.lightArmorCount;
    }

    public int getNoArmorCount() {
        return this.noWeightArmorCount;
    }

    public void setNoArmorCount(int count) {
        this.noWeightArmorCount = count;
    }

    public void setLightArmorCount(int lightArmorCount) {
        this.lightArmorCount = lightArmorCount;
    }

    public int getWeightlessArmorCount() {
        return this.weightlessArmorCount;
    }

    public void setWeightlessArmorCount(int weightlessArmorCount) {
        this.weightlessArmorCount = weightlessArmorCount;
    }

    public List<ItemBuilder> getMiscEquipment() {
        return this.miscEquipment;
    }

    public ItemBuilder getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = ItemUtils.isEmpty(helmet) ? null : new ItemBuilder(helmet);
    }

    public ItemBuilder getChestplate() {
        return this.chestplate;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = ItemUtils.isEmpty(chestplate) ? null : new ItemBuilder(chestplate);
    }

    public ItemBuilder getBoots() {
        return this.boots;
    }

    public void setBoots(ItemStack boots) {
        this.boots = ItemUtils.isEmpty(boots) ? null : new ItemBuilder(boots);
    }

    public ItemBuilder getLeggings() {
        return this.leggings;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = ItemUtils.isEmpty(leggings) ? null : new ItemBuilder(leggings);
    }

    public ItemBuilder getMainHand() {
        return this.mainHand;
    }

    public void setMainHand(ItemStack mainHand) {
        this.mainHand = ItemUtils.isEmpty(mainHand) ? null : new ItemBuilder(mainHand);
    }

    public ItemBuilder getOffHand() {
        return this.offHand;
    }

    public void setOffHand(ItemStack offHand) {
        this.offHand = ItemUtils.isEmpty(offHand) ? null : new ItemBuilder(offHand);
    }

    public Map<Enchantment, Integer> getCombinedEnchantments() {
        return this.combinedEnchantments;
    }

    public Map<String, List<PotionEffectWrapper>> getPermanentPotionEffects() {
        return this.permanentPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getPowerPotionEffects() {
        return this.powerPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getBootsPotionEffects() {
        return this.bootsPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getChestplatePotionEffects() {
        return this.chestplatePotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getHelmetPotionEffects() {
        return this.helmetPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getLeggingsPotionEffects() {
        return this.leggingsPotionEffects;
    }

    public Map<ItemBuilder, Map<String, List<PotionEffectWrapper>>> getMiscEquipmentPotionEffects() {
        return this.miscEquipmentPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getMainHandPotionEffects() {
        return this.mainHandPotionEffects;
    }

    public Map<String, List<PotionEffectWrapper>> getOffHandPotionEffects() {
        return this.offHandPotionEffects;
    }

    public void setPowerPotionEffects(Map<String, List<PotionEffectWrapper>> powerPotionEffects) {
        this.powerPotionEffects = powerPotionEffects;
    }

    public void setBootsPotionEffects(Map<String, List<PotionEffectWrapper>> bootsPotionEffects) {
        this.bootsPotionEffects = bootsPotionEffects;
    }

    public void setChestplatePotionEffects(Map<String, List<PotionEffectWrapper>> chestplatePotionEffects) {
        this.chestplatePotionEffects = chestplatePotionEffects;
    }

    public void setHelmetPotionEffects(Map<String, List<PotionEffectWrapper>> helmetPotionEffects) {
        this.helmetPotionEffects = helmetPotionEffects;
    }

    public void setLeggingsPotionEffects(Map<String, List<PotionEffectWrapper>> leggingsPotionEffects) {
        this.leggingsPotionEffects = leggingsPotionEffects;
    }

    public void setMainHandPotionEffects(Map<String, List<PotionEffectWrapper>> mainHandPotionEffects) {
        this.mainHandPotionEffects = mainHandPotionEffects;
    }

    public void setOffHandPotionEffects(Map<String, List<PotionEffectWrapper>> offHandPotionEffects) {
        this.offHandPotionEffects = offHandPotionEffects;
    }

    public List<ItemBuilder> getIterable(boolean includeHands, Boolean hand) {
        List<ItemBuilder> iterable = this.getArmor();
        if (!this.miscEquipmentAttributes.isEmpty()) {
            iterable.addAll(this.miscEquipment);
        }
        if (includeHands) {
            if ((hand == null || hand.booleanValue()) && this.mainHand != null) {
                iterable.add(this.mainHand);
            }
            if (!(hand != null && hand.booleanValue() || this.offHand == null)) {
                iterable.add(this.offHand);
            }
        }
        return iterable;
    }

    public List<ItemBuilder> getArmor() {
        ArrayList<ItemBuilder> armor = new ArrayList<ItemBuilder>();
        if (this.helmet != null) {
            armor.add(this.helmet);
        }
        if (this.chestplate != null) {
            armor.add(this.chestplate);
        }
        if (this.leggings != null) {
            armor.add(this.leggings);
        }
        if (this.boots != null) {
            armor.add(this.boots);
        }
        return armor;
    }

    public List<Map<String, AttributeWrapper>> attributeIterable(boolean includeHands, Boolean hand) {
        ArrayList<Map<String, AttributeWrapper>> iterable = new ArrayList<Map<String, AttributeWrapper>>();
        if (this.helmetAttributes != null && !this.helmetAttributes.isEmpty()) {
            iterable.add(this.helmetAttributes);
        }
        if (this.chestplateAttributes != null && !this.chestplateAttributes.isEmpty()) {
            iterable.add(this.chestplateAttributes);
        }
        if (this.leggingsAttributes != null && !this.leggingsAttributes.isEmpty()) {
            iterable.add(this.leggingsAttributes);
        }
        if (this.bootsAttributes != null && !this.bootsAttributes.isEmpty()) {
            iterable.add(this.bootsAttributes);
        }
        if (!this.miscEquipment.isEmpty()) {
            iterable.addAll(this.miscEquipmentAttributes.values());
        }
        if (includeHands) {
            if ((hand == null || hand.booleanValue()) && this.mainHandAttributes != null && !this.mainHandAttributes.isEmpty()) {
                iterable.add(this.mainHandAttributes);
            }
            if (!(hand != null && hand.booleanValue() || this.offHandAttributes == null || this.offHandAttributes.isEmpty())) {
                iterable.add(this.offHandAttributes);
            }
        }
        return iterable;
    }

    public List<ItemBuilder> getHands() {
        ArrayList<ItemBuilder> iterable = new ArrayList<ItemBuilder>();
        if (this.mainHand != null) {
            iterable.add(this.mainHand);
        }
        if (this.offHand != null) {
            iterable.add(this.offHand);
        }
        return iterable;
    }

    public Map<String, AttributeWrapper> getBootsAttributes() {
        return this.bootsAttributes;
    }

    public Map<String, AttributeWrapper> getChestPlateAttributes() {
        return this.chestplateAttributes;
    }

    public Map<String, AttributeWrapper> getHelmetAttributes() {
        return this.helmetAttributes;
    }

    public Map<String, AttributeWrapper> getLeggingsAttributes() {
        return this.leggingsAttributes;
    }

    public Map<ItemBuilder, Map<String, AttributeWrapper>> getMiscEquipmentAttributes() {
        return this.miscEquipmentAttributes;
    }

    public Map<String, AttributeWrapper> getMainHandAttributes() {
        return this.mainHandAttributes;
    }

    public Map<String, AttributeWrapper> getOffHandAttributes() {
        return this.offHandAttributes;
    }

    public void setBootsAttributes(Map<String, AttributeWrapper> bootsAttributes) {
        this.bootsAttributes = bootsAttributes;
    }

    public void setChestPlateAttributes(Map<String, AttributeWrapper> chestplateAttributes) {
        this.chestplateAttributes = chestplateAttributes;
    }

    public void setHelmetAttributes(Map<String, AttributeWrapper> helmetAttributes) {
        this.helmetAttributes = helmetAttributes;
    }

    public void setLeggingsAttributes(Map<String, AttributeWrapper> leggingsAttributes) {
        this.leggingsAttributes = leggingsAttributes;
    }

    public void setMainHandAttributes(Map<String, AttributeWrapper> mainHandAttributes) {
        this.mainHandAttributes = mainHandAttributes;
    }

    public void setOffHandAttributes(Map<String, AttributeWrapper> offHandAttributes) {
        this.offHandAttributes = offHandAttributes;
    }

    public void computePermanentEffects() {
        this.permanentPotionEffects.clear();
        ArrayList<Map<String, List<PotionEffectWrapper>>> effects = new ArrayList<Map<String, List<PotionEffectWrapper>>>();
        effects.add(this.powerPotionEffects);
        effects.add(this.helmetPotionEffects);
        effects.add(this.chestplatePotionEffects);
        effects.add(this.leggingsPotionEffects);
        effects.add(this.bootsPotionEffects);
        effects.add(this.mainHandPotionEffects);
        effects.add(this.offHandPotionEffects);
        effects.addAll(this.miscEquipmentPotionEffects.values());
        this.permanentPotionEffects.putAll(PermanentPotionEffects.getCombinedEffects(effects));
    }
}

