/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ProfileCache {
    private static final Map<UUID, Map<Class<? extends Profile>, CacheEntry>> cache = new ConcurrentHashMap<UUID, Map<Class<? extends Profile>, CacheEntry>>();
    private static final long cacheDuration = ValhallaMMO.getPluginConfig().getLong("profile_caching", 10000L);

    public static void resetCache(UUID uuid) {
        cache.remove(uuid);
    }

    public static void resetCache(Player player) {
        cache.remove(player.getUniqueId());
    }

    public static void resetCache(Player player, Class<? extends Profile> type) {
        ProfileCache.resetCache(player.getUniqueId(), type);
    }

    public static void resetCache(UUID uuid, Class<? extends Profile> type) {
        Map<Class<? extends Profile>, CacheEntry> profiles = cache.get(uuid);
        if (profiles != null) {
            profiles.remove(type);
        }
    }

    public static void resetAllCaches() {
        cache.clear();
    }

    public static <T extends Profile> T getOrCache(Player player, Class<T> type) {
        Map profiles = cache.getOrDefault(player.getUniqueId(), new HashMap());
        CacheEntry entry = (CacheEntry)profiles.get(type);
        if (entry == null || entry.getCacheUntil() < System.currentTimeMillis()) {
            entry = new CacheEntry((Profile)(ProfileRegistry.isLoaded(player) ? ProfileRegistry.getMergedProfile(player, type) : ProfileRegistry.getBlankProfile(player, type)), cacheDuration);
            profiles.put(type, entry);
            entry.getCachedProfile().onCacheRefresh();
            cache.put(player.getUniqueId(), profiles);
        }
        return (T)entry.getCachedProfile();
    }

    public static void cleanCache() {
        for (UUID uuid : new HashSet<UUID>(cache.keySet())) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null && p.isOnline()) continue;
            cache.remove(uuid);
        }
    }

    private static class CacheEntry {
        private final long cacheUntil;
        private final Profile cachedProfile;

        public CacheEntry(Profile profile, long cacheFor) {
            this.cachedProfile = profile;
            this.cacheUntil = System.currentTimeMillis() + cacheFor;
        }

        public Profile getCachedProfile() {
            return this.cachedProfile;
        }

        public long getCacheUntil() {
            return this.cacheUntil;
        }
    }
}

