/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles.implementations;

import java.util.Collection;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.BooleanProperties;
import me.athlaeos.valhallammo.playerstats.profiles.properties.PropertyBuilder;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.implementations.MiningSkill;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.Plugin;

public class MiningProfile
extends Profile {
    private ItemBuilder emptyHandTool;
    private static final NamespacedKey key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "profile_mining");

    public boolean isVeinMiningUnlocked() {
        return this.getBoolean("veinMiningUnlocked");
    }

    public void setVeinMiningUnlocked(boolean value) {
        this.setBoolean("veinMiningUnlocked", value);
    }

    public boolean isDrillingUnlocked() {
        return this.getBoolean("drillingUnlocked");
    }

    public void setDrillingUnlocked(boolean value) {
        this.setBoolean("drillingUnlocked", value);
    }

    public boolean isBlastingInstantPickup() {
        return this.getBoolean("blastingInstantPickup");
    }

    public void setBlastingInstantPickup(boolean value) {
        this.setBoolean("blastingInstantPickup", value);
    }

    public boolean isBlastingItemImmunity() {
        return this.getBoolean("blastingItemImmunity");
    }

    public void setBlastingItemImmunity(boolean value) {
        this.setBoolean("blastingItemImmunity", value);
    }

    public boolean isVeinMiningInstantPickup() {
        return this.getBoolean("veinMiningInstantPickup");
    }

    public void setVeinMiningInstantPickup(boolean value) {
        this.setBoolean("veinMiningInstantPickup", value);
    }

    public int getBlastFortuneLevel() {
        return this.getInt("blastFortuneLevel");
    }

    public void setBlastFortuneLevel(int value) {
        this.setInt("blastFortuneLevel", value);
    }

    public int getVeinMiningCooldown() {
        return this.getInt("veinMiningCooldown");
    }

    public void setVeinMiningCooldown(int value) {
        this.setInt("veinMiningCooldown", value);
    }

    public int getDrillingCooldown() {
        return this.getInt("drillingCooldown");
    }

    public void setDrillingCooldown(int value) {
        this.setInt("drillingCooldown", value);
    }

    public int getDrillingDuration() {
        return this.getInt("drillingDuration");
    }

    public void setDrillingDuration(int value) {
        this.setInt("drillingDuration", value);
    }

    public int getEmptyHandToolFortune() {
        return this.getInt("emptyHandToolFortune");
    }

    public void setEmptyHandToolFortune(int value) {
        this.setInt("emptyHandToolFortune", value);
    }

    public Collection<String> getUnbreakableBlocks() {
        return this.getStringSet("unbreakableBlocks");
    }

    public void setUnbreakableBlocks(Collection<String> value) {
        this.setStringSet("unbreakableBlocks", value);
    }

    public Collection<String> getVeinMinerValidBlocks() {
        return this.getStringSet("veinMinerValidBlocks");
    }

    public void setVeinMinerValidBlocks(Collection<String> value) {
        this.setStringSet("veinMinerValidBlocks", value);
    }

    public Collection<String> getEmptyHandToolMaterial() {
        return this.getStringSet("emptyHandToolMaterial");
    }

    public void setEmptyHandToolMaterial(Collection<String> value) {
        this.setStringSet("emptyHandToolMaterial", value);
    }

    public float getMiningDrops() {
        return this.getFloat("miningDrops");
    }

    public void setMiningDrops(float value) {
        this.setFloat("miningDrops", value);
    }

    public float getMiningLuck() {
        return this.getFloat("miningLuck");
    }

    public void setMiningLuck(float value) {
        this.setFloat("miningLuck", value);
    }

    public float getBlastingDrops() {
        return this.getFloat("blastingDrops");
    }

    public void setBlastingDrops(float value) {
        this.setFloat("blastingDrops", value);
    }

    public float getBlastingLuck() {
        return this.getFloat("blastingLuck");
    }

    public void setBlastingLuck(float value) {
        this.setFloat("blastingLuck", value);
    }

    public float getTntBlastRadius() {
        return this.getFloat("tntBlastRadius");
    }

    public void setTntBlastRadius(float value) {
        this.setFloat("tntBlastRadius", value);
    }

    public float getTntDamageReduction() {
        return this.getFloat("tntDamageReduction");
    }

    public void setTntDamageReduction(float value) {
        this.setFloat("tntDamageReduction", value);
    }

    public float getMiningSpeedBonus() {
        return this.getFloat("miningSpeedBonus");
    }

    public void setMiningSpeedBonus(float value) {
        this.setFloat("miningSpeedBonus", value);
    }

    public float getDrillingSpeedBonus() {
        return this.getFloat("drillingSpeedBonus");
    }

    public void setDrillingSpeedBonus(float value) {
        this.setFloat("drillingSpeedBonus", value);
    }

    public float getBlockExperienceRate() {
        return this.getFloat("blockExperienceRate");
    }

    public void setBlockExperienceRate(float value) {
        this.setFloat("blockExperienceRate", value);
    }

    public float getBlockExperienceMultiplier() {
        return this.getFloat("blockExperienceMultiplier");
    }

    public void setBlockExperienceMultiplier(float value) {
        this.setFloat("blockExperienceMultiplier", value);
    }

    public float getEmptyHandToolMiningStrength() {
        return this.getFloat("emptyHandToolMiningStrength");
    }

    public void setEmptyHandToolMiningStrength(float value) {
        this.setFloat("emptyHandToolMiningStrength", value);
    }

    public double getMiningEXPMultiplier() {
        return this.getDouble("miningEXPMultiplier");
    }

    public void setMiningEXPMultiplier(double value) {
        this.setDouble("miningEXPMultiplier", value);
    }

    public ItemBuilder getEmptyHandTool() {
        return this.emptyHandTool;
    }

    @Override
    public void onCacheRefresh() {
        String value = this.getEmptyHandToolMaterial().stream().findFirst().orElse(null);
        if (value == null) {
            this.emptyHandTool = null;
            return;
        }
        Material material = ItemUtils.stringToMaterial(value, null);
        if (material == null) {
            this.emptyHandTool = null;
            return;
        }
        int level = this.getEmptyHandToolFortune();
        ItemBuilder item = new ItemBuilder(material);
        if (level != 0) {
            item.enchant(level < 0 ? Enchantment.SILK_TOUCH : EnchantmentMappings.FORTUNE.getEnchantment(), level < 0 ? 1 : level);
        }
        if (this.getEmptyHandToolMiningStrength() > 0.0f) {
            MiningSpeed.setMultiplier(item.getMeta(), this.getEmptyHandToolMiningStrength());
        }
        this.emptyHandTool = new ItemBuilder(item.get());
    }

    public MiningProfile(UUID owner) {
        super(owner);
        this.floatStat("miningDrops", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("miningLuck", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("blastingDrops", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("blastingLuck", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("blockExperienceRate", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.floatStat("blockExperienceMultiplier", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("tntBlastRadius", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("tntDamageReduction", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.floatStat("miningSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.stringSetStat("unbreakableBlocks");
        this.intStat("blastFortuneLevel", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.booleanStat("blastingInstantPickup", new BooleanProperties(true, true));
        this.booleanStat("blastingItemImmunity", new BooleanProperties(true, true));
        this.booleanStat("veinMiningUnlocked", new BooleanProperties(true, true));
        this.booleanStat("veinMiningInstantPickup", new BooleanProperties(true, true));
        this.intStat("veinMiningCooldown", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.stringSetStat("veinMinerValidBlocks");
        this.booleanStat("drillingUnlocked", new BooleanProperties(true, true));
        this.floatStat("drillingSpeedBonus", new PropertyBuilder().format(StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).perkReward().create());
        this.intStat("drillingCooldown", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.intStat("drillingDuration", new PropertyBuilder().format(StatFormat.TIME_SECONDS_BASE_20_P1).perkReward().create());
        this.doubleStat("miningEXPMultiplier", new PropertyBuilder().format(StatFormat.PERCENTILE_BASE_1_P2).perkReward().create());
        this.stringSetStat("emptyHandToolMaterial");
        this.intStat("emptyHandToolFortune", new PropertyBuilder().format(StatFormat.INT).perkReward().create());
        this.floatStat("emptyHandToolMiningStrength", new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
        this.emptyHandTool = null;
    }

    @Override
    public String getTableName() {
        return "profiles_mining";
    }

    @Override
    public Profile getBlankProfile(UUID owner) {
        return ProfileRegistry.copyDefaultStats(new MiningProfile(owner));
    }

    @Override
    public Class<? extends Skill> getSkillType() {
        return MiningSkill.class;
    }
}

