/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.Collection;
import me.athlaeos.valhallammo.item.ArmorSet;
import me.athlaeos.valhallammo.item.ArmorSetRegistry;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.ItemSkillRequirements;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;

public class AttributeAttackerSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final String attribute;
    private WeightClass weightClass = null;
    private String statPenalty = null;
    private final boolean negative;
    private boolean ignoreProjectiles = true;

    public AttributeAttackerSource(String attribute) {
        this.attribute = attribute;
        this.negative = false;
    }

    public AttributeAttackerSource(String attribute, boolean negative) {
        this.attribute = attribute;
        this.negative = negative;
    }

    public AttributeAttackerSource penalty(String statPenalty) {
        this.statPenalty = statPenalty;
        return this;
    }

    public AttributeAttackerSource weight(WeightClass weightClass) {
        this.weightClass = weightClass;
        return this;
    }

    public AttributeAttackerSource proj() {
        this.ignoreProjectiles = false;
        return this;
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        LivingEntity l;
        Projectile p;
        ProjectileSource projectileSource;
        LivingEntity trueAttacker;
        LivingEntity a;
        double value = 0.0;
        Object object = attackedBy instanceof LivingEntity ? (a = (LivingEntity)attackedBy) : (trueAttacker = attackedBy instanceof Projectile && (projectileSource = (p = (Projectile)attackedBy).getShooter()) instanceof LivingEntity ? (l = (LivingEntity)projectileSource) : null);
        if (trueAttacker == null) {
            return value;
        }
        value += (double)(this.negative ? -1 : 1) * (!(trueAttacker instanceof Projectile) ? EntityUtils.combinedAttackerAttributeValue(trueAttacker, this.attribute, this.weightClass, this.statPenalty, true) : EntityUtils.combinedAttributeValue(trueAttacker, this.attribute, this.weightClass, this.statPenalty, false));
        if (!this.ignoreProjectiles && attackedBy instanceof Projectile) {
            Projectile p2 = (Projectile)attackedBy;
            ItemBuilder item = ItemUtils.getStoredItem((Entity)p2);
            if (item == null) {
                return value;
            }
            AttributeWrapper wrapper = ItemAttributesRegistry.getAnyAttribute(item.getMeta(), this.attribute);
            if (wrapper == null) {
                return value;
            }
            double multiplier = 1.0;
            if (this.attribute != null && trueAttacker instanceof Player) {
                Player player = (Player)trueAttacker;
                multiplier += ItemSkillRequirements.getPenalty(player, item, this.attribute);
            }
            value += wrapper.getValue() * multiplier;
        }
        Collection<ArmorSet> activeSets = ArmorSetRegistry.getActiveArmorSets(trueAttacker);
        for (ArmorSet set : activeSets) {
            value += (double)(this.negative ? -1 : 1) * set.getSetBonus().getOrDefault(this.attribute, 0.0);
        }
        return value;
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        return this.fetch(null, statPossessor, use);
    }
}

