/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.skills.skills.implementations.MiningSkill;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MiningStatSource
implements AccumulativeStatSource {
    private final String stat;
    private final Class<? extends Number> numberType;
    private final double def;

    public MiningStatSource(String stat) {
        this.stat = stat;
        MiningProfile baseProfile = ProfileRegistry.getBlankProfile((UUID)null, MiningProfile.class);
        if (baseProfile.intStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (baseProfile.floatStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (baseProfile.doubleStatNames().contains(stat)) {
            this.def = baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("MiningStatSource:" + MiningProfile.class.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        MiningSkill miningSkill;
        MiningSkill miningSkill2 = miningSkill = SkillRegistry.isRegistered(MiningSkill.class) ? (MiningSkill)SkillRegistry.getSkill(MiningSkill.class) : null;
        if (statPossessor instanceof Player) {
            Player p = (Player)statPossessor;
            if (miningSkill != null) {
                Block b = p.getTargetBlockExact(8);
                if (b == null || !miningSkill.getDropsExpValues().containsKey(b.getType())) {
                    return this.def;
                }
                MiningProfile profile = ProfileCache.getOrCache(p, MiningProfile.class);
                if (this.numberType.equals(Integer.class)) {
                    return profile.getInt(this.stat);
                }
                if (this.numberType.equals(Float.class)) {
                    return profile.getFloat(this.stat);
                }
                return profile.getDouble(this.stat);
            }
        }
        return this.def;
    }
}

