/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;

public class ProfileStatAttackerSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final Class<? extends Profile> type;
    private final String stat;
    private final Class<? extends Number> numberType;
    private final Profile baseProfile;
    private final double def;
    private boolean negative = false;

    public ProfileStatAttackerSource(Class<? extends Profile> type, String stat) {
        this.type = type;
        this.stat = stat;
        this.baseProfile = ProfileRegistry.getBlankProfile((UUID)null, type);
        if (this.baseProfile.intStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (this.baseProfile.floatStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (this.baseProfile.doubleStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerSource:" + type.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    public ProfileStatAttackerSource n() {
        this.negative = true;
        return this;
    }

    @Override
    public double fetch(Entity p, boolean use) {
        return this.fetch(null, p, use);
    }

    public StatFormat getFormat() {
        return this.baseProfile.getNumberStatProperties().get(this.stat).getFormat();
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        LivingEntity l;
        Projectile p;
        ProjectileSource projectileSource;
        LivingEntity trueAttacker;
        LivingEntity a;
        Object object = attackedBy instanceof LivingEntity ? (a = (LivingEntity)attackedBy) : (trueAttacker = attackedBy instanceof Projectile && (projectileSource = (p = (Projectile)attackedBy).getShooter()) instanceof LivingEntity ? (l = (LivingEntity)projectileSource) : null);
        if (trueAttacker == null) {
            return this.def;
        }
        if (trueAttacker instanceof Player) {
            String requiredPermission;
            Player pl = (Player)trueAttacker;
            Profile profile = ProfileCache.getOrCache(pl, this.type);
            String string = requiredPermission = SkillRegistry.isRegistered(profile.getSkillType()) ? SkillRegistry.getSkill(profile.getSkillType()).getRequiredPermission() : null;
            if (requiredPermission != null && !pl.hasPermission(requiredPermission)) {
                return this.def;
            }
            if (this.numberType.equals(Integer.class)) {
                return (this.negative ? -1 : 1) * profile.getInt(this.stat);
            }
            if (this.numberType.equals(Float.class)) {
                return (float)(this.negative ? -1 : 1) * profile.getFloat(this.stat);
            }
            return (double)(this.negative ? -1 : 1) * profile.getDouble(this.stat);
        }
        return this.def;
    }
}

