/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.utility.EntityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProfileStatAttackerWeightSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final Class<? extends Profile> type;
    private final String stat;
    private final Class<? extends Number> numberType;
    private final Profile baseProfile;
    private final double def;
    private final WeightClass weightClass;
    private boolean negative = false;

    public ProfileStatAttackerWeightSource(Class<? extends Profile> type, String stat, WeightClass weightClass) {
        this.type = type;
        this.stat = stat;
        this.weightClass = weightClass;
        this.baseProfile = ProfileRegistry.getBlankProfile((UUID)null, type);
        if (this.baseProfile.intStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (this.baseProfile.floatStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (this.baseProfile.doubleStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerWeightSource:" + type.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    public ProfileStatAttackerWeightSource n() {
        this.negative = true;
        return this;
    }

    @Override
    public double fetch(Entity p, boolean use) {
        return this.fetch(null, p, use);
    }

    public StatFormat getFormat() {
        return this.baseProfile.getNumberStatProperties().get(this.stat).getFormat();
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        if (attackedBy instanceof Player) {
            Profile profile;
            String requiredPermission;
            Player pl = (Player)attackedBy;
            EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)pl);
            if (this.weightClass != WeightClass.WEIGHTLESS) {
                if (properties.getMainHand() == null || WeightClass.getWeightClass(properties.getMainHand().getMeta()) != this.weightClass) {
                    return this.def;
                }
            } else {
                if (properties.getMainHand() != null && WeightClass.hasDefinedWeightClass(properties.getMainHand().getMeta()) && WeightClass.getWeightClass(properties.getMainHand().getMeta()) != WeightClass.WEIGHTLESS) {
                    return this.def;
                }
                if (!EntityUtils.isUnarmed((LivingEntity)pl)) {
                    return this.def;
                }
            }
            String string = requiredPermission = SkillRegistry.isRegistered((profile = ProfileCache.getOrCache(pl, this.type)).getSkillType()) ? SkillRegistry.getSkill(profile.getSkillType()).getRequiredPermission() : null;
            if (requiredPermission != null && !pl.hasPermission(requiredPermission)) {
                return this.def;
            }
            if (this.numberType.equals(Integer.class)) {
                return (this.negative ? -1 : 1) * profile.getInt(this.stat);
            }
            if (this.numberType.equals(Float.class)) {
                return (float)(this.negative ? -1 : 1) * profile.getFloat(this.stat);
            }
            return (double)(this.negative ? -1 : 1) * profile.getDouble(this.stat);
        }
        return this.def;
    }
}

