/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class TotalArmorSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    @Override
    public double fetch(Entity statPossessor, boolean use) {
        if (statPossessor instanceof LivingEntity) {
            LivingEntity v = (LivingEntity)statPossessor;
            double lightArmor = Math.max(0.0, AccumulativeStatManager.getCachedStats("LIGHT_ARMOR", (Entity)v, 10000L, true));
            double heavyArmor = Math.max(0.0, AccumulativeStatManager.getCachedStats("HEAVY_ARMOR", (Entity)v, 10000L, true));
            double nonEquipmentArmor = Math.max(0.0, AccumulativeStatManager.getCachedStats("WEIGHTLESS_ARMOR", (Entity)v, 10000L, true));
            double lightArmorMultiplier = Math.max(0.0, AccumulativeStatManager.getCachedStats("LIGHT_ARMOR_MULTIPLIER", (Entity)v, 10000L, true));
            double heavyArmorMultiplier = Math.max(0.0, AccumulativeStatManager.getCachedStats("HEAVY_ARMOR_MULTIPLIER", (Entity)v, 10000L, true));
            double armorMultiplierBonus = Math.max(0.0, AccumulativeStatManager.getCachedStats("ARMOR_MULTIPLIER_BONUS", (Entity)v, 10000L, true));
            double totalLightArmor = Math.max(0.0, lightArmor * lightArmorMultiplier);
            double totalHeavyArmor = Math.max(0.0, heavyArmor * heavyArmorMultiplier);
            return Math.max(0.0, (totalLightArmor + totalHeavyArmor + nonEquipmentArmor) * (1.0 + armorMultiplierBonus));
        }
        return 0.0;
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        if (victim instanceof LivingEntity) {
            LivingEntity v = (LivingEntity)victim;
            if (attackedBy instanceof LivingEntity) {
                LivingEntity a = (LivingEntity)attackedBy;
                double lightArmor = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("LIGHT_ARMOR", (Entity)v, (Entity)a, 10000L, true));
                double lightArmorFlatPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("LIGHT_ARMOR_FLAT_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double heavyArmor = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("HEAVY_ARMOR", (Entity)v, (Entity)a, 10000L, true));
                double heavyArmorFlatPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("HEAVY_ARMOR_FLAT_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double nonEquipmentArmor = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("WEIGHTLESS_ARMOR", (Entity)v, (Entity)a, 10000L, true));
                double armorFlatPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("ARMOR_FLAT_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double lightArmorMultiplier = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("LIGHT_ARMOR_MULTIPLIER", (Entity)v, (Entity)a, 10000L, true));
                double lightArmorFractionPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("LIGHT_ARMOR_FRACTION_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double heavyArmorMultiplier = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("HEAVY_ARMOR_MULTIPLIER", (Entity)v, (Entity)a, 10000L, true));
                double heavyArmorFractionPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("HEAVY_ARMOR_FRACTION_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double armorMultiplierBonus = Math.max(0.0, AccumulativeStatManager.getCachedRelationalStats("ARMOR_MULTIPLIER_BONUS", (Entity)v, (Entity)a, 10000L, true));
                double armorFractionPenetration = AccumulativeStatManager.getCachedAttackerRelationalStats("ARMOR_FRACTION_IGNORED", (Entity)v, (Entity)a, 10000L, true);
                double totalLightArmor = Math.max(0.0, lightArmor * lightArmorMultiplier * (1.0 - lightArmorFractionPenetration) - lightArmorFlatPenetration);
                double totalHeavyArmor = Math.max(0.0, heavyArmor * heavyArmorMultiplier * (1.0 - heavyArmorFractionPenetration) - heavyArmorFlatPenetration);
                return Math.max(0.0, (totalLightArmor + totalHeavyArmor + nonEquipmentArmor) * (1.0 + armorMultiplierBonus) * (1.0 - armorFractionPenetration) - armorFlatPenetration);
            }
        }
        return 0.0;
    }
}

