/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.effect_triggers;

import java.util.List;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTriggerRegistry;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;

public interface EffectTrigger {
    public String id();

    public void onRegister();

    default public void trigger(LivingEntity entity, List<PotionEffectWrapper> effects) {
        for (PotionEffectWrapper effectWrapper : effects) {
            if (effectWrapper.isVanilla()) {
                entity.addPotionEffect(new PotionEffect(effectWrapper.getVanillaEffect(), (int)effectWrapper.getDuration(), (int)effectWrapper.getAmplifier(), true, false, false));
                continue;
            }
            CustomPotionEffect effect = new CustomPotionEffect(effectWrapper, (int)effectWrapper.getDuration(), effectWrapper.getAmplifier());
            PotionEffectRegistry.addEffect(entity, null, effect, false, 1.0, EntityPotionEffectEvent.Cause.PLUGIN);
        }
    }

    default public boolean shouldTrigger(LivingEntity entity) {
        return EffectTriggerRegistry.isEntityAffectedByTrigger(entity, this.id());
    }

    public static interface ConstantTrigger
    extends EffectTrigger {
        public int tickDelay();
    }
}

