/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.event.EntityStunEvent;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Stun
extends PotionEffectWrapper {
    private static final Collection<PotionEffectWrapper> stunEffects = new HashSet<PotionEffectWrapper>();
    private static final int stunImmunityDuration;
    private final String defaultIcon;

    public Stun(String effect, String defaultIcon) {
        super(effect, false, true, null);
        this.defaultIcon = defaultIcon;
    }

    @Override
    public void onApply(ItemBuilder i) {
        boolean customFlag = CustomFlag.hasFlag(i.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES);
        boolean vanillaFlag = i.getMeta().hasItemFlag(ConventionUtils.getHidePotionEffectsFlag());
        boolean temporaryCoatingDisplay = CustomFlag.hasFlag(i.getMeta(), CustomFlag.TEMPORARY_POTION_DISPLAY);
        if (this.isVanilla && i.getMeta() instanceof PotionMeta && (!customFlag || !vanillaFlag) || !this.isVanilla && (!temporaryCoatingDisplay || this.charges == 0) && vanillaFlag && !customFlag) {
            this.onRemove(i);
        } else {
            String translation = this.getEffectName();
            if (StringUtils.isEmpty(translation)) {
                return;
            }
            String prefix = this.prefix();
            String charges = TranslationManager.getTranslation("potion_effect_charges_format").replace("%prefix%", prefix).replace("%charges_roman%", this.charges >= 0 ? StringUtils.toRoman(this.charges) : "").replace("%charges_numeric%", String.valueOf(this.charges));
            i.appendLore(prefix + (translation.replace("%icon%", this.getEffectIcon() + prefix).replace("%value%", "").replace("%duration%", String.format("(%s)", StringUtils.toTimeStamp(this.duration, 20L))) + (this.charges <= 0 ? "" : charges)).trim());
        }
    }

    @Override
    public void onInflict(LivingEntity p, LivingEntity causedBy, double amplifier, int duration, double intensity) {
        Stun.stunTarget(p, causedBy, (int)(intensity * (double)duration), false);
    }

    public static void stunTarget(LivingEntity entity, LivingEntity causedBy, int duration, boolean force) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            block6: {
                LivingEntity l;
                int newDuration;
                block8: {
                    block7: {
                        if (!entity.isValid() || entity.isDead()) {
                            return;
                        }
                        double durationMultiplier = force ? 1.0 : Math.max(0.0, 1.0 - AccumulativeStatManager.getRelationalStats("STUN_RESISTANCE", (Entity)entity, (Entity)causedBy, true));
                        newDuration = (int)Math.round((double)duration * durationMultiplier);
                        EntityStunEvent event = new EntityStunEvent((Entity)entity, (Entity)causedBy, newDuration);
                        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) break block6;
                        Entity patt0$temp = event.getEntity();
                        if (!(patt0$temp instanceof LivingEntity)) break block7;
                        l = (LivingEntity)patt0$temp;
                        if (force || Timer.isCooldownPassed(entity.getUniqueId(), "stun_immunity")) break block8;
                    }
                    return;
                }
                for (PotionEffectWrapper e : stunEffects) {
                    if (e.isVanilla()) {
                        l.addPotionEffect(new PotionEffect(e.getVanillaEffect(), newDuration, (int)e.getAmplifier(), true, false));
                        continue;
                    }
                    PotionEffectRegistry.addEffect(l, causedBy, new CustomPotionEffect(e, newDuration, e.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ATTACK);
                }
                EntityCache.resetPotionEffects(l);
                Timer.setCooldown(entity.getUniqueId(), stunImmunityDuration * 50, "stun_immunity");
            }
        }, 1L);
    }

    public static void attemptStun(LivingEntity entity, LivingEntity causedBy) {
        int stunDuration = ValhallaMMO.getPluginConfig().getInt("default_stun_duration", 0) + (int)AccumulativeStatManager.getCachedAttackerRelationalStats("STUN_DURATION_BONUS", (Entity)entity, (Entity)causedBy, 10000L, true);
        Stun.stunTarget(entity, causedBy, stunDuration, false);
    }

    public static boolean isStunned(LivingEntity entity) {
        Map<String, CustomPotionEffect> activeEffects = PotionEffectRegistry.getActiveEffects(entity);
        return stunEffects.stream().map(PotionEffectWrapper::getEffect).allMatch(activeEffects::containsKey);
    }

    @Override
    public void onRemove(ItemBuilder i) {
        String translation = this.getEffectName();
        if (StringUtils.isEmpty(translation)) {
            return;
        }
        ItemUtils.removeIfLoreContains(i, translation.replace("%icon%", "").replace("%value%", "").replace("%duration%", "").trim());
    }

    @Override
    public void onExpire(LivingEntity entity) {
    }

    @Override
    public EffectClass getClassification(double amplifier) {
        return EffectClass.DEBUFF;
    }

    @Override
    public String getEffectIcon() {
        return StringUtils.isEmpty(super.getEffectIcon()) ? (ValhallaMMO.isResourcePackConfigForced() ? "&f" + this.defaultIcon : super.getEffectIcon()) : super.getEffectIcon();
    }

    @Override
    public boolean isSingleUse() {
        return false;
    }

    @Override
    public PotionEffectWrapper copy() {
        return new Stun(this.getEffect(), this.defaultIcon).setCharges(this.charges).setDuration(this.duration);
    }

    private String prefix() {
        return TranslationManager.getTranslation("stat_potion_negative_prefix");
    }

    @Override
    public StatFormat getFormat() {
        return StatFormat.NONE;
    }

    static {
        YamlConfiguration c = ConfigManager.getConfig("config.yml").reload().get();
        ConfigurationSection stunEffectSection = c.getConfigurationSection("stun_effects");
        stunImmunityDuration = c.getInt("stun_immunity_duration", 5000);
        if (stunEffectSection != null) {
            for (String effect : stunEffectSection.getKeys(false)) {
                PotionEffectWrapper wrapper = PotionEffectRegistry.getEffect(effect).setAmplifier(c.getDouble("stun_effects." + effect));
                stunEffects.add(wrapper);
            }
        }
    }
}

