/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.BlockInteractConversions;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaKeyedRecipe;
import me.athlaeos.valhallammo.dom.BiAction;
import me.athlaeos.valhallammo.playerstats.profiles.ResetType;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.AlchemyProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.EnchantingProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.LightArmorProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.WoodcuttingProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.FlightRemoveReward;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.FlightReward;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileStringListAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileStringListClear;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileStringListFill;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileStringListRemove;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileStringSetSingle;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProgressReset;
import me.athlaeos.valhallammo.skills.skills.implementations.AlchemySkill;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PerkRewardRegistry {
    private static final Map<String, PerkReward> registry = new HashMap<String, PerkReward>();

    public static void register(PerkReward reward) {
        registry.put(reward.getName(), reward);
    }

    public static PerkReward createReward(String name, Object argument) {
        try {
            boolean persist = name.startsWith("p:");
            if (persist) {
                name = name.replaceFirst("p:", "");
            }
            if (registry.get(name) == null) {
                throw new IllegalArgumentException("Perk with name " + name + " is used but does not exist");
            }
            PerkReward modifier = registry.get(name).clone();
            modifier.parseArgument(argument);
            modifier.setPersistent(persist);
            return modifier;
        }
        catch (CloneNotSupportedException ex) {
            ValhallaMMO.logSevere("Could not clone PerkReward, notify plugin author");
            return null;
        }
    }

    public static Map<String, PerkReward> getRegisteredRewards() {
        return registry;
    }

    static {
        for (ResetType type : ResetType.values()) {
            PerkRewardRegistry.register(new ProgressReset("reset_" + type.toString().toLowerCase(Locale.US), type));
        }
        BiAction<String, Player> forget = (s, p) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            ValhallaKeyedRecipe recipe = CustomRecipeRegistry.getAllKeyedRecipesByName().get(s);
            if (recipe == null) {
                return;
            }
            p.undiscoverRecipe(recipe.getKey());
        });
        BiAction<String, Player> discover = (s, p) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            ValhallaKeyedRecipe recipe = CustomRecipeRegistry.getAllKeyedRecipesByName().get(s);
            if (recipe == null) {
                return;
            }
            p.discoverRecipe(recipe.getKey());
        });
        PerkRewardRegistry.register(new ProfileStringListAdd("perks_unlocked_add", "unlockedPerks", PowerProfile.class, true));
        PerkRewardRegistry.register(new ProfileStringListRemove("perks_unlocked_remove", "unlockedPerks", PowerProfile.class, true));
        PerkRewardRegistry.register(new ProfileStringListAdd("perks_permanently_unlocked_add", "permanentlyUnlockedPerks", PowerProfile.class, true));
        PerkRewardRegistry.register(new ProfileStringListRemove("perks_permanently_unlocked_remove", "permanentlyUnlockedPerks", PowerProfile.class, true));
        PerkRewardRegistry.register(new ProfileStringListAdd("perks_fake_unlock_add", "fakeUnlockedPerks", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("perks_fake_unlock_remove", "fakeUnlockedPerks", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("perks_fake_unlock_clear", "fakeUnlockedPerks", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("perks_locked_add", "permanentlyLockedPerks", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("perks_locked_clear", "permanentlyLockedPerks", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("recipes_unlock", "unlockedRecipes", PowerProfile.class, discover, forget));
        PerkRewardRegistry.register(new ProfileStringListRemove("recipes_lock", "unlockedRecipes", PowerProfile.class, forget, discover));
        PerkRewardRegistry.register(new ProfileStringListFill("recipes_unlock_all", "unlockedRecipes", PowerProfile.class, CustomRecipeRegistry::getAllRecipes));
        PerkRewardRegistry.register(new ProfileStringListClear("recipes_lock_all", "unlockedRecipes", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("enchanting_add_elemental_type", "elementalDamageTypes", EnchantingProfile.class));
        PerkRewardRegistry.register(new ProfileStringSetSingle("enchanting_set_elemental_type", "elementalDamageTypes", EnchantingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("enchanting_remove_elemental_type", "elementalDamageTypes", EnchantingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("enchanting_clear_elemental_type", "elementalDamageTypes", EnchantingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("lightarmor_add_immune_effect", "setImmunePotionEffects", LightArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("lightarmor_remove_immune_effect", "setImmunePotionEffects", LightArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("lightarmor_clear_immune_effects", "setImmunePotionEffects", LightArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("heavyarmor_add_immune_effect", "setImmunePotionEffects", HeavyArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("heavyarmor_remove_immune_effect", "setImmunePotionEffects", HeavyArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("heavyarmor_clear_immune_effects", "setImmunePotionEffects", HeavyArmorProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("mining_veinminerblocks_add", "veinMinerValidBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("mining_veinminerblocks_remove", "veinMinerValidBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("mining_veinminerblocks_clear", "veinMinerValidBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("mining_unbreakableblocks_add", "unbreakableBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("mining_unbreakableblocks_remove", "unbreakableBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("mining_unbreakableblocks_clear", "unbreakableBlocks", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringSetSingle("mining_emptyhandtooltype_set", "emptyHandToolMaterial", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("mining_emptyhandtooltype_remove", "emptyHandToolMaterial", MiningProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("woodcutting_treecapitatorblocks_add", "treeCapitatorValidBlocks", WoodcuttingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListFill("woodcutting_treecapitatorblocks_add_all", "treeCapitatorValidBlocks", WoodcuttingProfile.class, () -> Tag.LOGS.getValues().stream().map(Enum::toString).collect(Collectors.toSet())));
        PerkRewardRegistry.register(new ProfileStringListRemove("woodcutting_treecapitatorblocks_remove", "treeCapitatorValidBlocks", WoodcuttingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("woodcutting_treecapitatorblocks_remove", "treeCapitatorValidBlocks", WoodcuttingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("woodcutting_treecapitatorblocks_clear", "treeCapitatorValidBlocks", WoodcuttingProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("alchemy_transmutations_unlock", "unlockedTransmutations", AlchemyProfile.class));
        PerkRewardRegistry.register(new ProfileStringListFill("alchemy_transmutations_unlock_all", "unlockedTransmutations", AlchemyProfile.class, () -> AlchemySkill.getTransmutations().keySet()));
        PerkRewardRegistry.register(new ProfileStringListRemove("alchemy_transmutations_lock", "unlockedTransmutations", AlchemyProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("alchemy_transmutations_lock_all", "unlockedTransmutations", AlchemyProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("block_conversions_unlock", "unlockedBlockConversions", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListFill("block_conversions_unlock_all", "unlockedBlockConversions", PowerProfile.class, () -> BlockInteractConversions.getConversions().keySet()));
        PerkRewardRegistry.register(new ProfileStringListRemove("block_conversions_lock", "unlockedBlockConversions", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("block_conversions_lock_all", "unlockedBlockConversions", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListAdd("permanent_effects_add", "permanentPotionEffects", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListRemove("permanent_effects_remove", "permanentPotionEffects", PowerProfile.class));
        PerkRewardRegistry.register(new ProfileStringListClear("permanent_effects_clear", "permanentPotionEffects", PowerProfile.class));
        PerkRewardRegistry.register(new FlightReward());
        PerkRewardRegistry.register(new FlightRemoveReward());
    }
}

