/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.FlightReward;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FlightRemoveReward
extends PerkReward {
    private static final NamespacedKey KEY_GRANTED_FLIGHT = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "granted_flight");

    public FlightRemoveReward() {
        super("disable_flight");
    }

    @Override
    public void apply(Player player) {
        PowerProfile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, PowerProfile.class) : ProfileRegistry.getSkillProfile(player, PowerProfile.class);
        profile.setBoolean("flight", true);
        if (this.isPersistent()) {
            ProfileRegistry.setPersistentProfile(player, profile, PowerProfile.class);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, PowerProfile.class);
        }
        ProfileCache.resetCache(player);
        FlightReward.setFlight(player, true);
    }

    @Override
    public void remove(Player player) {
        PowerProfile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, PowerProfile.class) : ProfileRegistry.getSkillProfile(player, PowerProfile.class);
        profile.setBoolean("flight", false);
        if (this.isPersistent()) {
            ProfileRegistry.setPersistentProfile(player, profile, PowerProfile.class);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, PowerProfile.class);
        }
        ProfileCache.resetCache(player);
        FlightReward.setFlight(player, false);
    }

    @Override
    public void parseArgument(Object o) {
    }

    @Override
    public String rewardPlaceholder() {
        return TranslationManager.getTranslation("translation_toggles");
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.NONE;
    }
}

