/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import org.bukkit.entity.Player;

public class ProfileBooleanSet
extends PerkReward {
    private boolean value;
    private final String stat;
    private final Class<? extends Profile> type;

    public ProfileBooleanSet(String name, String stat, Class<? extends Profile> type) {
        super(name);
        this.stat = stat;
        this.type = type;
    }

    @Override
    public void apply(Player player) {
        Profile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        profile.setBoolean(this.stat, this.value);
        if (this.isPersistent()) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void remove(Player player) {
        if (this.isPersistent()) {
            Profile profile = ProfileRegistry.getPersistentProfile(player, this.type);
            profile.setBoolean(this.stat, !this.value);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            Profile profile = ProfileRegistry.getSkillProfile(player, this.type);
            profile.setBoolean(this.stat, !this.value);
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void parseArgument(Object argument) {
        this.value = this.parseBoolean(argument);
    }

    @Override
    public String rewardPlaceholder() {
        return this.value ? TranslationManager.getTranslation("translation_enables") : TranslationManager.getTranslation("translation_disables");
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.BOOLEAN;
    }
}

