/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import org.bukkit.entity.Player;

public class ProfileBooleanToggle
extends PerkReward {
    private final String stat;
    private final Class<? extends Profile> type;

    public ProfileBooleanToggle(String name, String stat, Class<? extends Profile> type) {
        super(name);
        this.stat = stat;
        this.type = type;
    }

    @Override
    public void apply(Player player) {
        Profile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        profile.setBoolean(this.stat, !profile.getBoolean(this.stat));
        if (this.isPersistent()) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void remove(Player player) {
        Profile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        profile.setBoolean(this.stat, !profile.getBoolean(this.stat));
        if (this.isPersistent()) {
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void parseArgument(Object argument) {
    }

    @Override
    public String rewardPlaceholder() {
        return TranslationManager.getTranslation("translation_toggles");
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.NONE;
    }
}

