/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.StatProperties;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import org.bukkit.entity.Player;

public class ProfileFloatSet
extends PerkReward {
    private float value;
    private final String stat;
    private final Class<? extends Profile> type;

    public ProfileFloatSet(String name, String stat, Class<? extends Profile> type) {
        super(name);
        this.stat = stat;
        this.type = type;
    }

    @Override
    public void apply(Player player) {
        Profile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        profile.setFloat(this.stat, this.value);
        if (this.isPersistent()) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void remove(Player player) {
    }

    @Override
    public void parseArgument(Object argument) {
        this.value = this.parseFloat(argument);
    }

    @Override
    public String rewardPlaceholder() {
        StatProperties properties = ProfileRegistry.getRegisteredProfiles().get(this.type).getNumberStatProperties().get(this.stat);
        if (properties == null) {
            return StatFormat.FLOAT_P2.format(Float.valueOf(this.value));
        }
        return properties.getFormat().format(Float.valueOf(this.value));
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.FLOAT;
    }
}

