/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkresourcecost;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.EconomyExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.ExperienceExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.ExperienceLevelsExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.ItemExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.PrestigePointsExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.implementations.SkillPointsExpense;

public class ResourceExpenseRegistry {
    private static final Map<String, ResourceExpense> expenses = new HashMap<String, ResourceExpense>();

    public static void registerDefaultExpenses() {
        ResourceExpenseRegistry.register("cost_money", new EconomyExpense());
        ResourceExpenseRegistry.register("cost_experience", new ExperienceExpense());
        ResourceExpenseRegistry.register("cost_levels", new ExperienceLevelsExpense());
        ResourceExpenseRegistry.register("cost", new SkillPointsExpense());
        ResourceExpenseRegistry.register("cost_prestige", new PrestigePointsExpense());
        ResourceExpenseRegistry.register("cost_items", new ItemExpense());
    }

    public static void register(String key, ResourceExpense expense) {
        expenses.put(key, expense);
    }

    public static ResourceExpense createExpenseInstance(String key) {
        ResourceExpense expense = expenses.get(key);
        if (expense == null) {
            return null;
        }
        return expense.createInstance();
    }

    public static Collection<String> getValuePlaceholders() {
        return expenses.values().stream().map(ResourceExpense::getCostPlaceholder).collect(Collectors.toSet());
    }

    public static Collection<String> getFailurePlaceholders() {
        return expenses.values().stream().map(ResourceExpense::getInsufficientCostPlaceholder).collect(Collectors.toSet());
    }

    public static Map<String, ResourceExpense> getExpenses() {
        return expenses;
    }
}

