/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkresourcecost.implementations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOptionRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemExpense
implements ResourceExpense {
    private final Map<String, ItemCost> valhallaItemCost = new HashMap<String, ItemCost>();
    private final Map<ItemStack, Integer> vanillaItemCost = new HashMap<ItemStack, Integer>();
    private final boolean refundable = ConfigManager.getConfig("config.yml").reload().get().getBoolean("forgettable_perks_refund_items", true);

    @Override
    public void initExpense(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (String s : list) {
                String[] split = s.split(Pattern.quote("|"));
                int amount = Catch.catchOrElse(() -> Integer.parseInt(split[1]), 1);
                Material material = Catch.catchOrElse(() -> Material.valueOf((String)split[0]), null);
                if (material == null) {
                    RecipeOption matcher = RecipeOptionRegistry.createOption(Catch.catchOrElse(() -> split[2], "CHOICE_MATERIAL_DATA"));
                    this.valhallaItemCost.put(split[0], new ItemCost(amount, matcher));
                    continue;
                }
                this.vanillaItemCost.put(new ItemStack(material), amount);
            }
        }
    }

    @Override
    public boolean canPurchase(Player p) {
        List<ItemStack> inventory = Arrays.asList(p.getInventory().getStorageContents());
        if (ItemUtils.timesContained(inventory, this.vanillaItemCost, new MaterialChoice()) <= 0) {
            return false;
        }
        for (String id : this.valhallaItemCost.keySet()) {
            ItemStack item = CustomItemRegistry.getProcessedItem(id, p);
            if (item == null) {
                ValhallaMMO.logWarning("Perk item cost " + id + " was not a valid vanilla OR valhalla item, please fix");
                continue;
            }
            ItemCost cost = this.valhallaItemCost.get(id);
            if (ItemUtils.timesContained(inventory, Map.of(item, cost.quantity), cost.matcher) > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void purchase(Player p, boolean initialPurchase) {
        if (!initialPurchase) {
            return;
        }
        if (!this.vanillaItemCost.isEmpty()) {
            ItemUtils.removeItems((Inventory)p.getInventory(), this.vanillaItemCost, 1, (IngredientChoice)new MaterialChoice());
        }
        if (!this.valhallaItemCost.isEmpty()) {
            for (String id : this.valhallaItemCost.keySet()) {
                ItemStack item = CustomItemRegistry.getProcessedItem(id, p);
                if (item == null) {
                    ValhallaMMO.logWarning("Perk item cost " + id + " was not a valid vanilla OR valhalla item, please fix");
                    continue;
                }
                ItemCost cost = this.valhallaItemCost.get(id);
                ItemUtils.removeItems((Inventory)p.getInventory(), Map.of(item, cost.quantity), 1, cost.matcher);
            }
        }
    }

    @Override
    public void refund(Player p) {
        if (!this.vanillaItemCost.isEmpty()) {
            List<ItemStack> decompressed = ItemUtils.decompressStacks(this.vanillaItemCost);
            decompressed.forEach(i -> ItemUtils.addItem(p, i, true));
        }
        if (!this.valhallaItemCost.isEmpty()) {
            HashMap<ItemStack, Integer> items = new HashMap<ItemStack, Integer>();
            for (String item : this.valhallaItemCost.keySet()) {
                ItemStack processed = CustomItemRegistry.getProcessedItem(item, p);
                if (processed == null) continue;
                ItemCost cost = this.valhallaItemCost.get(item);
                items.put(processed, cost.quantity);
            }
            List<ItemStack> decompressed = ItemUtils.decompressStacks(items);
            decompressed.forEach(i -> ItemUtils.addItem(p, i, true));
        }
    }

    @Override
    public boolean isRefundable() {
        return this.refundable;
    }

    @Override
    public ResourceExpense createInstance() {
        return new ItemExpense();
    }

    @Override
    public String getInsufficientFundsMessage() {
        return TranslationManager.getTranslation("warning_insufficient_items");
    }

    @Override
    public String getCostPlaceholder() {
        return "%cost_items%";
    }

    @Override
    public String getInsufficientCostPlaceholder() {
        return "%warning_cost_items%";
    }

    @Override
    public String getCostMessage() {
        String format = TranslationManager.getTranslation("status_items_cost");
        String entry = TranslationManager.getTranslation("status_items_cost_format");
        StringBuilder costBuilder = new StringBuilder();
        for (ItemStack itemStack : this.vanillaItemCost.keySet()) {
            costBuilder.append(entry.replace("%item%", ItemUtils.getItemName(new ItemBuilder(itemStack))).replace("%quantity%", String.valueOf(this.vanillaItemCost.get(itemStack))));
        }
        for (String string : this.valhallaItemCost.keySet()) {
            ItemStack processed = CustomItemRegistry.getProcessedItem(string);
            if (processed == null) continue;
            ItemCost cost = this.valhallaItemCost.get(string);
            costBuilder.append(entry.replace("%item%", cost.matcher.ingredientDescription(processed)).replace("%quantity%", String.valueOf(cost.quantity)));
        }
        return format.replace("%items%", costBuilder.toString());
    }

    private record ItemCost(int quantity, IngredientChoice matcher) {
    }
}

