/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockCondition;
import me.athlaeos.valhallammo.skills.skills.PerkConnectionIcon;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Perk {
    private final String name;
    private final String displayName;
    private final String description;
    private final ItemStack icon;
    private int customModelDataUnlockable = -1;
    private int customModelDataUnlocked = -1;
    private int customModelDataVisible = -1;
    private final Skill skill;
    private int x;
    private int y;
    private final boolean hiddenUntilRequirementsMet;
    private final Collection<ResourceExpense> expenses;
    private final Map<Class<? extends ResourceExpense>, ResourceExpense> mappedExpenses = new HashMap<Class<? extends ResourceExpense>, ResourceExpense>();
    private final Collection<UnlockCondition> conditions;
    private final Map<Class<? extends UnlockCondition>, UnlockCondition> mappedConditions = new HashMap<Class<? extends UnlockCondition>, UnlockCondition>();
    private final int levelRequirement;
    private final String permissionRequirement;
    private final List<PerkReward> rewards;
    private Collection<PerkConnectionIcon> connectionLine = new HashSet<PerkConnectionIcon>();
    private final List<String> messages;
    private final List<String> commands;
    private final List<String> undoCommands;

    public Perk(String name, String displayName, String description, ItemStack icon, Skill skill, int x, int y, boolean hidden, Collection<ResourceExpense> expenses, Collection<UnlockCondition> conditions, int levelRequirement, String permissionRequirement, List<PerkReward> rewards, List<String> messages, List<String> commands, List<String> undoCommands) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.icon = icon;
        this.skill = skill;
        this.x = x;
        this.y = y;
        this.hiddenUntilRequirementsMet = hidden;
        this.expenses = expenses;
        for (ResourceExpense expense : expenses) {
            this.mappedExpenses.put(expense.getClass(), expense);
        }
        this.conditions = conditions;
        for (UnlockCondition condition : conditions) {
            this.mappedConditions.put(condition.getClass(), condition);
        }
        this.levelRequirement = levelRequirement;
        this.permissionRequirement = permissionRequirement;
        this.rewards = rewards;
        this.messages = messages;
        this.commands = commands;
        this.undoCommands = undoCommands;
    }

    public void setConnectionLine(Collection<PerkConnectionIcon> connectionLine) {
        this.connectionLine = connectionLine;
    }

    public Collection<PerkConnectionIcon> getConnectionLine() {
        return this.connectionLine;
    }

    public Collection<ResourceExpense> getExpenses() {
        return this.expenses;
    }

    public Collection<UnlockCondition> getConditions() {
        return this.conditions;
    }

    public String getPermissionRequirement() {
        return this.permissionRequirement;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public List<String> getUndoCommands() {
        return this.undoCommands;
    }

    public boolean canUnlock(Player p) {
        PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
        if (profile.getUnlockedPerks().contains(this.name) || profile.getPermanentlyUnlockedPerks().contains(this.name) || profile.getPermanentlyLockedPerks().contains(this.name) || profile.getFakeUnlockedPerks().contains(this.name)) {
            return false;
        }
        return this.metResourceRequirements(p) && this.metLevelRequirement(p) && this.metConditionRequirements(p, false);
    }

    public boolean shouldLock(Player p) {
        PowerProfile profile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        if (!profile.getUnlockedPerks().contains(this.name) && !profile.getPermanentlyUnlockedPerks().contains(this.name)) {
            return false;
        }
        return !this.metLevelRequirement(p) || !this.metConditionRequirements(p, false);
    }

    public boolean metResourceRequirements(Player p) {
        return this.expenses.isEmpty() || this.expenses.stream().allMatch(e -> e.canPurchase(p));
    }

    public boolean metConditionRequirements(Player p, boolean visibilityCheck) {
        return this.conditions.isEmpty() || this.conditions.stream().allMatch(e -> e.canUnlock(p, visibilityCheck));
    }

    public boolean shouldBeVisible(Player p) {
        if (!this.isHiddenUntilRequirementsMet() || this.canUnlock(p)) {
            return true;
        }
        PowerProfile profile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        if (profile.getUnlockedPerks().contains(this.name) || profile.getPermanentlyUnlockedPerks().contains(this.name)) {
            return true;
        }
        if (profile.getPermanentlyLockedPerks().contains(this.name)) {
            return false;
        }
        if (profile.getFakeUnlockedPerks().contains(this.name)) {
            return true;
        }
        return this.metConditionRequirements(p, true);
    }

    public int getCustomModelDataUnlocked() {
        return this.customModelDataUnlocked;
    }

    public int getCustomModelDataVisible() {
        return this.customModelDataVisible;
    }

    public void setCustomModelDataUnlocked(int customModelDataUnlocked) {
        this.customModelDataUnlocked = customModelDataUnlocked;
    }

    public void setCustomModelDataVisible(int customModelDataVisible) {
        this.customModelDataVisible = customModelDataVisible;
    }

    public int getCustomModelDataUnlockable() {
        return this.customModelDataUnlockable;
    }

    public void setCustomModelDataUnlockable(int customModelDataUnlockable) {
        this.customModelDataUnlockable = customModelDataUnlockable;
    }

    public boolean hasUnlocked(Player p) {
        PowerProfile profile = ProfileRegistry.getPersistentProfile(p, PowerProfile.class);
        return profile.getUnlockedPerks().contains(this.name) || profile.getPermanentlyUnlockedPerks().contains(this.name);
    }

    public boolean hasPermanentlyLocked(Player p) {
        PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
        return profile.getPermanentlyLockedPerks().contains(this.name);
    }

    public boolean hasFakeUnlocked(Player p) {
        PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
        return profile.getFakeUnlockedPerks().contains(this.name);
    }

    public boolean metLevelRequirement(Player p) {
        Profile profile = ProfileRegistry.getPersistentProfile(p, this.skill.getProfileType());
        return profile.getLevel() >= this.levelRequirement;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHiddenUntilRequirementsMet() {
        return this.hiddenUntilRequirementsMet;
    }

    public int getLevelRequirement() {
        return this.levelRequirement;
    }

    public List<PerkReward> getRewards() {
        return this.rewards;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getDescription() {
        return this.description;
    }

    public void execute(Player p) {
        for (String message : this.messages) {
            for (PerkReward reward : this.rewards) {
                if (message == null) continue;
                message = message.replace("{" + reward.getName() + "}", reward.rewardPlaceholder());
            }
            p.sendMessage(Utils.chat(message));
        }
        for (String command : this.commands) {
            ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), command.replace("%player%", p.getName()));
        }
        for (PerkReward reward : this.rewards) {
            reward.apply(p);
        }
    }

    public void remove(Player p) {
        for (String command : this.undoCommands) {
            ValhallaMMO.getInstance().getServer().dispatchCommand((CommandSender)ValhallaMMO.getInstance().getServer().getConsoleSender(), command.replace("%player%", p.getName()));
        }
        for (PerkReward reward : this.rewards) {
            if (reward.isPersistent()) continue;
            reward.remove(p);
        }
        for (ResourceExpense expense : this.expenses) {
            if (!expense.isRefundable()) continue;
            expense.refund(p);
        }
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Map<Class<? extends ResourceExpense>, ResourceExpense> getMappedExpenses() {
        return this.mappedExpenses;
    }

    public Map<Class<? extends UnlockCondition>, UnlockCondition> getMappedConditions() {
        return this.mappedConditions;
    }
}

