/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerBlocksDropItemsEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.DiggingProfile;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.DiggingArchaeologyExtension;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DiggingSkill
extends Skill
implements Listener {
    private final Map<String, Double> dropsExpValues = new HashMap<String, Double>();
    private boolean forgivingDropMultipliers = true;

    public DiggingSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/digging_progression.yml");
        ValhallaMMO.getInstance().save("skills/digging.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/digging.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/digging_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.forgivingDropMultipliers = skillConfig.getBoolean("forgiving_multipliers");
        ConfigurationSection blockBreakSection = progressionConfig.getConfigurationSection("experience.digging_break");
        if (blockBreakSection != null) {
            for (String key : blockBreakSection.getKeys(false)) {
                double reward = progressionConfig.getDouble("experience.digging_break." + key);
                this.dropsExpValues.put(key, reward);
            }
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new DiggingArchaeologyExtension(this), (Plugin)ValhallaMMO.getInstance());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        String type = BlockUtils.getBlockType(e.getBlock());
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.dropsExpValues.containsKey(type) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-digging")) {
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        DiggingProfile profile = ProfileCache.getOrCache(e.getPlayer(), DiggingProfile.class);
        e.setExpToDrop(e.getExpToDrop() + Utils.randomAverage(profile.getBlockExperienceRate()));
        LootListener.addPreparedLuck(e.getBlock(), AccumulativeStatManager.getCachedStats("DIGGING_LUCK", (Entity)e.getPlayer(), 10000L, true));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void lootTableDrops(BlockBreakEvent e) {
        String type = BlockUtils.getBlockType(e.getBlock());
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.dropsExpValues.containsKey(type) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-digging") || e.getBlock().getState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("DIGGING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        ItemUtils.multiplyItems(LootListener.getPreparedExtraDrops(e.getBlock()), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(ItemUtils.getItemType(i)));
        double expQuantity = 0.0;
        for (ItemStack i2 : LootListener.getPreparedExtraDrops(e.getBlock())) {
            if (ItemUtils.isEmpty(i2)) continue;
            expQuantity += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(i2), 0.0) * (double)i2.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemsDropped(BlockDropItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlockState().getWorld().getName()) || !BlockUtils.canReward(e.getBlockState()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-digging") || !this.dropsExpValues.containsKey(e.getBlockState().getType().toString()) || e.getBlockState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("DIGGING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        List<ItemStack> extraDrops = ItemUtils.multiplyDrops(e.getItems(), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(ItemUtils.getItemType(i.getItemStack())));
        if (!extraDrops.isEmpty()) {
            LootListener.prepareBlockDrops(e.getBlock(), extraDrops);
        }
        double expQuantity = 0.0;
        for (Item item : e.getItems()) {
            if (ItemUtils.isEmpty(item.getItemStack())) continue;
            expQuantity += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(item.getItemStack()), 0.0) * (double)item.getItemStack().getAmount();
        }
        for (ItemStack itemStack : extraDrops) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            expQuantity += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(itemStack), 0.0) * (double)itemStack.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return DiggingProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 30;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-digging")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("DIGGING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onOtherBlockDrops(PlayerBlocksDropItemsEvent e) {
        double exp = 0.0;
        for (Block b : e.getBlocksAndItems().keySet()) {
            for (ItemStack i : (List)e.getBlocksAndItems().getOrDefault(b, new ArrayList())) {
                if (ItemUtils.isEmpty(i)) continue;
                exp += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(i), 0.0) * (double)i.getAmount();
            }
        }
        this.addEXP(e.getPlayer(), exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    public Map<String, Double> getDropsExpValues() {
        return this.dropsExpValues;
    }
}

