/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EnchantingItemPropertyManager;
import me.athlaeos.valhallammo.item.EnchantmentClassification;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.listeners.EntitySpawnListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.EnchantingProfile;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class EnchantingSkill
extends Skill
implements Listener {
    private static final Map<String, Animation> elementalHitAnimation = new HashMap<String, Animation>();
    private final Map<Enchantment, Double> enchantmentBaseValues = new HashMap<Enchantment, Double>();
    private final Map<Integer, Double> enchantmentLevelMultipliers = new HashMap<Integer, Double>();
    private double experienceSpentConversion = 0.0;
    private double diminishingReturnsMultiplier = 0.0;
    private int diminishingReturnsCount = 0;
    private boolean anvilDowngrading = false;
    private final Map<EntityType, Double> entityEXPMultipliers = new HashMap<EntityType, Double>();
    private final Map<UUID, Map<EntityType, Integer>> diminishingReturnTallyCounter = new HashMap<UUID, Map<EntityType, Integer>>();
    private boolean isChunkNerfed = true;
    private Animation elementalBladeActivationAnimation = AnimationRegistry.ELEMENTAL_BLADE_ACTIVATION;
    private Animation elementaBladeExpirationAnimation = AnimationRegistry.ELEMENTAL_BLADE_EXPIRATION;
    private static final Map<UUID, Map<Material, Map<Integer, EnchantmentOffer[]>>> storedEnchantmentOffers = new HashMap<UUID, Map<Material, Map<Integer, EnchantmentOffer[]>>>();
    private static final Map<UUID, Integer> enchantmentOfferSkillLevels = new HashMap<UUID, Integer>();
    private static final Map<UUID, Map<Enchantment, Integer>> anvilMaxLevelCache = new HashMap<UUID, Map<Enchantment, Integer>>();
    private static final Collection<UUID> activeElementalBlade = new HashSet<UUID>();

    public void setElementalBladeExpirationAnimation(Animation elementaBladeExpirationAnimation) {
        this.elementaBladeExpirationAnimation = elementaBladeExpirationAnimation;
    }

    public void setElementalBladeActivationAnimation(Animation elementalBladeActivationAnimation) {
        this.elementalBladeActivationAnimation = elementalBladeActivationAnimation;
    }

    public EnchantingSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ConfigurationSection levelMultiplierSection;
        ConfigurationSection baseEnchantmentValueSection;
        ValhallaMMO.getInstance().save("skills/enchanting_progression.yml");
        ValhallaMMO.getInstance().save("skills/enchanting.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/enchanting.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/enchanting_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.experienceSpentConversion = progressionConfig.getDouble("experience.exp_gain.experience_spent_conversion", 2.0);
        this.anvilDowngrading = skillConfig.getBoolean("anvil_downgrading");
        this.diminishingReturnsMultiplier = progressionConfig.getDouble("experience.diminishing_returns.multiplier");
        this.diminishingReturnsCount = progressionConfig.getInt("experience.diminishing_returns.amount");
        this.isChunkNerfed = progressionConfig.getBoolean("experience.mob_exp_chunk_nerfed", true);
        ConfigurationSection expReducedEntitySection = progressionConfig.getConfigurationSection("experience.diminishing_returns.mob_experience");
        if (expReducedEntitySection != null) {
            expReducedEntitySection.getKeys(false).forEach(k -> {
                EntityType e = Catch.catchOrElse(() -> EntityType.valueOf((String)k), null, "Invalid entity type given at skills/enchanting_progression.yml experience.diminishing_returns.mob_experience." + k);
                if (e == null) {
                    return;
                }
                double value = progressionConfig.getDouble("experience.diminishing_returns.mob_experience." + k);
                this.entityEXPMultipliers.put(e, value);
            });
        }
        if ((baseEnchantmentValueSection = progressionConfig.getConfigurationSection("experience.exp_gain.enchantment_base")) != null) {
            baseEnchantmentValueSection.getKeys(false).forEach(s -> {
                Enchantment e;
                if (s.equalsIgnoreCase("sweeping")) {
                    s = Utils.oldOrNew("sweeping", "sweeping_edge");
                }
                Enchantment enchantment = e = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)s.toLowerCase(Locale.US))) : Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)s.toLowerCase(Locale.US)));
                if (e != null) {
                    this.enchantmentBaseValues.put(e, progressionConfig.getDouble("experience.exp_gain.enchantment_base." + s));
                } else {
                    ValhallaMMO.logWarning("Invalid enchantment type given at progression_enchanting.yml experience.exp_gain.enchantment_base." + s);
                }
            });
        }
        if ((levelMultiplierSection = progressionConfig.getConfigurationSection("experience.exp_gain.enchantment_level_multiplier")) != null) {
            levelMultiplierSection.getKeys(false).forEach(s -> {
                try {
                    this.enchantmentLevelMultipliers.put(Integer.parseInt(s), progressionConfig.getDouble("experience.exp_gain.enchantment_level_multiplier." + s));
                }
                catch (NumberFormatException ignored) {
                    ValhallaMMO.logWarning("Invalid enchantment level given at skills/enchanting.yml experience.exp_gain.enchantment_level_multiplier." + s);
                }
            });
        }
        elementalHitAnimation.put("LIGHTNING", AnimationRegistry.HIT_ELECTRIC);
        elementalHitAnimation.put("ENTITY_EXPLOSION", AnimationRegistry.HIT_EXPLOSION);
        elementalHitAnimation.put("FIRE", AnimationRegistry.HIT_FIRE);
        elementalHitAnimation.put("FREEZE", AnimationRegistry.HIT_FREEZING);
        elementalHitAnimation.put("MAGIC", AnimationRegistry.HIT_MAGIC);
        elementalHitAnimation.put("NECROTIC", AnimationRegistry.HIT_NECROTIC);
        elementalHitAnimation.put("POISON", AnimationRegistry.HIT_POISON);
        elementalHitAnimation.put("RADIANT", AnimationRegistry.HIT_RADIANT);
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    public static void setElementalHit(String damageType, Animation animation) {
        elementalHitAnimation.put(damageType, animation);
    }

    public static void removeElementalHit(String damageType) {
        elementalHitAnimation.remove(damageType);
    }

    @EventHandler(ignoreCancelled=true)
    public void onGrindstoneUsage(InventoryClickEvent e) {
        if (WorldGuardHook.inDisabledRegion(e.getWhoClicked().getLocation(), (Player)e.getWhoClicked(), "vmmo-skill-enchanting")) {
            return;
        }
        if (e.getClickedInventory() instanceof GrindstoneInventory) {
            Timer.setCooldown(e.getWhoClicked().getUniqueId(), 5000, "cancel_essence_multiplication");
        }
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return EnchantingProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 10;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-enchanting")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPrepareEnchant(PrepareItemEnchantEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEnchanter().getWorld().getName()) || WorldGuardHook.inDisabledRegion(e.getEnchanter().getLocation(), e.getEnchanter(), "vmmo-skill-enchanting")) {
            return;
        }
        Map existingMaterialOffers = storedEnchantmentOffers.getOrDefault(e.getEnchanter().getUniqueId(), new HashMap());
        Map existingLevelOffers = existingMaterialOffers.getOrDefault(e.getItem().getType(), new HashMap());
        Player enchanter = e.getEnchanter();
        ItemBuilder item = new ItemBuilder(e.getItem());
        if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.UNENCHANTABLE)) {
            e.setCancelled(true);
            return;
        }
        if (!existingLevelOffers.containsKey(e.getEnchantmentBonus())) {
            int skill = (int)AccumulativeStatManager.getCachedStats("ENCHANTING_QUALITY", (Entity)enchanter, 10000L, true);
            skill = (int)((double)skill * (1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_FRACTION_QUALITY", (Entity)enchanter, 10000L, true)));
            double chance = AccumulativeStatManager.getCachedStats("ENCHANTING_AMPLIFY_CHANCE", (Entity)e.getEnchanter(), 10000L, true);
            EnchantingItemPropertyManager.scaleEnchantmentOffers(skill, e.getOffers(), chance);
            EnchantingProfile profile = ProfileCache.getOrCache(enchanter, EnchantingProfile.class);
            for (EnchantmentOffer offer : e.getOffers()) {
                if (offer == null) continue;
                int enchantmentBonus = profile.getEnchantmentBonus(offer.getEnchantment()) + profile.getEnchantmentBonus(EnchantmentClassification.getClassification(offer.getEnchantment()));
                offer.setEnchantmentLevel(offer.getEnchantmentLevel() + enchantmentBonus);
            }
            existingLevelOffers.put(e.getEnchantmentBonus(), e.getOffers());
            existingMaterialOffers.put(e.getItem().getType(), existingLevelOffers);
            enchantmentOfferSkillLevels.put(e.getEnchanter().getUniqueId(), skill);
            storedEnchantmentOffers.put(e.getEnchanter().getUniqueId(), existingMaterialOffers);
        } else {
            EnchantmentOffer[] storedOffers = (EnchantmentOffer[])existingLevelOffers.get(e.getEnchantmentBonus());
            for (int i = 0; i < storedOffers.length && i < e.getOffers().length; ++i) {
                e.getOffers()[i] = storedOffers[i];
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnchantItem(EnchantItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEnchanter().getWorld().getName()) || WorldGuardHook.inDisabledRegion(e.getEnchanter().getLocation(), e.getEnchanter(), "vmmo-skill-enchanting")) {
            return;
        }
        Player enchanter = e.getEnchanter();
        ItemBuilder item = new ItemBuilder(e.getItem());
        if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.UNENCHANTABLE)) {
            e.setCancelled(true);
            return;
        }
        int skill = (int)AccumulativeStatManager.getCachedStats("ENCHANTING_QUALITY", (Entity)enchanter, 10000L, true);
        skill = (int)((double)skill * (1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_FRACTION_QUALITY", (Entity)enchanter, 10000L, true)));
        double chance = AccumulativeStatManager.getCachedStats("ENCHANTING_AMPLIFY_CHANCE", (Entity)enchanter, 10000L, true);
        EnchantingProfile profile = ProfileCache.getOrCache(enchanter, EnchantingProfile.class);
        boolean accessible = this.hasPermissionAccess(e.getEnchanter());
        for (Object en : e.getEnchantsToAdd().keySet()) {
            int enchantmentBonus;
            int n = enchantmentBonus = accessible ? profile.getEnchantmentBonus((Enchantment)en) + profile.getEnchantmentBonus(EnchantmentClassification.getClassification((Enchantment)en)) : 0;
            if (Utils.proc(chance, 0.0, false)) {
                e.getEnchantsToAdd().put(en, Math.max(1, EnchantingItemPropertyManager.getScaledLevel((Enchantment)en, skill, (Integer)e.getEnchantsToAdd().get(en)) + enchantmentBonus));
                continue;
            }
            e.getEnchantsToAdd().put(en, Math.max(1, (Integer)e.getEnchantsToAdd().get(en) + enchantmentBonus));
        }
        Map cachedOffers = ((Map)storedEnchantmentOffers.getOrDefault(enchanter.getUniqueId(), new HashMap())).getOrDefault(e.getItem().getType(), new HashMap());
        if (enchantmentOfferSkillLevels.getOrDefault(enchanter.getUniqueId(), 0) == skill) {
            Object en;
            en = cachedOffers.values().iterator();
            block1: while (en.hasNext()) {
                EnchantmentOffer[] offers;
                for (EnchantmentOffer offer : offers = (EnchantmentOffer[])en.next()) {
                    if (offer == null || offer.getCost() != e.getExpLevelCost() || !e.getEnchantsToAdd().containsKey(offer.getEnchantment())) continue;
                    e.getEnchantsToAdd().put(offer.getEnchantment(), offer.getEnchantmentLevel());
                    break block1;
                }
            }
        }
        int expSpent = EntityUtils.getTotalExperience(enchanter.getLevel()) - EntityUtils.getTotalExperience(enchanter.getLevel() - (e.whichButton() + 1));
        double exp = this.EXPForEnchantments(enchanter, e.getEnchantsToAdd()) + this.experienceSpentConversion * (double)expSpent;
        this.addEXP(enchanter, exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
        storedEnchantmentOffers.remove(enchanter.getUniqueId());
        enchantmentOfferSkillLevels.remove(enchanter.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent e) {
        LivingEntity v;
        Player p;
        block14: {
            block13: {
                if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !EntityDamagedListener.getEntityDamageCauses().contains(e.getCause().toString())) {
                    return;
                }
                Entity trueDamager = EntityUtils.getTrueDamager(e);
                if (!(trueDamager instanceof Player)) break block13;
                p = (Player)trueDamager;
                Entity entity = e.getEntity();
                if (!(entity instanceof LivingEntity)) break block13;
                v = (LivingEntity)entity;
                if (this.hasPermissionAccess(p) && !EntityUtils.hasActiveDamageProcess((Entity)v)) break block14;
            }
            return;
        }
        if (WorldGuardHook.inDisabledRegion(e.getDamager().getLocation(), p, "vmmo-skill-enchanting")) {
            return;
        }
        EnchantingProfile profile = ProfileCache.getOrCache(p, EnchantingProfile.class);
        if (profile.getElementalDamageTypes().isEmpty()) {
            return;
        }
        boolean enhanced = false;
        if (activeElementalBlade.contains(p.getUniqueId())) {
            float expToSpend = profile.getEssenceCostPerHit();
            double refundChance = AccumulativeStatManager.getCachedStats("ENCHANTING_REFUND_CHANCE", (Entity)p, 10000L, true);
            if (Utils.proc((LivingEntity)p, refundChance, false)) {
                double refundAmount = Math.max(0.0, Math.min(AccumulativeStatManager.getCachedStats("ENCHANTING_REFUND_AMOUNT", (Entity)p, 10000L, true), 1.0));
                expToSpend *= (float)(1.0 - refundAmount);
            }
            int finalCost = Utils.randomAverage(expToSpend);
            int totalEXP = EntityUtils.getTotalExperience(p);
            if (totalEXP < finalCost) {
                activeElementalBlade.remove(p.getUniqueId());
                Utils.sendActionBar(p, TranslationManager.getTranslation("skill-enchanting-elemental-blade-expiration-actionbar"));
                Utils.sendMessage((CommandSender)p, TranslationManager.getTranslation("skill-enchanting-elemental-blade-expiration-chat"));
                if (this.elementaBladeExpirationAnimation != null) {
                    this.elementaBladeExpirationAnimation.animate((LivingEntity)p, p.getLocation(), p.getEyeLocation().getDirection(), 0);
                }
            } else {
                enhanced = true;
                EntityUtils.setTotalExperience(p, totalEXP - finalCost);
            }
        }
        double conversion = profile.getPassiveElementalDamageConversion();
        double damagePerType = enhanced ? e.getDamage() * (conversion += (double)profile.getActiveElementalDamageConversion()) / (double)profile.getElementalDamageTypes().size() * (double)(1.0f + profile.getActiveElementalDamageMultiplier()) : e.getDamage() * conversion / (double)profile.getElementalDamageTypes().size();
        if (conversion <= 0.0) {
            return;
        }
        e.setDamage(e.getDamage() * (1.0 - conversion));
        boolean en = enhanced;
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            for (String damageType : profile.getElementalDamageTypes()) {
                Location location;
                Animation a;
                EntityUtils.damage(v, (Entity)p, damagePerType, damageType, false);
                if (!en || (a = elementalHitAnimation.get(damageType)) == null) continue;
                Entity patt0$temp = e.getDamager();
                if (patt0$temp instanceof Projectile) {
                    Projectile pr = (Projectile)patt0$temp;
                    location = pr.getLocation();
                } else {
                    location = v.getEyeLocation();
                }
                a.animate(v, location, p.getEyeLocation().getDirection(), 0);
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHandSwap(PlayerSwapHandItemsEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || !e.getPlayer().isSneaking()) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-enchanting")) {
            return;
        }
        if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "delay_hand_swap")) {
            return;
        }
        if (ItemUtils.isEmpty(e.getOffHandItem())) {
            return;
        }
        if (!EquipmentClass.isHandHeld(ItemUtils.getItemMeta(e.getOffHandItem()))) {
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        EnchantingProfile profile = ProfileCache.getOrCache(e.getPlayer(), EnchantingProfile.class);
        if (profile.getActiveElementalDamageMultiplier() == 0.0f && profile.getActiveElementalDamageConversion() == 0.0f) {
            return;
        }
        if (activeElementalBlade.contains(e.getPlayer().getUniqueId())) {
            activeElementalBlade.remove(e.getPlayer().getUniqueId());
            Utils.sendActionBar(e.getPlayer(), TranslationManager.getTranslation("skill-enchanting-elemental-blade-expiration-actionbar"));
            Utils.sendMessage((CommandSender)e.getPlayer(), TranslationManager.getTranslation("skill-enchanting-elemental-blade-expiration-chat"));
            if (this.elementaBladeExpirationAnimation != null) {
                this.elementaBladeExpirationAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
            }
        } else {
            activeElementalBlade.add(e.getPlayer().getUniqueId());
            Utils.sendActionBar(e.getPlayer(), TranslationManager.getTranslation("skill-enchanting-elemental-blade-activation-actionbar"));
            Utils.sendMessage((CommandSender)e.getPlayer(), TranslationManager.getTranslation("skill-enchanting-elemental-blade-activation-chat"));
            if (this.elementalBladeActivationAnimation != null) {
                this.elementalBladeActivationAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
            }
        }
        e.setCancelled(true);
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> e.getPlayer().updateInventory(), 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityKilled(EntityDeathEvent e) {
        if (!this.isChunkNerfed || e.getEntity().getKiller() == null || EntitySpawnListener.isTrialSpawned((Entity)e.getEntity())) {
            return;
        }
        if (ChunkEXPNerf.doesChunkEXPNerfApply(e.getEntity().getLocation().getChunk(), e.getEntity().getKiller(), "enchanting_mob_tally_" + e.getEntityType().toString().toLowerCase(), this.diminishingReturnsCount)) {
            this.incrementMobTally(e.getEntity().getKiller(), e.getEntityType());
        } else {
            ChunkEXPNerf.increment(e.getEntity().getLocation().getChunk(), e.getEntity().getKiller(), "enchanting_mob_tally_" + e.getEntityType().toString().toLowerCase());
        }
        e.setDroppedExp(Utils.randomAverage((double)e.getDroppedExp() * this.entityEXPMultipliers.getOrDefault(e.getEntityType(), 1.0)));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExpAbsorb(PlayerExpChangeEvent e) {
        if (WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-enchanting")) {
            return;
        }
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cancel_essence_multiplication")) {
            return;
        }
        double multiplier = 1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_VANILLA_EXP_GAIN", (Entity)e.getPlayer(), 10000L, true);
        e.setAmount(Utils.randomAverage((double)e.getAmount() * multiplier));
    }

    private double EXPForEnchantments(Player p, Map<Enchantment, Integer> enchantments) {
        if (p == null) {
            return 0.0;
        }
        if (enchantments == null || enchantments.isEmpty()) {
            return 0.0;
        }
        double amount = 0.0;
        for (Enchantment e : enchantments.keySet()) {
            double levelMultiplier = this.enchantmentLevelMultipliers.getOrDefault(enchantments.get(e), 0.0);
            double baseAmount = this.enchantmentBaseValues.getOrDefault(e, 0.0);
            amount += baseAmount * levelMultiplier;
        }
        if (this.doDiminishingReturnsApply(p)) {
            amount *= this.diminishingReturnsMultiplier;
            this.reduceTallyCounter(p);
        }
        return amount;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnvilUsage(PrepareAnvilEvent e) {
        Player combiner = (Player)e.getView().getPlayer();
        if (WorldGuardHook.inDisabledRegion(combiner.getLocation(), combiner, "vmmo-skill-enchanting")) {
            return;
        }
        ItemStack i1 = e.getInventory().getItem(0);
        ItemStack i2 = e.getInventory().getItem(1);
        ItemStack r = e.getResult();
        if (!(ItemUtils.isEmpty(i1) || ItemUtils.isEmpty(i2) || ItemUtils.isEmpty(r))) {
            EnchantmentStorageMeta m;
            Map resultEnchantments;
            Map map;
            Map map2;
            ItemBuilder item1 = new ItemBuilder(i1);
            ItemBuilder item2 = new ItemBuilder(i2);
            ItemBuilder result = new ItemBuilder(r);
            ItemMeta itemMeta = item1.getMeta();
            if (itemMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta m2 = (EnchantmentStorageMeta)itemMeta;
                map2 = m2.getStoredEnchants();
            } else {
                map2 = item1.getItem().getEnchantments();
            }
            Map i1Enchantments = map2;
            ItemMeta itemMeta2 = item2.getMeta();
            if (itemMeta2 instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta m3 = (EnchantmentStorageMeta)itemMeta2;
                map = m3.getStoredEnchants();
            } else {
                map = item2.getItem().getEnchantments();
            }
            Map i2Enchantments = map;
            Object object = result.getMeta();
            if (object instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta m4 = (EnchantmentStorageMeta)object;
                v2 = m4.getStoredEnchants();
            } else {
                v2 = resultEnchantments = result.getItem().getEnchantments();
            }
            if (CustomFlag.hasFlag(item1.getMeta(), CustomFlag.UNENCHANTABLE) || CustomFlag.hasFlag(item2.getMeta(), CustomFlag.UNENCHANTABLE)) {
                boolean matches;
                boolean bl = matches = r.getEnchantments().size() == i1.getEnchantments().size();
                if (matches) {
                    object = i1Enchantments.keySet().iterator();
                    while (object.hasNext()) {
                        Enchantment en = (Enchantment)object.next();
                        if (resultEnchantments.getOrDefault(en, -1).intValue() == ((Integer)i1Enchantments.get(en)).intValue()) continue;
                        e.setResult(null);
                        return;
                    }
                }
            }
            if ((object = item2.getMeta()) instanceof EnchantmentStorageMeta ? (m = (EnchantmentStorageMeta)object).getStoredEnchants().isEmpty() : item2.getItem().getEnchantments().isEmpty()) {
                return;
            }
            HashMap<Enchantment, Integer> maxLevels = new HashMap();
            if (!anvilMaxLevelCache.containsKey(combiner.getUniqueId())) {
                boolean creative = combiner.getGameMode() == GameMode.CREATIVE;
                int skill = (int)AccumulativeStatManager.getCachedStats("ENCHANTING_QUALITY_ANVIL", (Entity)combiner, 10000L, true);
                skill = (int)((double)skill * (1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_FRACTION_QUALITY_ANVIL", (Entity)combiner, 10000L, true)));
                EnchantingProfile profile = ProfileCache.getOrCache(combiner, EnchantingProfile.class);
                boolean skillAccess = this.hasPermissionAccess(combiner);
                for (Enchantment en : Enchantment.values()) {
                    int enchantmentBonus;
                    int n = enchantmentBonus = skillAccess ? profile.getEnchantmentBonus(en) + profile.getEnchantmentBonus(EnchantmentClassification.getClassification(en)) : 0;
                    maxLevels.put(en, en.getMaxLevel() == 1 ? 1 : (creative ? Integer.MAX_VALUE : EnchantingItemPropertyManager.getScaledAnvilLevel(en, skill) + enchantmentBonus));
                }
                anvilMaxLevelCache.put(combiner.getUniqueId(), maxLevels);
            } else {
                maxLevels = anvilMaxLevelCache.get(combiner.getUniqueId());
                if (Timer.isCooldownPassed(combiner.getUniqueId(), "delay_anvil_cache_reset")) {
                    ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> anvilMaxLevelCache.remove(combiner.getUniqueId()), 5L);
                    Timer.setCooldown(combiner.getUniqueId(), 250, "delay_anvil_cache_reset");
                }
            }
            e.getInventory().setMaximumRepairCost(Integer.MAX_VALUE);
            combiner.updateInventory();
            Map<Enchantment, Integer> newEnchantments = this.combineEnchantments(i1Enchantments, i2Enchantments, maxLevels);
            result.disEnchant();
            for (Enchantment en : resultEnchantments.keySet()) {
                if (!newEnchantments.containsKey(en)) continue;
                result.enchant(en, newEnchantments.get(en));
            }
            e.setResult(result.get());
            if (e.getInventory().getRepairCost() >= 40) {
                e.getInventory().setRepairCost(39);
            }
            combiner.updateInventory();
        }
    }

    private Map<Enchantment, Integer> combineEnchantments(Map<Enchantment, Integer> item1Enchantments, Map<Enchantment, Integer> item2Enchantments, Map<Enchantment, Integer> maxAllowed) {
        int maxLevel;
        int level;
        HashMap<Enchantment, Integer> newEnchantments = new HashMap<Enchantment, Integer>();
        for (Enchantment e : item1Enchantments.keySet()) {
            level = item1Enchantments.get(e);
            maxLevel = maxAllowed.getOrDefault(e, e.getMaxLevel());
            if (item2Enchantments.containsKey(e)) {
                int compareLevel = item2Enchantments.get(e);
                if (level == compareLevel) {
                    newEnchantments.put(e, !this.anvilDowngrading && maxLevel <= level ? level : Math.min(maxLevel, level + 1));
                    continue;
                }
                newEnchantments.put(e, !this.anvilDowngrading && maxLevel <= level ? level : Math.min(maxLevel, Math.max(level, compareLevel)));
                continue;
            }
            newEnchantments.put(e, !this.anvilDowngrading && maxLevel <= level ? level : Math.min(maxLevel, level));
        }
        for (Enchantment e : item2Enchantments.keySet()) {
            level = item2Enchantments.get(e);
            maxLevel = maxAllowed.getOrDefault(e, e.getMaxLevel());
            if (item1Enchantments.containsKey(e)) continue;
            newEnchantments.put(e, !this.anvilDowngrading && maxLevel <= level ? level : Math.min(maxLevel, level));
        }
        return newEnchantments;
    }

    private void incrementMobTally(Player p, EntityType type) {
        if (p.hasPermission("valhalla.ignorediminishingreturns")) {
            return;
        }
        Map entityMap = this.diminishingReturnTallyCounter.getOrDefault(p.getUniqueId(), new HashMap());
        entityMap.put(type, entityMap.getOrDefault(type, 0) + 1);
        this.diminishingReturnTallyCounter.put(p.getUniqueId(), this.diminishingReturnTallyCounter.getOrDefault(p.getUniqueId(), entityMap));
    }

    private void reduceTallyCounter(Player p) {
        Map entityMap = this.diminishingReturnTallyCounter.getOrDefault(p.getUniqueId(), new HashMap());
        EntityType highest = entityMap.keySet().stream().filter(e -> entityMap.getOrDefault(e, 0) >= this.diminishingReturnsCount).findFirst().orElse(null);
        if (highest == null) {
            return;
        }
        int count = (Integer)entityMap.get(highest);
        entityMap.put(highest, count -= this.diminishingReturnsCount);
        this.diminishingReturnTallyCounter.put(p.getUniqueId(), entityMap);
    }

    private boolean doDiminishingReturnsApply(Player p) {
        if (p.hasPermission("valhalla.ignorediminishingreturns")) {
            return false;
        }
        Map entityMap = this.diminishingReturnTallyCounter.getOrDefault(p.getUniqueId(), new HashMap());
        EntityType highest = entityMap.keySet().stream().filter(e -> entityMap.getOrDefault(e, 0) >= this.diminishingReturnsCount).findFirst().orElse(null);
        return highest != null;
    }
}

