/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.event.EntityCustomPotionEffectEvent;
import me.athlaeos.valhallammo.event.PlayerLeaveCombatEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.HeavyArmorProfile;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class HeavyArmorSkill
extends Skill
implements Listener {
    private double expPerDamage = 0.0;
    private double expPerCombatSecond = 0.0;
    private double expBonusPerPoint = 0.0;
    private double pvpMultiplier = 0.1;
    private boolean isChunkNerfed = true;
    private Animation rageActivation;
    private final Map<EntityType, Double> entityExpMultipliers = new HashMap<EntityType, Double>();
    private final Collection<RagePotionEffect> ragePotionEffects = new HashSet<RagePotionEffect>();

    public HeavyArmorSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/heavy_armor_progression.yml");
        ValhallaMMO.getInstance().save("skills/heavy_armor.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/heavy_armor.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/heavy_armor_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.expPerDamage = progressionConfig.getDouble("experience.exp_damage_piece");
        this.expPerCombatSecond = progressionConfig.getDouble("experience.exp_second_piece");
        this.expBonusPerPoint = progressionConfig.getDouble("experience.exp_multiplier_point");
        this.pvpMultiplier = progressionConfig.getDouble("experience.pvp_multiplier");
        this.isChunkNerfed = progressionConfig.getBoolean("experience.is_chunk_nerfed", true);
        ConfigurationSection entitySection = progressionConfig.getConfigurationSection("experience.entity_exp_multipliers");
        if (entitySection != null) {
            entitySection.getKeys(false).forEach(s -> {
                EntityType e = Catch.catchOrElse(() -> EntityType.valueOf((String)s), null, "Invalid entity type given in skills/heavy_armor_progression.yml experience.entity_exp_multipliers." + s);
                if (e == null) {
                    return;
                }
                double multiplier = progressionConfig.getDouble("experience.entity_exp_multipliers." + s);
                this.entityExpMultipliers.put(e, multiplier);
            });
        }
        for (String potionEffectString : skillConfig.getStringList("rage_effects")) {
            String[] args = potionEffectString.split(";");
            if (args.length < 5) {
                ValhallaMMO.logWarning("Could not register Rage potion effect, not enough arguments: POTIONEFFECT;AMPLIFIERBASE;DURATIONBASE;AMPLIFIERLV;DURATIONLV");
                continue;
            }
            try {
                double baseAmplifier = StringUtils.parseDouble(args[1]);
                int baseDuration = Integer.parseInt(args[2]);
                double lvAmplifier = StringUtils.parseDouble(args[3]);
                int lvDuration = Integer.parseInt(args[4]);
                this.ragePotionEffects.add(new RagePotionEffect(args[0], baseAmplifier, baseDuration, lvAmplifier, lvDuration));
            }
            catch (NumberFormatException e) {
                ValhallaMMO.logWarning("Could not register Rage potion effect, invalid number: " + potionEffectString);
            }
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamageTaken(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity trueDamager = EntityUtils.getTrueDamager(e);
        if (!(trueDamager instanceof LivingEntity) || !((entity = e.getEntity()) instanceof Player) || (p = (Player)entity).isBlocking()) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyarmor")) {
            return;
        }
        HeavyArmorProfile profile = ProfileCache.getOrCache(p, HeavyArmorProfile.class);
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            double pvpMult;
            if (!p.isOnline() || e.getDamage() <= 0.0) {
                return;
            }
            double chunkNerf = this.isChunkNerfed ? ChunkEXPNerf.getChunkEXPNerf(p.getLocation().getChunk(), p, "armors") : 1.0;
            int count = EntityCache.getAndCacheProperties((LivingEntity)p).getHeavyArmorCount();
            double totalHeavyArmor = AccumulativeStatManager.getCachedStats("TOTAL_HEAVY_ARMOR", (Entity)p, 10000L, false);
            double entityExpMultiplier = this.entityExpMultipliers.getOrDefault(trueDamager.getType(), 1.0);
            double lastDamageTaken = e.getDamage();
            double exp = this.expPerDamage * lastDamageTaken * entityExpMultiplier * (1.0 + totalHeavyArmor * this.expBonusPerPoint) * chunkNerf;
            double d = pvpMult = trueDamager instanceof Player ? this.pvpMultiplier : 1.0;
            if (lastDamageTaken <= 1000000.0) {
                this.addEXP(p, pvpMult * pvpMult * (double)count * exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
            }
            if (!this.hasPermissionAccess(p)) {
                return;
            }
            if (profile.isRageUnlocked() && profile.getRageLevel() > 0 && Timer.isCooldownPassed(p.getUniqueId(), "cooldown_heavy_armor_rage") && !WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-combat-rage")) {
                EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
                if (properties.getHeavyArmorCount() < profile.getSetCount()) {
                    return;
                }
                AttributeInstance healthInstance = p.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (healthInstance == null) {
                    return;
                }
                if (p.getHealth() / healthInstance.getValue() > (double)profile.getRageThreshold()) {
                    return;
                }
                this.ragePotionEffects.forEach(r -> r.applyPotionEffect(p, profile.getRageLevel()));
                if (this.rageActivation != null) {
                    this.rageActivation.animate((LivingEntity)p, p.getLocation(), p.getEyeLocation().getDirection(), 0);
                }
                Timer.setCooldownIgnoreIfPermission((Entity)p, profile.getRageCooldown() * 50, "cooldown_heavy_armor_rage");
            } else if (!Timer.isCooldownPassed(p.getUniqueId(), "cooldown_heavy_armor_rage")) {
                Timer.sendCooldownStatus(p, "cooldown_heavy_armor_rage", TranslationManager.getTranslation("ability_rage"));
            }
            if (this.isChunkNerfed) {
                ChunkEXPNerf.increment(p.getLocation().getChunk(), p, "armors");
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionEffect(EntityPotionEffectEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || e.getNewEffect() == null || e.getCause() == EntityPotionEffectEvent.Cause.POTION_DRINK) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!this.hasPermissionAccess(p)) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyarmor")) {
            return;
        }
        HeavyArmorProfile profile = ProfileCache.getOrCache(p, HeavyArmorProfile.class);
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
        if (properties.getHeavyArmorCount() < profile.getSetCount()) {
            return;
        }
        PotionEffectMappings mapping = PotionEffectMappings.getEffect(e.getNewEffect().getType().getName());
        if (mapping == null) {
            return;
        }
        if (profile.getImmuneEffects().contains(mapping.getOldEffect()) || profile.getImmuneEffects().contains(mapping.getNewEffect())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionEffect(EntityCustomPotionEffectEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || e.getNewEffect() == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!this.hasPermissionAccess(p)) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-heavyarmor") || WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-combat-potionimmunity")) {
            return;
        }
        HeavyArmorProfile profile = ProfileCache.getOrCache(p, HeavyArmorProfile.class);
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
        if (properties.getHeavyArmorCount() < profile.getSetCount()) {
            return;
        }
        if (profile.getImmuneEffects().contains(e.getNewEffect().getWrapper().getEffect())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCombatLeave(PlayerLeaveCombatEvent e) {
        double chunkNerf;
        long timeInCombat = e.getTimeInCombat();
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)e.getPlayer());
        int armorCount = properties.getHeavyArmorCount();
        int expRewardTimes = (int)((double)timeInCombat / 1000.0);
        double d = chunkNerf = this.isChunkNerfed ? ChunkEXPNerf.getChunkEXPNerf(e.getPlayer().getLocation().getChunk(), e.getPlayer(), "armors") : 1.0;
        if (this.isChunkNerfed) {
            ChunkEXPNerf.increment(e.getPlayer().getLocation().getChunk(), e.getPlayer(), "armors");
        }
        this.addEXP(e.getPlayer(), (double)expRewardTimes * chunkNerf * (double)armorCount * this.expPerCombatSecond, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return HeavyArmorProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 65;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("HEAVY_ARMOR_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public void setRageActivation(Animation rageActivation) {
        this.rageActivation = rageActivation;
    }

    private static class RagePotionEffect {
        private final PotionEffectWrapper wrapper;
        private final double baseAmplifier;
        private final int baseDuration;
        private final double lvAmplifier;
        private final int lvDuration;

        public RagePotionEffect(String type, double baseAmplifier, int baseDuration, double lvAmplifier, int lvDuration) {
            this.wrapper = PotionEffectRegistry.getEffect(type);
            this.baseAmplifier = baseAmplifier;
            this.baseDuration = baseDuration;
            this.lvAmplifier = lvAmplifier;
            this.lvDuration = lvDuration;
        }

        public void applyPotionEffect(Player p, int level) {
            int duration = this.baseDuration + this.lvDuration * (level - 1);
            double amplifier = this.baseAmplifier + this.lvAmplifier * (double)(level - 1);
            if (this.wrapper.isVanilla()) {
                int amp = (int)amplifier - 1;
                if (amp < 0) {
                    return;
                }
                p.addPotionEffect(new PotionEffect(this.wrapper.getVanillaEffect(), duration, amp, false));
            } else {
                PotionEffectRegistry.addEffect((LivingEntity)p, null, new CustomPotionEffect(this.wrapper, duration, amplifier), false, 1.0, EntityPotionEffectEvent.Cause.ARROW);
            }
        }
    }
}

