/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.PlayerBlocksDropItemsEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MiningSkill
extends Skill
implements Listener {
    private final Map<String, Double> dropsExpValues = new HashMap<String, Double>();
    private double miningExpMultiplier = 1.0;
    private double blastingExpMultiplier = 1.0;
    private int veinMiningLimit = 64;
    private boolean veinMiningInstant = true;
    private boolean forgivingDropMultipliers = true;
    private boolean tntPreventChaining = true;
    private Animation drillingAnimation = AnimationRegistry.DRILLING_ACTIVE;
    private String drillingOn = null;
    private Sound drillingActivationSound = null;
    private final int[][] veinMiningScanArea = new int[][]{{-1, -1, -1}, {-1, -1, 0}, {-1, -1, 1}, {-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {-1, 1, -1}, {-1, 1, 0}, {-1, 1, 1}, {0, -1, -1}, {0, -1, 0}, {0, -1, 1}, {0, 0, -1}, {0, 0, 1}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {1, -1, -1}, {1, -1, 0}, {1, -1, 1}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}, {1, 1, -1}, {1, 1, 0}, {1, 1, 1}};
    private final Collection<UUID> veinMiningPlayers = new HashSet<UUID>();
    private final Collection<UUID> recursionPrevention = new HashSet<UUID>();

    public void setDrillingAnimation(Animation drillingAnimation) {
        this.drillingAnimation = drillingAnimation;
    }

    public MiningSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/mining_progression.yml");
        ValhallaMMO.getInstance().save("skills/mining.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/mining.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/mining_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.miningExpMultiplier = progressionConfig.getDouble("experience.exp_multiplier_mine");
        this.blastingExpMultiplier = progressionConfig.getDouble("experience.exp_multiplier_blast");
        this.veinMiningLimit = skillConfig.getInt("break_limit_vein_mining");
        this.veinMiningInstant = skillConfig.getBoolean("vein_mining_instant");
        this.forgivingDropMultipliers = skillConfig.getBoolean("forgiving_multipliers");
        this.tntPreventChaining = skillConfig.getBoolean("remove_tnt_chaining");
        this.drillingOn = TranslationManager.translatePlaceholders(skillConfig.getString("drilling_toggle_on"));
        this.drillingActivationSound = Utils.getSound(skillConfig.getString("drilling_enable_sound"), null, "Invalid drilling activation sound given in skills/mining.yml drilling_enable_sound");
        ConfigurationSection blockBreakSection = progressionConfig.getConfigurationSection("experience.mining_break");
        if (blockBreakSection != null) {
            for (String key : blockBreakSection.getKeys(false)) {
                double reward = progressionConfig.getDouble("experience.mining_break." + key);
                this.dropsExpValues.put(key, reward);
            }
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        String type = BlockUtils.getBlockType(e.getBlock());
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-mining") || !this.dropsExpValues.containsKey(type) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        MiningProfile profile = ProfileCache.getOrCache(e.getPlayer(), MiningProfile.class);
        if (profile.getUnbreakableBlocks().contains(type)) {
            e.setCancelled(true);
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        if (BlockUtils.canReward(e.getBlock())) {
            int experience = e.getExpToDrop() + Utils.randomAverage(profile.getBlockExperienceRate());
            experience = Utils.randomAverage((double)experience * (1.0 + (double)profile.getBlockExperienceMultiplier()));
            e.setExpToDrop(experience);
        }
        LootListener.addPreparedLuck(e.getBlock(), AccumulativeStatManager.getCachedStats("MINING_LUCK", (Entity)e.getPlayer(), 10000L, true));
        if (e.getPlayer().isSneaking() && !this.veinMiningPlayers.contains(e.getPlayer().getUniqueId()) && profile.isVeinMiningUnlocked() && profile.getVeinMinerValidBlocks().contains(type) && Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "mining_vein_miner") && !WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-veinminer")) {
            Collection<Block> vein = BlockUtils.getBlockVein(e.getBlock(), this.veinMiningLimit, b -> b.getType() == e.getBlock().getType(), this.veinMiningScanArea);
            this.veinMiningPlayers.add(e.getPlayer().getUniqueId());
            e.setCancelled(true);
            if (this.veinMiningInstant) {
                BlockUtils.processBlocks(e.getPlayer(), vein, p -> {
                    EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
                    return properties.getMainHand() != null && EquipmentClass.getMatchingClass(properties.getMainHand().getMeta()) == EquipmentClass.PICKAXE;
                }, b -> {
                    if (profile.isVeinMiningInstantPickup()) {
                        LootListener.setInstantPickup(b, e.getPlayer());
                    }
                    CustomBreakSpeedListener.markInstantBreak(b);
                    e.getPlayer().breakBlock(b);
                }, b -> this.veinMiningPlayers.remove(b.getUniqueId()));
            } else {
                BlockUtils.processBlocksPulse(e.getPlayer(), e.getBlock(), vein, p -> {
                    EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)p);
                    return properties.getMainHand() != null && EquipmentClass.getMatchingClass(properties.getMainHand().getMeta()) == EquipmentClass.PICKAXE;
                }, b -> {
                    if (profile.isVeinMiningInstantPickup()) {
                        LootListener.setInstantPickup(b, e.getPlayer());
                    }
                    CustomBreakSpeedListener.markInstantBreak(b);
                    e.getPlayer().breakBlock(b);
                }, b -> this.veinMiningPlayers.remove(b.getUniqueId()));
            }
            Timer.setCooldownIgnoreIfPermission((Entity)e.getPlayer(), profile.getVeinMiningCooldown() * 50, "mining_vein_miner");
        } else if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "mining_vein_miner")) {
            Timer.sendCooldownStatus(e.getPlayer(), "mining_vein_miner", TranslationManager.getTranslation("ability_vein_miner"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void lootTableDrops(BlockBreakEvent e) {
        String type = BlockUtils.getBlockType(e.getBlock());
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-mining") || !this.dropsExpValues.containsKey(type) || e.getBlock().getState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("MINING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        ItemUtils.multiplyItems(LootListener.getPreparedExtraDrops(e.getBlock()), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(ItemUtils.getItemType(i)));
        double expQuantity = 0.0;
        for (ItemStack i2 : LootListener.getPreparedExtraDrops(e.getBlock())) {
            if (ItemUtils.isEmpty(i2)) continue;
            String itemType = ItemUtils.getItemType(i2);
            expQuantity += this.dropsExpValues.getOrDefault(itemType, 0.0) * (double)i2.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity * this.miningExpMultiplier, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemsDropped(BlockDropItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlockState().getWorld().getName()) || !BlockUtils.canReward(e.getBlockState()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-mining") || !this.dropsExpValues.containsKey(e.getBlockState().getType().toString()) || e.getBlockState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("MINING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        List<ItemStack> extraDrops = ItemUtils.multiplyDrops(e.getItems(), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(ItemUtils.getItemType(i.getItemStack())));
        if (!extraDrops.isEmpty()) {
            LootListener.prepareBlockDrops(e.getBlock(), extraDrops);
        }
        double expQuantity = 0.0;
        for (Item item : e.getItems()) {
            if (ItemUtils.isEmpty(item.getItemStack())) continue;
            expQuantity += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(item.getItemStack()), 0.0) * (double)item.getItemStack().getAmount();
        }
        for (ItemStack itemStack : extraDrops) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            expQuantity += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(itemStack), 0.0) * (double)itemStack.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity * this.miningExpMultiplier, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || !e.getPlayer().isSneaking() || e.getHand() == EquipmentSlot.OFF_HAND || e.useItemInHand() == Event.Result.DENY || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "mining_drilling_cooldown") || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "mining_drilling_duration") || e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-mining") || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-drilling")) {
            if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "mining_drilling_cooldown")) {
                Timer.sendCooldownStatus(e.getPlayer(), "mining_drilling_cooldown", TranslationManager.getTranslation("ability_drilling"));
            }
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        ItemStack hand = e.getPlayer().getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(hand) || !hand.getType().toString().endsWith("_PICKAXE")) {
            return;
        }
        MiningProfile profile = ProfileCache.getOrCache(e.getPlayer(), MiningProfile.class);
        if (!profile.isDrillingUnlocked() || profile.getDrillingDuration() < 0) {
            return;
        }
        Timer.setCooldownIgnoreIfPermission((Entity)e.getPlayer(), profile.getDrillingCooldown() * 50, "mining_drilling_cooldown");
        Timer.setCooldown(e.getPlayer().getUniqueId(), profile.getDrillingDuration() * 50, "mining_drilling_duration");
        Utils.sendActionBar(e.getPlayer(), this.drillingOn);
        if (this.drillingAnimation != null) {
            this.drillingAnimation.animate((LivingEntity)e.getPlayer(), e.getPlayer().getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
        }
        if (this.drillingActivationSound != null) {
            e.getPlayer().getWorld().playSound(e.getPlayer().getLocation(), this.drillingActivationSound, 1.0f, 1.0f);
        }
        if (!ValhallaMMO.isCustomMiningEnabled() && !MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
            int amplifier = (int)Math.round((double)profile.getDrillingSpeedBonus() / 0.2) - 1;
            if (amplifier < 0) {
                return;
            }
            e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, profile.getDrillingDuration(), amplifier, true, false, false));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent e) {
        Player p;
        AbstractArrow a;
        Player p2;
        TNTPrimed tnt;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || this.recursionPrevention.contains(e.getEntity().getUniqueId()) || !((entity = e.getEntity()) instanceof TNTPrimed) || (tnt = (TNTPrimed)entity).getSource() == null) {
            return;
        }
        Player responsible = null;
        Entity entity2 = tnt.getSource();
        responsible = entity2 instanceof Player && (p2 = (Player)entity2).isOnline() ? p2 : ((entity2 = tnt.getSource()) instanceof AbstractArrow && (entity2 = (a = (AbstractArrow)entity2).getShooter()) instanceof Player && (p = (Player)entity2).isOnline() ? p : EntityUtils.getClosestPlayer(e.getEntity().getLocation()));
        if (responsible == null) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(responsible.getLocation(), responsible, "vmmo-skill-mining")) {
            return;
        }
        MiningProfile profile = ProfileCache.getOrCache(responsible, MiningProfile.class);
        ItemStack normalPickaxe = new ItemStack(Material.IRON_PICKAXE);
        if (profile.getBlastFortuneLevel() > 0) {
            normalPickaxe.addUnsafeEnchantment(EnchantmentMappings.FORTUNE.getEnchantment(), profile.getBlastFortuneLevel());
        } else if (profile.getBlastFortuneLevel() < 0) {
            normalPickaxe.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
        }
        double blastingDropMultiplier = AccumulativeStatManager.getCachedStats("BLASTING_DROP_MULTIPLIER", (Entity)responsible, 10000L, true);
        double blastingLuck = AccumulativeStatManager.getCachedStats("BLASTING_LUCK", (Entity)responsible, 10000L, true);
        double exp = 0.0;
        ArrayList<Block> ourBlockList = new ArrayList<Block>();
        for (Block block : e.blockList()) {
            if (block.getState() instanceof Container || block.getType().isAir() || !this.tntPreventChaining && block.getType() == Material.TNT || !BlockUtils.canReward(block)) continue;
            ourBlockList.add(block);
        }
        e.blockList().removeAll(ourBlockList);
        this.recursionPrevention.add(e.getEntity().getUniqueId());
        EntityExplodeEvent explodeEvent = ValhallaMMO.getNms().getExplosionEvent(e.getEntity(), e.getLocation(), ourBlockList, e.getYield(), 1);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)explodeEvent);
        this.recursionPrevention.remove(e.getEntity().getUniqueId());
        if (explodeEvent.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        HashMap<Block, List<ItemStack>> blocksAndItems = new HashMap<Block, List<ItemStack>>();
        for (Block b : ourBlockList) {
            LootListener.addPreparedLuck(b, blastingLuck);
            ArrayList<ItemStack> predictedDrops = new ArrayList<ItemStack>(b.getDrops(normalPickaxe));
            ItemUtils.multiplyItems(predictedDrops, 1.0 + blastingDropMultiplier, this.forgivingDropMultipliers, i -> this.dropsExpValues.containsKey(ItemUtils.getItemType(i)));
            LootListener.markExploded(b);
            LootListener.setFortuneLevel(e.getEntity(), profile.getBlastFortuneLevel());
            LootListener.setEntityOwner(e.getEntity(), (Entity)responsible);
            if (profile.isBlastingInstantPickup()) {
                LootListener.setInstantPickup(b, responsible);
            }
            b.setType(Material.AIR);
            blocksAndItems.put(b, predictedDrops);
        }
        PlayerBlocksDropItemsEvent event = new PlayerBlocksDropItemsEvent(responsible, blocksAndItems);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        for (Block b : event.getBlocksAndItems().keySet()) {
            List drops = event.getBlocksAndItems().getOrDefault(b, new ArrayList());
            LootListener.prepareBlockDrops(b, drops);
            for (ItemStack i2 : drops) {
                if (ItemUtils.isEmpty(i2)) continue;
                exp += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(i2), 0.0) * (double)i2.getAmount();
            }
        }
        this.addEXP(responsible, exp * this.blastingExpMultiplier, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTNTDamage(EntityDamageByEntityEvent e) {
        block18: {
            block17: {
                block16: {
                    block15: {
                        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((var3_2 = e.getDamager()) instanceof TNTPrimed)) break block15;
                        tnt = (TNTPrimed)var3_2;
                        if (e.getEntity() instanceof Item || e.getEntity() instanceof Player) break block16;
                    }
                    return;
                }
                if (WorldGuardHook.inDisabledRegion(e.getEntity().getLocation(), "vmmo-skill-mining")) {
                    return;
                }
                var4_4 = e.getEntity();
                if (!(var4_4 instanceof Player)) break block17;
                p = (Player)var4_4;
                responsible = null;
                var8_5 = tnt.getSource();
                if (!(var8_5 instanceof Player)) ** GOTO lbl-1000
                pl = (Player)var8_5;
                if (p.isOnline()) {
                    responsible = pl;
                } else if ((var8_5 = tnt.getSource()) instanceof AbstractArrow && (var8_5 = (a = (AbstractArrow)var8_5).getShooter()) instanceof Player) {
                    pl = (Player)var8_5;
                    if (p.isOnline()) {
                        responsible = pl;
                    }
                }
                if (responsible == null || !p.getUniqueId().equals(responsible.getUniqueId())) {
                    return;
                }
                profile = ProfileCache.getOrCache(p, MiningProfile.class);
                e.setDamage(e.getDamage() * (double)(1.0f - profile.getTntDamageReduction()));
                break block18;
            }
            if (e.getEntity() instanceof Item) {
                responsible = null;
                var8_6 = tnt.getSource();
                if (var8_6 instanceof Player && (p = (Player)var8_6).isOnline()) {
                    responsible = p;
                } else {
                    var8_6 = tnt.getSource();
                    if (var8_6 instanceof AbstractArrow && (var8_6 = (a = (AbstractArrow)var8_6).getShooter()) instanceof Player && (p = (Player)var8_6).isOnline()) {
                        responsible = p;
                    }
                }
                if (responsible == null) {
                    return;
                }
                profile = ProfileCache.getOrCache(responsible, MiningProfile.class);
                if (profile.isBlastingItemImmunity()) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return MiningProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 20;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-mining")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("MINING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public Map<String, Double> getDropsExpValues() {
        return this.dropsExpValues;
    }
}

