/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.tools;

import java.util.Map;
import java.util.TreeMap;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockHardnessStick
implements Listener {
    private static final NamespacedKey HARDNESS_STICK = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "hardness_stick");
    private static final Map<Float, String> hardnessEquivalenceMap = new TreeMap<Float, String>();
    private static final ItemStack stick = new ItemBuilder(Material.STICK).name("&dHardness Stick: 1.5").lore("&fShift while scrolling to", "&fchange hardness setting.", "&eThe intensity depends on the", "&eslot this item is held in:", "&e1: 0.05, &62: 0.1, &e3: 0.5", "&e4: 1, &65: 5, &e6: 25", "&c7: 100, &48: 500, &c9: 2500", "", "&fLeft-Click block to change", "&fits hardness to your setting.", "", "&fRight-Click block to remove", "&fits custom hardness").floatTag(HARDNESS_STICK, 1.0f).get();

    private String getMaterialEquivalence(float hardness) {
        for (Float f : hardnessEquivalenceMap.keySet()) {
            if (!((double)hardness + 0.001 > (double)f.floatValue()) || !((double)hardness - 0.001 < (double)f.floatValue())) continue;
            return hardnessEquivalenceMap.get(f);
        }
        return "";
    }

    public static ItemStack getStick() {
        return stick;
    }

    private float getIntensity(int slot) {
        return switch (slot) {
            case 0 -> 0.05f;
            case 1 -> 0.1f;
            case 2 -> 0.5f;
            case 3 -> 1.0f;
            case 4 -> 5.0f;
            case 5 -> 25.0f;
            case 6 -> 100.0f;
            case 7 -> 500.0f;
            case 8 -> 2500.0f;
            default -> 0.0f;
        };
    }

    private boolean increasedSlot(int fromSlot, int toSlot) {
        return switch (fromSlot) {
            case 0 -> {
                if (toSlot < 4) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (toSlot > 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (toSlot > 2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (toSlot > 3) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (toSlot > 4) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (toSlot > 5) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (toSlot > 6) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                if (toSlot > 7) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                if (toSlot < 5) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onScroll(PlayerItemHeldEvent e) {
        if (!e.getPlayer().isSneaking()) {
            return;
        }
        ItemStack hand = e.getPlayer().getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(hand) || hand.getType() != Material.STICK) {
            return;
        }
        ItemBuilder item = new ItemBuilder(hand);
        if (!item.getMeta().getPersistentDataContainer().has(HARDNESS_STICK, PersistentDataType.FLOAT)) {
            return;
        }
        e.setCancelled(true);
        float currentValue = ((Float)item.getMeta().getPersistentDataContainer().getOrDefault(HARDNESS_STICK, PersistentDataType.FLOAT, (Object)Float.valueOf(-999.0f))).floatValue();
        if (currentValue <= -999.0f) {
            return;
        }
        float newValue = Math.max(-1.0f, currentValue + (this.increasedSlot(e.getPreviousSlot(), e.getNewSlot()) ? this.getIntensity(e.getPreviousSlot()) : -this.getIntensity(e.getPreviousSlot())));
        item.floatTag(HARDNESS_STICK, newValue);
        item.name(String.format("&dHardness Stick: %.2f%s", Float.valueOf(newValue), this.getMaterialEquivalence(newValue)));
        e.getPlayer().getInventory().setItemInMainHand(item.get());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockHardnessTouch(PlayerInteractEvent e) {
        if (e.useItemInHand() == Event.Result.DENY || e.getClickedBlock() == null) {
            return;
        }
        Block clicked = e.getClickedBlock();
        ItemStack hand = e.getPlayer().getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(hand) || hand.getType() != Material.STICK) {
            return;
        }
        ItemBuilder builder = new ItemBuilder(hand);
        if (!builder.getMeta().getPersistentDataContainer().has(HARDNESS_STICK, PersistentDataType.FLOAT)) {
            return;
        }
        if (e.getAction() == Action.LEFT_CLICK_BLOCK) {
            float hardnessSetting = ((Float)builder.getMeta().getPersistentDataContainer().getOrDefault(HARDNESS_STICK, PersistentDataType.FLOAT, (Object)Float.valueOf(-999.0f))).floatValue();
            if (hardnessSetting <= -999.0f) {
                return;
            }
            BlockUtils.setCustomHardness(clicked, hardnessSetting);
            AnimationUtils.outlineBlock(clicked, 10, 0.5f, 0, 255, 0);
            e.setCancelled(true);
        } else if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            BlockUtils.removeCustomHardness(clicked);
            AnimationUtils.outlineBlock(clicked, 10, 0.5f, 255, 0, 0);
            e.setCancelled(true);
        }
    }

    static {
        hardnessEquivalenceMap.put(Float.valueOf(55.0f), " &7(&8Reinforced Deepslate&7)");
        hardnessEquivalenceMap.put(Float.valueOf(50.0f), " &7(&dObsidian&7)");
        hardnessEquivalenceMap.put(Float.valueOf(30.0f), " &7(&8Ancient Debris&7)");
        hardnessEquivalenceMap.put(Float.valueOf(22.5f), " &7(&dEnder Chest&7)");
        hardnessEquivalenceMap.put(Float.valueOf(10.0f), " &7(&7Hardened Glass&7)");
        hardnessEquivalenceMap.put(Float.valueOf(5.0f), " &7(&fIron Block&7)");
        hardnessEquivalenceMap.put(Float.valueOf(4.5f), " &7(&8Deepslate Ores&7)");
        hardnessEquivalenceMap.put(Float.valueOf(4.0f), " &7(&fCobweb&7)");
        hardnessEquivalenceMap.put(Float.valueOf(3.5f), " &7(&7Furnace&7)");
        hardnessEquivalenceMap.put(Float.valueOf(3.0f), " &7(&7Regular Ores&7)");
        hardnessEquivalenceMap.put(Float.valueOf(2.8f), " &7(&9Blue Ice&7)");
        hardnessEquivalenceMap.put(Float.valueOf(2.5f), " &7(&6Chest&7)");
        hardnessEquivalenceMap.put(Float.valueOf(2.0f), " &7(&7Cobblestone&7)");
        hardnessEquivalenceMap.put(Float.valueOf(1.8f), " &7(&fConcrete&7)");
        hardnessEquivalenceMap.put(Float.valueOf(1.5f), " &7(&7Stone&7)");
        hardnessEquivalenceMap.put(Float.valueOf(1.25f), " &7(&cTerracotta&7)");
        hardnessEquivalenceMap.put(Float.valueOf(1.0f), " &7(&aMelon&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.8f), " &7(&fQuartz Block&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.75f), " &7(&fCalcite&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.7f), " &7(&7Rails&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.6f), " &7(&aGrass Block&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.5f), " &7(&6Dirt&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.4f), " &7(&cNetherrack&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.3f), " &7(&fGlass&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.2f), " &7(&aLeaves&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.1f), " &7(&fCarpet&7)");
        hardnessEquivalenceMap.put(Float.valueOf(0.0f), " &7(&fInstant&7)");
        hardnessEquivalenceMap.put(Float.valueOf(-1.0f), " &7(&cUnbreakable&7)");
    }
}

