/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossBarUtils {
    private static final Map<UUID, Map<String, TemporaryBossBar>> activeBossBars = new HashMap<UUID, Map<String, TemporaryBossBar>>();

    public static Map<UUID, Map<String, TemporaryBossBar>> getActiveBossBars() {
        return activeBossBars;
    }

    public static void showBossBarToPlayer(Player player, String title, double progress, int time, String skillType, BarColor color, BarStyle style) {
        TemporaryBossBar bossBar = null;
        Map<String, TemporaryBossBar> bars = activeBossBars.get(player.getUniqueId());
        if (bars != null) {
            bossBar = bars.get(skillType);
        }
        if (progress < 0.0) {
            progress = 0.0;
        }
        if (progress > 1.0) {
            progress = 1.0;
        }
        if (bossBar == null) {
            bossBar = new TemporaryBossBar(time, progress, title, player, skillType, color, style);
            Map<String, TemporaryBossBar> existingBossBars = activeBossBars.get(player.getUniqueId());
            if (existingBossBars == null) {
                existingBossBars = new HashMap<String, TemporaryBossBar>();
            }
            existingBossBars.put(skillType, bossBar);
            bossBar.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 2L);
            activeBossBars.put(player.getUniqueId(), existingBossBars);
        }
        bossBar.setTimer(time);
        bossBar.setFraction(progress);
        bossBar.setText(title);
    }

    public static class TemporaryBossBar
    extends BukkitRunnable {
        private int timer;
        private double fraction;
        private String text;
        private final BossBar bossBar;
        private final Player p;
        private final String skillType;
        private String lastText;
        private double lastFraction;

        public TemporaryBossBar(int timer, double fraction, String text, Player p, String skillType, BarColor color, BarStyle style) {
            this.timer = timer;
            this.fraction = fraction;
            this.text = text;
            this.p = p;
            this.skillType = skillType;
            this.bossBar = ValhallaMMO.getInstance().getServer().createBossBar(text, color, style, new BarFlag[0]);
        }

        public void run() {
            if (this.timer <= 0) {
                this.bossBar.removeAll();
                Map<String, TemporaryBossBar> existingBossBars = activeBossBars.get(this.p.getUniqueId());
                if (existingBossBars == null) {
                    existingBossBars = new HashMap<String, TemporaryBossBar>();
                }
                existingBossBars.remove(this.skillType);
                activeBossBars.put(this.p.getUniqueId(), existingBossBars);
                this.cancel();
            } else {
                if (!this.text.equals(this.lastText)) {
                    this.bossBar.setTitle(this.text);
                    this.lastText = this.text;
                }
                if (this.fraction != this.lastFraction) {
                    this.bossBar.setProgress(this.fraction);
                    this.lastFraction = this.fraction;
                }
                this.bossBar.addPlayer(this.p);
                --this.timer;
            }
        }

        public void setTimer(int timer) {
            this.timer = timer;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setFraction(double fraction) {
            this.fraction = fraction;
        }
    }
}

