/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.hooks.CEHook;
import me.athlaeos.valhallammo.hooks.IAHook;
import me.athlaeos.valhallammo.hooks.NexoHook;
import me.athlaeos.valhallammo.item.CustomDurabilityManager;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MaterialClass;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemUtils {
    private static final Map<UUID, ItemBuilder> storedProjectileCache = new HashMap<UUID, ItemBuilder>();
    private static final Map<UUID, Long> storedProjectileCachedAt = new HashMap<UUID, Long>();
    private static final Collection<Tag<Material>> materialTags = new HashSet<Tag>(Arrays.asList(Tag.PLANKS, Tag.LOGS, Tag.ITEMS_STONE_TOOL_MATERIALS, Tag.ANVIL, Tag.CAULDRONS, Tag.WOOL, Tag.BEDS, Tag.SAPLINGS, Tag.ITEMS_BANNERS, Tag.CANDLES, Tag.COAL_ORES, Tag.GOLD_ORES, Tag.IRON_ORES, Tag.LAPIS_ORES, Tag.COPPER_ORES, Tag.DIAMOND_ORES, Tag.EMERALD_ORES, Tag.REDSTONE_ORES, Tag.DOORS, Tag.FENCES, Tag.FENCE_GATES, Tag.SMALL_FLOWERS, Tag.ITEMS_BOATS, Tag.ITEMS_FISHES, Tag.LEAVES, Tag.PRESSURE_PLATES, Tag.SAND, Tag.SIGNS, Tag.TRAPDOORS, Tag.WALLS));
    private static final Map<Material, Tag<Material>> similarItemsMap = new HashMap<Material, Tag<Material>>();
    private static final Map<Material, String> itemCategoryTranslation = new HashMap<Material, String>();
    private static final Map<MaterialClass, String> materialClassTranslation = new HashMap<MaterialClass, String>();
    private static final Map<EquipmentClass, String> equipmentClassTranslation = new HashMap<EquipmentClass, String>();
    private static final Collection<Material> nonAirMaterials = new HashSet<Material>();
    private static final Material[] nonAirMaterialsArray;
    private static final Collection<Material> offhandUsableItems;
    private static final Map<Material, Collection<Tag<Material>>> similarMaterialCache;
    private static final NamespacedKey TYPE_KEY;
    private static final Collection<ClickType> legalClickTypes;
    private static final Collection<ClickType> illegalClickTypes;
    private static final Collection<Material> consumables;
    private static final Collection<Material> instantlyBreakingItems;

    public static Collection<Material> getOffhandUsableItems() {
        return offhandUsableItems;
    }

    public static boolean usedMainHand(ItemBuilder mainHand, ItemBuilder offHand) {
        if (offHand == null && mainHand != null) {
            return true;
        }
        if (mainHand != null && offhandUsableItems.contains(mainHand.getItem().getType())) {
            return true;
        }
        return offHand == null || !offhandUsableItems.contains(offHand.getItem().getType());
    }

    public static void startProjectileRunnableCache() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskTimer((Plugin)ValhallaMMO.getInstance(), () -> {
            for (UUID uuid : new HashMap<UUID, ItemBuilder>(storedProjectileCache).keySet()) {
                if (storedProjectileCachedAt.get(uuid) + 10000L <= System.currentTimeMillis()) continue;
                storedProjectileCachedAt.remove(uuid);
                storedProjectileCache.remove(uuid);
            }
        }, 200L, 200L);
    }

    private static void registerSimilarItem(Material base, Tag<Material> subTypes, String translation) {
        similarItemsMap.put(base, subTypes);
        itemCategoryTranslation.put(base, translation);
    }

    public static String getGenericTranslation(Material base) {
        return itemCategoryTranslation.containsKey(base = ItemUtils.getBaseMaterial(base)) ? TranslationManager.getTranslation(itemCategoryTranslation.get(base)) : TranslationManager.getMaterialTranslation(base);
    }

    public static String getGenericTranslation(MaterialClass base) {
        return materialClassTranslation.containsKey((Object)base) ? TranslationManager.getTranslation(materialClassTranslation.get((Object)base)) : StringUtils.toPascalCase(base.toString().replace("_", " "));
    }

    public static String getGenericTranslation(EquipmentClass base) {
        return equipmentClassTranslation.containsKey((Object)base) ? TranslationManager.getTranslation(equipmentClassTranslation.get((Object)base)) : StringUtils.toPascalCase(base.toString().replace("_", " "));
    }

    public static Tag<Material> of(final String key, Material ... materials) {
        final Set<Material> tagged = Set.of(materials);
        return new Tag<Material>(){
            private final NamespacedKey k;
            {
                this.k = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "tag_" + key);
            }

            public boolean isTagged(@NotNull Material material) {
                return tagged.contains(material);
            }

            @NotNull
            public Set<Material> getValues() {
                return tagged;
            }

            @NotNull
            public NamespacedKey getKey() {
                return this.k;
            }
        };
    }

    public static Collection<Material> getNonAirMaterials() {
        return nonAirMaterials;
    }

    public static Material[] getNonAirMaterialsArray() {
        return nonAirMaterialsArray;
    }

    public static Map<Material, Tag<Material>> getSimilarItemsMap() {
        return similarItemsMap;
    }

    public static Collection<Material> getMaterialSet(Collection<String> materials) {
        HashSet<Material> m = new HashSet<Material>();
        if (materials == null) {
            return m;
        }
        for (String s : materials) {
            try {
                m.add(Material.valueOf((String)s));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return m;
    }

    public static void addItem(Player player, ItemStack i, boolean setOwnership) {
        HashMap excess = player.getInventory().addItem(new ItemStack[]{i});
        if (!excess.isEmpty()) {
            for (Integer slot : excess.keySet()) {
                ItemStack slotItem = (ItemStack)excess.get(slot);
                Item drop = player.getWorld().dropItem(player.getLocation(), slotItem);
                if (!setOwnership) continue;
                drop.setOwner(player.getUniqueId());
            }
        }
    }

    public static Collection<Material> getMaterialSet(String ... materials) {
        return ItemUtils.getMaterialSet(Arrays.asList(materials));
    }

    public static Collection<Material> getSimilarMaterials(Material m) {
        HashSet<Material> similarMaterials = new HashSet<Material>(Set.of(m));
        for (Tag<Material> tag : materialTags) {
            if (!tag.isTagged((Keyed)m)) continue;
            similarMaterials.addAll(tag.getValues());
        }
        return similarMaterials;
    }

    public static Material getBaseMaterial(Material m) {
        for (Material baseVersion : similarItemsMap.keySet()) {
            if (!similarItemsMap.get(baseVersion).isTagged((Keyed)m)) continue;
            return baseVersion;
        }
        return m;
    }

    public static boolean isSimilarMaterial(Material m, Material compareTo) {
        if (m == compareTo) {
            return true;
        }
        if (similarMaterialCache.containsKey(m) && similarMaterialCache.get(m).stream().anyMatch(t -> t.getValues().contains(m) && t.getValues().contains(compareTo))) {
            return true;
        }
        Collection existingTags = similarMaterialCache.getOrDefault(m, new HashSet());
        for (Tag<Material> tag : materialTags) {
            if (!tag.isTagged((Keyed)m) || !tag.isTagged((Keyed)compareTo)) continue;
            existingTags.add(tag);
            similarMaterialCache.put(m, existingTags);
            return true;
        }
        return false;
    }

    public static List<ItemStack> decompressStacks(Map<ItemStack, Integer> contents) {
        ArrayList<ItemStack> listedItems = new ArrayList<ItemStack>();
        for (ItemStack i : contents.keySet()) {
            ItemStack copy;
            int amount = contents.get(i);
            int limiter = 54;
            do {
                copy = i.clone();
                copy.setAmount(Math.min(amount, i.getMaxStackSize()));
                listedItems.add(copy);
            } while ((amount -= copy.getAmount()) > 0 && --limiter > 0);
        }
        return listedItems;
    }

    public static Map<ItemStack, Integer> compressStacks(List<ItemStack> items) {
        HashMap<ItemStack, Integer> contents = new HashMap<ItemStack, Integer>();
        for (ItemStack i : items) {
            if (ItemUtils.isEmpty(i)) continue;
            ItemStack clone = i.clone();
            int itemAmount = clone.getAmount();
            clone.setAmount(1);
            if (contents.containsKey(clone)) {
                contents.put(clone, (Integer)contents.get(clone) + itemAmount);
                continue;
            }
            contents.put(clone, itemAmount);
        }
        return contents;
    }

    public static void replaceOrAddLore(ItemBuilder item, String find, String replacement) {
        if (item == null) {
            return;
        }
        find = ChatColor.stripColor((String)Utils.chat(find));
        ArrayList<String> lore = item.getLore() == null ? new ArrayList() : item.getLore();
        ItemUtils.replaceOrAddLore(lore, find, replacement);
        item.lore(lore);
    }

    public static void replaceOrAddLore(List<String> original, String find, String replacement) {
        find = ChatColor.stripColor((String)Utils.chat(find));
        if (original == null) {
            return;
        }
        int index = -1;
        for (String l : original) {
            if (!l.contains(find)) continue;
            index = original.indexOf(l);
            break;
        }
        if (index != -1) {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)replacement)) {
                original.remove(index);
            } else {
                original.set(index, Utils.chat(replacement));
            }
        } else if (!org.apache.commons.lang.StringUtils.isEmpty((String)replacement)) {
            original.add(Utils.chat(replacement));
        }
    }

    public static boolean isEmpty(ItemStack i) {
        return i == null || i.getType().isAir() || i.getAmount() <= 0;
    }

    public static ItemMeta getItemMeta(ItemStack i) {
        if (ItemUtils.isEmpty(i)) {
            return null;
        }
        ItemMeta meta = i.getItemMeta();
        if (meta == null) {
            return null;
        }
        ItemUtils.storeType(meta, i.getType());
        return meta;
    }

    public static void storeType(ItemMeta meta, Material material) {
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(TYPE_KEY, PersistentDataType.STRING, (Object)material.toString());
    }

    public static void removeStoredType(ItemMeta meta) {
        meta.getPersistentDataContainer().remove(TYPE_KEY);
    }

    public static void setMetaNoClone(ItemStack i, ItemMeta meta) {
        meta.getPersistentDataContainer().remove(TYPE_KEY);
        i.setItemMeta(meta);
    }

    public static void setItemMeta(ItemStack i, ItemMeta meta) {
        meta = meta.clone();
        meta.getPersistentDataContainer().remove(TYPE_KEY);
        i.setItemMeta(meta);
    }

    public static Material getStoredType(ItemMeta meta) {
        return ItemUtils.stringToMaterial((String)meta.getPersistentDataContainer().get(TYPE_KEY, PersistentDataType.STRING), null);
    }

    public static void updateStoredType(ItemMeta meta, Material newType) {
        if (meta.getPersistentDataContainer().has(TYPE_KEY, PersistentDataType.STRING)) {
            meta.getPersistentDataContainer().set(TYPE_KEY, PersistentDataType.STRING, (Object)newType.toString());
        }
    }

    public static ItemStack getIconFromConfig(YamlConfiguration config, String path, String file, ItemStack def) {
        Object rawIcon = config.get(path);
        if (rawIcon instanceof ItemStack) {
            return (ItemStack)rawIcon;
        }
        String value = config.getString(path, "");
        try {
            def.setType(Material.valueOf((String)value));
            return def;
        }
        catch (IllegalArgumentException ignored) {
            ValhallaMMO.logWarning("ItemStack/Material " + value + " in config " + file + ":" + path + " did not lead to an item stack or proper material type. Defaulted to " + ItemUtils.getItemName(new ItemBuilder(def)));
            return def;
        }
    }

    public static String getItemName(ItemBuilder item) {
        if (item == null) {
            return "null";
        }
        Material base = item.getItem().getType();
        String name = item.getName() != null ? item.getName() : (TranslationManager.getMaterialTranslations().getMaterialTranslations().containsKey(base.toString()) ? Utils.chat(TranslationManager.getMaterialTranslation(base)) : Utils.chat(StringUtils.toPascalCase("&r" + base.toString().replace("_", " "))));
        return name;
    }

    public static boolean isSimilar(ItemStack i1, ItemStack i2) {
        if (i1.isSimilar(i2)) {
            return true;
        }
        ItemMeta i1Meta = ItemUtils.reSetItemText(ItemUtils.getItemMeta(i1));
        ItemMeta i2Meta = ItemUtils.reSetItemText(ItemUtils.getItemMeta(i2));
        if (i1Meta == null && i2Meta == null) {
            return true;
        }
        if (i1Meta == null || i2Meta == null) {
            return false;
        }
        ItemStack i1Clone = i1.clone();
        i1Clone.setAmount(1);
        ItemStack i2Clone = i2.clone();
        i2Clone.setAmount(1);
        i1Clone.setItemMeta(i1Meta);
        i2Clone.setItemMeta(i2Meta);
        String i1String = i1Clone.toString();
        String i2String = i2Clone.toString();
        if (i1String.contains(" unhandled=") || i2String.contains(" unhandled=")) {
            String match2;
            String match = org.apache.commons.lang.StringUtils.substringBetween((String)i1String, (String)" unhandled=", (String)",");
            if (match != null) {
                i1String = i1String.replace(" unhandled=" + match + ",", "");
            }
            if ((match2 = org.apache.commons.lang.StringUtils.substringBetween((String)i2String, (String)" unhandled=", (String)",")) != null) {
                i2String = i2String.replace(" unhandled=" + match2 + ",", "");
            }
        }
        return i1String.equals(i2String);
    }

    public static ItemMeta reSetItemText(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        if (meta.hasLore() && meta.getLore() != null) {
            ArrayList<String> newLore = new ArrayList<String>();
            for (String s : meta.getLore()) {
                newLore.add(Utils.chat(s));
            }
            meta.setLore(newLore);
        }
        if (meta.hasDisplayName()) {
            meta.setDisplayName(meta.getDisplayName());
        }
        return meta;
    }

    public static List<String> setListPlaceholder(List<String> original, String placeholder, List<String> replaceWith) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : original) {
            if (s.contains(placeholder)) {
                lore.addAll(replaceWith);
                continue;
            }
            lore.add(s);
        }
        return lore;
    }

    public static List<String> setListPlaceholder(List<String> original, String placeholder, String replaceWith) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : original) {
            lore.add(s.replace(placeholder, replaceWith));
        }
        return lore;
    }

    public static List<String> getLore(ItemStack i) {
        ItemMeta meta = ItemUtils.getItemMeta(i);
        if (meta != null && meta.hasLore() && meta.getLore() != null) {
            return meta.getLore();
        }
        return new ArrayList<String>();
    }

    public static List<String> getLore(ItemMeta meta) {
        if (meta != null && meta.hasLore() && meta.getLore() != null) {
            return meta.getLore();
        }
        return new ArrayList<String>();
    }

    public static int getPDCInt(NamespacedKey key, ItemStack i, int def) {
        ItemMeta meta = ItemUtils.getItemMeta(i);
        if (ItemUtils.isEmpty(i) || meta == null) {
            return def;
        }
        return (Integer)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)def);
    }

    public static String getPDCString(NamespacedKey key, ItemStack i, String def) {
        if (ItemUtils.isEmpty(i)) {
            return def;
        }
        ItemMeta meta = ItemUtils.getItemMeta(i);
        if (meta == null) {
            return def;
        }
        String value = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        return value == null ? def : value;
    }

    public static double getPDCDouble(NamespacedKey key, ItemStack i, double def) {
        ItemMeta meta = ItemUtils.getItemMeta(i);
        if (ItemUtils.isEmpty(i) || meta == null) {
            return def;
        }
        return (Double)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)def);
    }

    public static int getPDCInt(NamespacedKey key, ItemMeta i, int def) {
        return (Integer)i.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)def);
    }

    public static double getPDCDouble(NamespacedKey key, ItemMeta i, double def) {
        return (Double)i.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)def);
    }

    public static String getPDCString(NamespacedKey key, ItemMeta i, String def) {
        String value = (String)i.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        return value == null ? def : value;
    }

    public static Map<SlotEntry, Integer> getItemTotals(Collection<SlotEntry> items) {
        HashMap<SlotEntry, Integer> totals = new HashMap<SlotEntry, Integer>();
        HashMap<ItemStack, SlotEntry> mapping = new HashMap<ItemStack, SlotEntry>();
        for (SlotEntry i : items) {
            if (ItemUtils.isEmpty(i.getItem())) continue;
            ItemStack clone = i.getItem().clone();
            clone.setAmount(1);
            SlotEntry mappedTo = (SlotEntry)mapping.get(clone);
            if (mappedTo == null) {
                mapping.put(clone, i);
                mappedTo = i;
            }
            int existingAmount = totals.getOrDefault(mappedTo, 0);
            totals.put(mappedTo, existingAmount + i.getItem().getAmount());
        }
        return totals;
    }

    public static Material stringToMaterial(String material, Material def) {
        if (material == null || material.isEmpty()) {
            return def;
        }
        Material found = Material.getMaterial((String)material);
        return found == null ? def : found;
    }

    public static EquipmentSlot getEquipmentSlot(ItemMeta meta) {
        EquipmentSlot equipmentSlot;
        EquipmentClass clazz = EquipmentClass.getMatchingClass(meta);
        if (clazz == null) {
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            switch (clazz) {
                case BOOTS: {
                    equipmentSlot = EquipmentSlot.FEET;
                    break;
                }
                case LEGGINGS: {
                    equipmentSlot = EquipmentSlot.LEGS;
                    break;
                }
                case CHESTPLATE: 
                case ELYTRA: 
                case TRINKET: {
                    equipmentSlot = EquipmentSlot.CHEST;
                    break;
                }
                case HELMET: {
                    equipmentSlot = EquipmentSlot.HEAD;
                    break;
                }
                default: {
                    equipmentSlot = EquipmentSlot.HAND;
                }
            }
        }
        return equipmentSlot;
    }

    public static void removeIfLoreContains(ItemBuilder i, String find) {
        if (i == null || i.getLore() == null) {
            return;
        }
        String stripped = ChatColor.stripColor((String)Utils.chat(find));
        List<String> lore = i.getLore();
        lore.removeIf(l -> l.contains(stripped));
        i.lore(lore);
    }

    public static boolean damageItem(Player who, ItemStack item, int damage, EntityEffect breakEffect) {
        return ItemUtils.damageItem(who, item, damage, breakEffect, false);
    }

    public static boolean damageItem(Player who, ItemStack item, int damage, EntityEffect breakEffect, boolean respectAttributes) {
        ItemBuilder wrapper = new ItemBuilder(item);
        if (wrapper.getMeta() instanceof Damageable && item.getType().getMaxDurability() > 0) {
            if (respectAttributes) {
                double damageChance;
                if (wrapper.getMeta().isUnbreakable()) {
                    return false;
                }
                int unbreakableLevel = item.getEnchantmentLevel(EnchantmentMappings.UNBREAKING.getEnchantment());
                if (unbreakableLevel > 0 && (damage = Utils.randomAverage((double)damage * (damageChance = 1.0 / ((double)unbreakableLevel + 1.0)))) == 0) {
                    return false;
                }
            }
            PlayerItemDamageEvent event = new PlayerItemDamageEvent(who, item, damage);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (!CustomDurabilityManager.hasCustomDurability(wrapper.getMeta())) {
                    Damageable damageable = (Damageable)wrapper.getMeta();
                    damageable.setDamage(damageable.getDamage() + event.getDamage());
                    if (damageable.getDamage() > item.getType().getMaxDurability()) {
                        who.playEffect(breakEffect);
                        return true;
                    }
                    ItemUtils.setMetaNoClone(item, (ItemMeta)damageable);
                } else if (CustomDurabilityManager.getDurability(wrapper, false) <= 0) {
                    who.playEffect(breakEffect);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean allMatchInTypeAndData(List<ItemStack> items) {
        if ((items = items.stream().filter(i -> !ItemUtils.isEmpty(i)).toList()).size() <= 1) {
            return true;
        }
        BiPredicate<ItemStack, ItemStack> predicate = (itemStack, itemStack2) -> {
            ItemMeta m1 = ItemUtils.getItemMeta(itemStack);
            ItemMeta m2 = ItemUtils.getItemMeta(itemStack2);
            if (m1 == null || m2 == null) {
                return false;
            }
            if (itemStack.getType() != itemStack2.getType()) {
                return false;
            }
            if (m1.hasCustomModelData() != m2.hasCustomModelData()) {
                return false;
            }
            return m1.getCustomModelData() == m2.getCustomModelData();
        };
        for (int i2 = 0; i2 < items.size() - 2; ++i2) {
            if (predicate.test(items.get(i2), items.get(i2 + 1))) continue;
            return false;
        }
        return true;
    }

    public static int maxInventoryFit(Player p, ItemStack item) {
        int times = 0;
        for (ItemStack i : p.getInventory().getStorageContents()) {
            if (times >= 64) break;
            if (ItemUtils.isEmpty(i)) {
                times += (int)Math.floor((double)item.getType().getMaxStackSize() / (double)item.getAmount());
                continue;
            }
            if (item.getType().getMaxStackSize() <= 1 || !i.isSimilar(item) || i.getAmount() + item.getAmount() > item.getType().getMaxStackSize()) continue;
            times += (int)Math.floor((double)(i.getType().getMaxStackSize() - i.getAmount()) / (double)item.getAmount());
        }
        return times;
    }

    public static void calculateClickEvent(InventoryClickEvent e, int maxAmount, Integer ... slotsToCover) {
        Player p = (Player)e.getWhoClicked();
        ItemStack cursor = p.getItemOnCursor();
        ItemStack clickedItem = e.getCurrentItem();
        if (e.getClickedInventory() == null) {
            return;
        }
        Inventory openInventory = e.getView().getTopInventory();
        e.setCancelled(true);
        if (e.getClickedInventory() instanceof PlayerInventory) {
            if (e.isShiftClick() && !ItemUtils.isEmpty(clickedItem)) {
                for (Integer i : slotsToCover) {
                    ItemStack slotItem = openInventory.getItem(i.intValue());
                    if (ItemUtils.isEmpty(slotItem)) {
                        if (clickedItem.getAmount() <= maxAmount) {
                            openInventory.setItem(i.intValue(), clickedItem);
                            e.setCurrentItem(null);
                        } else {
                            ItemStack itemToPut = clickedItem.clone();
                            itemToPut.setAmount(maxAmount);
                            if (clickedItem.getAmount() - maxAmount <= 0) {
                                e.setCurrentItem(null);
                            } else {
                                clickedItem.setAmount(clickedItem.getAmount() - maxAmount);
                            }
                            openInventory.setItem(i.intValue(), itemToPut);
                        }
                        return;
                    }
                    if (!slotItem.isSimilar(clickedItem) || slotItem.getAmount() >= maxAmount) continue;
                    int amountToTransfer = Math.min(clickedItem.getAmount(), maxAmount - slotItem.getAmount());
                    if (clickedItem.getAmount() == amountToTransfer) {
                        e.setCurrentItem(null);
                    } else if (clickedItem.getAmount() - amountToTransfer <= 0) {
                        e.setCurrentItem(null);
                    } else {
                        clickedItem.setAmount(clickedItem.getAmount() - amountToTransfer);
                    }
                    slotItem.setAmount(slotItem.getAmount() + amountToTransfer);
                    return;
                }
            } else {
                e.setCancelled(false);
            }
        } else if (e.getClickedInventory().equals((Object)e.getView().getTopInventory())) {
            if (legalClickTypes.contains(e.getClick())) {
                e.setCancelled(false);
                return;
            }
            if (illegalClickTypes.contains(e.getClick())) {
                return;
            }
            if (e.isLeftClick() || e.isRightClick()) {
                if (ItemUtils.isEmpty(cursor)) {
                    e.setCancelled(false);
                } else if (ItemUtils.isEmpty(clickedItem)) {
                    int amountToTransfer;
                    int n = amountToTransfer = e.isRightClick() ? 1 : maxAmount;
                    if (cursor.getAmount() > amountToTransfer) {
                        ItemStack itemToTransfer = cursor.clone();
                        itemToTransfer.setAmount(amountToTransfer);
                        e.setCurrentItem(itemToTransfer);
                        cursor.setAmount(cursor.getAmount() - amountToTransfer);
                        p.setItemOnCursor(cursor);
                    } else {
                        e.setCurrentItem(cursor);
                        p.setItemOnCursor(null);
                    }
                } else if (cursor.isSimilar(clickedItem)) {
                    int clickedMax = Math.min(clickedItem.getType().getMaxStackSize(), maxAmount);
                    if (clickedItem.getAmount() < clickedMax) {
                        int amountToTransfer;
                        int n = amountToTransfer = e.isRightClick() ? 1 : Math.min(cursor.getAmount(), clickedMax - clickedItem.getAmount());
                        if (cursor.getAmount() == amountToTransfer) {
                            p.setItemOnCursor(null);
                        } else {
                            cursor.setAmount(cursor.getAmount() - amountToTransfer);
                            p.setItemOnCursor(cursor);
                        }
                        clickedItem.setAmount(clickedItem.getAmount() + amountToTransfer);
                    }
                } else if (cursor.getAmount() <= maxAmount) {
                    ItemStack temp = cursor.clone();
                    p.setItemOnCursor(clickedItem);
                    e.setCurrentItem(temp);
                }
            }
        }
    }

    public static String serialize(ItemStack itemStack) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemStack);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ItemStack deserialize(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack i = (ItemStack)dataInput.readObject();
            dataInput.close();
            return i;
        }
        catch (IOException | ClassNotFoundException exception) {
            return null;
        }
    }

    public static void calculateDragEvent(InventoryDragEvent e, int maxAmount, Integer ... affectedSlots) {
        ItemStack cursor = e.getCursor();
        int newAmount = ItemUtils.isEmpty(cursor) ? 0 : cursor.getAmount();
        Set<Integer> slots = Set.of(affectedSlots);
        e.setCancelled(true);
        for (Integer slot : e.getNewItems().keySet()) {
            ItemStack newItem = (ItemStack)e.getNewItems().get(slot);
            if (!slots.contains(slot) || newItem.getAmount() <= maxAmount) continue;
            int excess = newItem.getAmount() - maxAmount;
            newAmount += excess;
            ((ItemStack)e.getNewItems().get(slot)).setAmount(maxAmount);
        }
        for (Integer slot : e.getNewItems().keySet()) {
            e.getView().setItem(slot.intValue(), (ItemStack)e.getNewItems().get(slot));
        }
        ItemStack oldCursor = e.getOldCursor().clone();
        oldCursor.setAmount(newAmount);
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            if (oldCursor.getAmount() > 0) {
                e.getWhoClicked().setItemOnCursor(oldCursor);
            } else {
                e.getWhoClicked().setItemOnCursor(null);
            }
        }, 1L);
    }

    public static int timesContained(List<ItemStack> inventory, Map<ItemStack, Integer> ingredients, IngredientChoice matcher) {
        if (ingredients.isEmpty()) {
            return Short.MAX_VALUE;
        }
        HashMap<ItemStack, Integer> countMapped = new HashMap<ItemStack, Integer>();
        for (ItemStack ingredient : ingredients.keySet()) {
            ingredient = ingredient.clone();
            ingredient.setAmount(1);
            boolean anyMatch = false;
            for (ItemStack i : inventory) {
                if (ItemUtils.isEmpty(i) || !matcher.matches(ingredient, i)) continue;
                int amount = countMapped.getOrDefault(ingredient, 0);
                countMapped.put(ingredient, amount + i.getAmount());
                anyMatch = true;
            }
            if (anyMatch) continue;
            return 0;
        }
        int minimumAmount = 100000;
        for (ItemStack ingredient : ingredients.keySet()) {
            int required = ingredients.get(ingredient);
            ingredient = ingredient.clone();
            ingredient.setAmount(1);
            if (!countMapped.containsKey(ingredient)) {
                return 0;
            }
            int timesContained = (int)Math.floor((double)((Integer)countMapped.get(ingredient)).intValue() / (double)required);
            minimumAmount = Math.min(timesContained, minimumAmount);
        }
        return minimumAmount;
    }

    public static List<ItemStack> removeItems(List<ItemStack> contents, Map<ItemStack, Integer> ingredients, int count, IngredientChoice matcher) {
        if (ingredients.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> removedItems = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients.keySet()) {
            ingredient = ingredient.clone();
            int amountRequired = ingredients.get(ingredient) * count;
            for (ItemStack i : new ArrayList<ItemStack>(contents)) {
                if (!matcher.matches(ingredient, i)) continue;
                int amount = i.getAmount();
                if (amount > amountRequired) {
                    ItemStack removed = i.clone();
                    removed.setAmount(amount - amountRequired);
                    removedItems.add(removed);
                    i.setAmount(amount - amountRequired);
                } else {
                    removedItems.add(i.clone());
                    contents.remove(i);
                }
                amountRequired -= Math.min(amount, amountRequired);
            }
            if (amountRequired <= 0) continue;
            return null;
        }
        return removedItems;
    }

    public static List<ItemStack> removeItems(Inventory inventory, Map<ItemStack, Integer> ingredients, int count, IngredientChoice matcher) {
        if (ingredients.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> removedItems = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients.keySet()) {
            ingredient = ingredient.clone();
            int amountRequired = ingredients.get(ingredient) * count;
            for (int i = 0; i < inventory.getStorageContents().length; ++i) {
                ItemStack item = inventory.getItem(i);
                if (ItemUtils.isEmpty(item) || !matcher.matches(ingredient, item)) continue;
                int amount = item.getAmount();
                if (amount > amountRequired) {
                    ItemStack removed = item.clone();
                    removed.setAmount(amount - amountRequired);
                    removedItems.add(removed);
                    item.setAmount(amount - amountRequired);
                } else {
                    removedItems.add(item.clone());
                    inventory.setItem(i, null);
                }
                amountRequired -= Math.min(amount, amountRequired);
            }
            if (amountRequired <= 0) continue;
            return null;
        }
        return removedItems;
    }

    public static boolean isConsumable(Material m) {
        return m.isEdible() || consumables.contains(m);
    }

    public static ItemBuilder getStoredItem(Entity entity) {
        List metaData;
        if (storedProjectileCache.containsKey(entity.getUniqueId())) {
            return storedProjectileCache.get(entity.getUniqueId());
        }
        if (entity.hasMetadata("entity_stored_item_data") && !(metaData = entity.getMetadata("entity_stored_item_data")).isEmpty()) {
            try {
                ItemStack item = ItemUtils.deserialize(((MetadataValue)metaData.get(0)).asString());
                if (ItemUtils.isEmpty(item)) {
                    return null;
                }
                ItemBuilder builder = new ItemBuilder(item);
                storedProjectileCache.put(entity.getUniqueId(), builder);
                storedProjectileCachedAt.put(entity.getUniqueId(), System.currentTimeMillis());
                return builder;
            }
            catch (Exception ignored) {
                ValhallaMMO.logSevere("Another plugin is using metadata key 'entity_stored_item_data' and not using the proper data type");
            }
        }
        return null;
    }

    public static void storeItem(Entity entity, ItemStack item) {
        entity.setMetadata("entity_stored_item_data", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)ItemUtils.serialize(item)));
    }

    public static List<ItemStack> multiplyDrops(List<Item> items, double multiplier, boolean forgiving, Predicate<Item> filter) {
        Iterator<Item> iterator = items.iterator();
        ArrayList<ItemStack> extraItems = new ArrayList<ItemStack>();
        while (iterator.hasNext()) {
            ItemStack item;
            Item i = iterator.next();
            if (filter != null && !filter.test(i)) continue;
            int newAmount = Math.max(forgiving ? 1 : 0, Utils.randomAverage(multiplier * (double)(item = i.getItemStack()).getAmount()));
            if (newAmount == 0) {
                items.remove(i);
                continue;
            }
            if (newAmount > item.getMaxStackSize()) {
                while (newAmount > item.getMaxStackSize()) {
                    ItemStack newDrop = item.clone();
                    newDrop.setAmount(item.getMaxStackSize());
                    newAmount -= item.getMaxStackSize();
                    extraItems.add(newDrop);
                }
            }
            item.setAmount(newAmount);
            i.setItemStack(item);
        }
        return extraItems;
    }

    public static void multiplyItems(List<ItemStack> items, double multiplier, boolean forgiving, Predicate<ItemStack> filter) {
        for (ItemStack item : new ArrayList<ItemStack>(items)) {
            if (filter != null && !filter.test(item)) continue;
            int newAmount = Math.max(forgiving ? 1 : 0, Utils.randomAverage(multiplier * (double)item.getAmount()));
            if (newAmount == 0) {
                items.remove(item);
                continue;
            }
            if (newAmount > item.getMaxStackSize()) {
                while (newAmount > item.getMaxStackSize()) {
                    ItemStack newDrop = item.clone();
                    newDrop.setAmount(item.getMaxStackSize());
                    newAmount -= item.getMaxStackSize();
                    items.add(newDrop);
                }
            }
            item.setAmount(newAmount);
        }
    }

    public static ItemStack parseCustomModelItem(String data, Material def) {
        String[] parts = data.split(":");
        Material m = ItemUtils.stringToMaterial(parts[0], def);
        int modelData = -1;
        if (parts.length > 1) {
            try {
                modelData = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignored) {
                ValhallaMMO.logWarning("Invalid integer value for custom model data in gui_details.yml: " + parts[1]);
            }
        }
        return new ItemBuilder(m).data(modelData).get();
    }

    public static Map<UUID, ItemBuilder> getStoredProjectileCache() {
        return storedProjectileCache;
    }

    public static boolean breaksInstantly(Material m) {
        return instantlyBreakingItems.contains(m);
    }

    public static String getItemType(ItemStack item) {
        String custom;
        if (ValhallaMMO.isHookFunctional(NexoHook.class) && (custom = NexoHook.getNexoItemID(item)) != null) {
            return custom;
        }
        if (ValhallaMMO.isHookFunctional(CEHook.class) && (custom = CEHook.getCraftEngineItemID(item)) != null) {
            return custom;
        }
        if (ValhallaMMO.isHookFunctional(IAHook.class) && (custom = IAHook.getItemsAdderItemID(item)) != null) {
            return custom;
        }
        return item.getType().toString();
    }

    public static ItemBuilder getItem(String type) {
        ItemStack item;
        if (ValhallaMMO.isHookFunctional(NexoHook.class) && !ItemUtils.isEmpty(item = NexoHook.getNexoItem(type))) {
            return new ItemBuilder(item);
        }
        if (ValhallaMMO.isHookFunctional(CEHook.class) && !ItemUtils.isEmpty(item = CEHook.getCraftEngineItem(type))) {
            return new ItemBuilder(item);
        }
        if (ValhallaMMO.isHookFunctional(IAHook.class) && !ItemUtils.isEmpty(item = IAHook.getItemsAdderItem(type))) {
            return new ItemBuilder(item);
        }
        Material vanilla = Catch.catchOrElse(() -> Material.valueOf((String)type), null);
        if (vanilla == null) {
            return null;
        }
        return new ItemBuilder(vanilla);
    }

    static {
        offhandUsableItems = new HashSet<Material>(ItemUtils.getMaterialSet("BOW", "CROSSBOW", "SNOWBALL", "EGG", "ENDER_PEARL", "ENDER_EYE", "EXPERIENCE_BOTTLE", "FISHING_ROD", "FLINT_AND_STEEL", "FIREWORK_ROCKET", "SPLASH_POTION", "LINGERING_POTION", "TRIDENT"));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_19)) {
            materialTags.add((Tag<Material>)Tag.WOOL_CARPETS);
        }
        Tag<Material> buckets = ItemUtils.of("buckets", Material.BUCKET, Material.MILK_BUCKET, Material.POWDER_SNOW_BUCKET, Material.LAVA_BUCKET, Material.WATER_BUCKET, Material.AXOLOTL_BUCKET, Material.COD_BUCKET, Material.PUFFERFISH_BUCKET, Material.SALMON_BUCKET, Material.TROPICAL_FISH_BUCKET);
        materialTags.add(buckets);
        Tag<Material> potions = ItemUtils.of("potions", Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION);
        materialTags.add(potions);
        Tag<Material> stoneBricks = ItemUtils.of("stone_bricks", Material.STONE, Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.MOSSY_STONE_BRICKS);
        materialTags.add(stoneBricks);
        Tag<Material> deepslateBricks = ItemUtils.of("deepslate_bricks", Material.DEEPSLATE, Material.COBBLED_DEEPSLATE, Material.POLISHED_DEEPSLATE, Material.DEEPSLATE_BRICKS, Material.CRACKED_DEEPSLATE_BRICKS, Material.DEEPSLATE_TILES, Material.CRACKED_DEEPSLATE_TILES, Material.CHISELED_DEEPSLATE);
        materialTags.add(deepslateBricks);
        Tag<Material> quartzBricks = ItemUtils.of("quartz_bricks", Material.QUARTZ_BRICKS, Material.CHISELED_QUARTZ_BLOCK, Material.QUARTZ_BLOCK, Material.SMOOTH_QUARTZ, Material.QUARTZ_PILLAR);
        materialTags.add(quartzBricks);
        Tag<Material> blackstoneBricks = ItemUtils.of("blackstone_bricks", Material.BLACKSTONE, Material.POLISHED_BLACKSTONE, Material.POLISHED_BLACKSTONE_BRICKS, Material.CHISELED_POLISHED_BLACKSTONE, Material.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        materialTags.add(blackstoneBricks);
        Tag<Material> endstoneBricks = ItemUtils.of("end_bricks", Material.END_STONE, Material.END_STONE_BRICKS);
        materialTags.add(endstoneBricks);
        ItemUtils.registerSimilarItem(Material.OAK_PLANKS, (Tag<Material>)Tag.PLANKS, "ingredient_any_plank");
        ItemUtils.registerSimilarItem(Material.OAK_LOG, (Tag<Material>)Tag.LOGS, "ingredient_any_log");
        ItemUtils.registerSimilarItem(Material.ANVIL, (Tag<Material>)Tag.ANVIL, "ingredient_any_anvil");
        ItemUtils.registerSimilarItem(Material.CAULDRON, (Tag<Material>)Tag.CAULDRONS, "ingredient_any_cauldron");
        ItemUtils.registerSimilarItem(Material.WHITE_WOOL, (Tag<Material>)Tag.WOOL, "ingredient_any_wool");
        ItemUtils.registerSimilarItem(Material.WHITE_BED, (Tag<Material>)Tag.BEDS, "ingredient_any_bed");
        ItemUtils.registerSimilarItem(Material.WHITE_BANNER, (Tag<Material>)Tag.BANNERS, "ingredient_any_banner");
        ItemUtils.registerSimilarItem(Material.WHITE_CANDLE, (Tag<Material>)Tag.CANDLES, "ingredient_any_candle");
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_19)) {
            ItemUtils.registerSimilarItem(Material.WHITE_CARPET, (Tag<Material>)Tag.WOOL_CARPETS, "ingredient_any_carpet");
        }
        ItemUtils.registerSimilarItem(Material.COAL_ORE, (Tag<Material>)Tag.COAL_ORES, "ingredient_any_coal_ore");
        ItemUtils.registerSimilarItem(Material.DIAMOND_ORE, (Tag<Material>)Tag.DIAMOND_ORES, "ingredient_any_diamond_ore");
        ItemUtils.registerSimilarItem(Material.GOLD_ORE, (Tag<Material>)Tag.GOLD_ORES, "ingredient_any_gold_ore");
        ItemUtils.registerSimilarItem(Material.IRON_ORE, (Tag<Material>)Tag.IRON_ORES, "ingredient_any_iron_ore");
        ItemUtils.registerSimilarItem(Material.LAPIS_ORE, (Tag<Material>)Tag.LAPIS_ORES, "ingredient_any_lapis_ore");
        ItemUtils.registerSimilarItem(Material.COPPER_ORE, (Tag<Material>)Tag.COPPER_ORES, "ingredient_any_copper_ore");
        ItemUtils.registerSimilarItem(Material.EMERALD_ORE, (Tag<Material>)Tag.EMERALD_ORES, "ingredient_any_emerald_ore");
        ItemUtils.registerSimilarItem(Material.REDSTONE_ORE, (Tag<Material>)Tag.REDSTONE_ORES, "ingredient_any_redstone_ore");
        ItemUtils.registerSimilarItem(Material.OAK_DOOR, (Tag<Material>)Tag.DOORS, "ingredient_any_door");
        ItemUtils.registerSimilarItem(Material.OAK_FENCE, (Tag<Material>)Tag.FENCES, "ingredient_any_fence");
        ItemUtils.registerSimilarItem(Material.OAK_FENCE_GATE, (Tag<Material>)Tag.FENCE_GATES, "ingredient_any_fence_gate");
        ItemUtils.registerSimilarItem(Material.OAK_BOAT, (Tag<Material>)Tag.ITEMS_BOATS, "ingredient_any_boat");
        ItemUtils.registerSimilarItem(Material.OAK_LEAVES, (Tag<Material>)Tag.LEAVES, "ingredient_any_leaves");
        ItemUtils.registerSimilarItem(Material.OAK_PRESSURE_PLATE, (Tag<Material>)Tag.PRESSURE_PLATES, "ingredient_any_pressure_plate");
        ItemUtils.registerSimilarItem(Material.SAND, (Tag<Material>)Tag.SAND, "ingredient_any_sand");
        ItemUtils.registerSimilarItem(Material.OAK_SIGN, (Tag<Material>)Tag.SIGNS, "ingredient_any_sign");
        ItemUtils.registerSimilarItem(Material.OAK_TRAPDOOR, (Tag<Material>)Tag.TRAPDOORS, "ingredient_any_trap_door");
        ItemUtils.registerSimilarItem(Material.POTION, potions, "ingredient_any_potion");
        ItemUtils.registerSimilarItem(Material.BUCKET, buckets, "ingredient_any_bucket");
        ItemUtils.registerSimilarItem(Material.STONE_BRICKS, stoneBricks, "ingredient_any_stone_bricks");
        ItemUtils.registerSimilarItem(Material.DEEPSLATE_BRICKS, deepslateBricks, "ingredient_any_deepslate_bricks");
        ItemUtils.registerSimilarItem(Material.QUARTZ_BRICKS, quartzBricks, "ingredient_any_quartz_bricks");
        ItemUtils.registerSimilarItem(Material.POLISHED_BLACKSTONE_BRICKS, blackstoneBricks, "ingredient_any_blackstone_bricks");
        ItemUtils.registerSimilarItem(Material.END_STONE_BRICKS, endstoneBricks, "ingredient_any_end_bricks");
        materialClassTranslation.put(MaterialClass.WOOD, "ingredient_any_wood_equipment");
        materialClassTranslation.put(MaterialClass.BOW, "ingredient_any_bow");
        materialClassTranslation.put(MaterialClass.CROSSBOW, "ingredient_any_crossbow");
        materialClassTranslation.put(MaterialClass.LEATHER, "ingredient_any_leather_equipment");
        materialClassTranslation.put(MaterialClass.STONE, "ingredient_any_stone_equipment");
        materialClassTranslation.put(MaterialClass.CHAINMAIL, "ingredient_any_chainmail_equipment");
        materialClassTranslation.put(MaterialClass.GOLD, "ingredient_any_gold_equipment");
        materialClassTranslation.put(MaterialClass.IRON, "ingredient_any_iron_equipment");
        materialClassTranslation.put(MaterialClass.DIAMOND, "ingredient_any_diamond_equipment");
        materialClassTranslation.put(MaterialClass.NETHERITE, "ingredient_any_netherite_equipment");
        materialClassTranslation.put(MaterialClass.PRISMARINE, "ingredient_any_prismarine_equipment");
        materialClassTranslation.put(MaterialClass.ENDERIC, "ingredient_any_enderic_equipment");
        materialClassTranslation.put(MaterialClass.OTHER, "ingredient_any_other_equipment");
        equipmentClassTranslation.put(EquipmentClass.SWORD, "ingredient_any_sword");
        equipmentClassTranslation.put(EquipmentClass.SPEAR, "ingredient_any_spear");
        equipmentClassTranslation.put(EquipmentClass.BOW, "ingredient_any_bow");
        equipmentClassTranslation.put(EquipmentClass.CROSSBOW, "ingredient_any_crossbow");
        equipmentClassTranslation.put(EquipmentClass.TRIDENT, "ingredient_any_trident");
        equipmentClassTranslation.put(EquipmentClass.HELMET, "ingredient_any_helmet");
        equipmentClassTranslation.put(EquipmentClass.CHESTPLATE, "ingredient_any_chestplate");
        equipmentClassTranslation.put(EquipmentClass.LEGGINGS, "ingredient_any_leggings");
        equipmentClassTranslation.put(EquipmentClass.BOOTS, "ingredient_any_boots");
        equipmentClassTranslation.put(EquipmentClass.SHEARS, "ingredient_any_shears");
        equipmentClassTranslation.put(EquipmentClass.FLINT_AND_STEEL, "ingredient_any_flint_and_steel");
        equipmentClassTranslation.put(EquipmentClass.FISHING_ROD, "ingredient_any_fishing_rod");
        equipmentClassTranslation.put(EquipmentClass.ELYTRA, "ingredient_any_elytra");
        equipmentClassTranslation.put(EquipmentClass.PICKAXE, "ingredient_any_pickaxe");
        equipmentClassTranslation.put(EquipmentClass.AXE, "ingredient_any_axe");
        equipmentClassTranslation.put(EquipmentClass.SHOVEL, "ingredient_any_shovel");
        equipmentClassTranslation.put(EquipmentClass.HOE, "ingredient_any_hoe");
        equipmentClassTranslation.put(EquipmentClass.SHIELD, "ingredient_any_shield");
        equipmentClassTranslation.put(EquipmentClass.OTHER, "ingredient_any_other");
        equipmentClassTranslation.put(EquipmentClass.TRINKET, "ingredient_any_trinket");
        Arrays.stream(Material.values()).filter(m -> !m.isAir() && m.isItem()).forEach(nonAirMaterials::add);
        nonAirMaterialsArray = nonAirMaterials.toArray(new Material[0]);
        similarMaterialCache = new HashMap<Material, Collection<Tag<Material>>>();
        TYPE_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "temporary_type_storage");
        legalClickTypes = Set.of(ClickType.DROP, ClickType.CONTROL_DROP, ClickType.MIDDLE, ClickType.WINDOW_BORDER_LEFT, ClickType.WINDOW_BORDER_RIGHT, ClickType.UNKNOWN, ClickType.CREATIVE, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        illegalClickTypes = Set.of(ClickType.SWAP_OFFHAND, ClickType.NUMBER_KEY, ClickType.DOUBLE_CLICK);
        consumables = Set.of(Material.ARROW, Material.SPECTRAL_ARROW, Material.TIPPED_ARROW, Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.SNOWBALL, Material.ENDER_PEARL, Material.ENDER_EYE, Material.EXPERIENCE_BOTTLE, Material.EGG, Material.MILK_BUCKET);
        instantlyBreakingItems = ItemUtils.getMaterialSet("AIR", "GRASS", "TALL_GRASS", "SHORT_GRASS", "END_ROD", "BARRIER", "BRAIN_CORAL", "BRAIN_CORAL_FAN", "BUBBLE_CORAL", "BUBBLE_CORAL_FAN", "FIRE_CORAL", "FIRE_CORAL_FAN", "HORN_CORAL", "HORN_CORAL_FAN", "TUBE_CORAL", "TUBE_CORAL_FAN", "DEAD_BRAIN_CORAL", "DEAD_BRAIN_CORAL_FAN", "DEAD_BUBBLE_CORAL", "DEAD_BUBBLE_CORAL_FAN", "DEAD_FIRE_CORAL", "DEAD_FIRE_CORAL_FAN", "DEAD_HORN_CORAL", "DEAD_HORN_CORAL_FAN", "DEAD_TUBE_CORAL", "DEAD_TUBE_CORAL_FAN", "TORCH", "REDSTONE_TORCH", "WALL_TORCH", "REDSTONE_WALL_TORCH", "FERN", "LARGE_FERN", "BEETROOTS", "WHEAT", "POTATOES", "CARROTS", "OAK_SAPLING", "DARK_OAK_SAPLING", "SPRUCE_SAPLING", "ACACIA_SAPLING", "BIRCH_SAPLING", "JUNGLE_SAPLING", "FLOWER_POT", "POPPY", "DANDELION", "ALLIUM", "BLUE_ORCHID", "AZURE_BLUET", "RED_TULIP", "ORANGE_TULIP", "WHITE_TULIP", "PINK_TULIP", "OXEYE_DAISY", "CORNFLOWER", "LILY_OF_THE_VALLEY", "WITHER_ROSE", "SUNFLOWER", "LILAC", "ROSE_BUSH", "PEONY", "LILY_PAD", "FIRE", "DEAD_BUSH", "MELON_STEM", "PUMPKIN_STEM", "BROWN_MUSHROOM", "RED_MUSHROOM", "NETHER_WART", "REDSTONE_WIRE", "COMPARATOR", "REPEATER", "SLIME_BLOCK", "STRUCTURE_VOID", "SUGAR_CANE", "TNT", "TRIPWIRE", "TRIPWIRE_HOOK", "WARPED_FUNGUS", "CRIMSON_FUNGUS", "HONEY_BLOCK", "NETHER_SPROUTS", "CRIMSON_ROOTS", "WARPED_ROOTS", "TWISTING_VINES_PLANT", "WEEPING_VINES_PLANT", "SMALL_DRIPLEAF", "CAVE_VINES_PLANT", "CAVE_VINES", "SPORE_BLOSSOM", "AZALEA", "FLOWERING_AZALEA", "DECORATED_POT", "FROGSPAWN", "PINK_PETALS", "PITCHER_CROP", "PITCHER_PLANT", "TORCHFLOWER", "TORCHFLOWER_CROP");
    }
}

