/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class Parryer {
    private static final Collection<PotionEffectWrapper> parryEnemyDebuffs;
    private static final Collection<PotionEffectWrapper> parrySelfDebuffs;
    private static final boolean parrySparks;
    private static final boolean parryProjectiles;
    private static final boolean parryProjectilesReflect;
    private static final Sound parryActivationSound;
    private static final Sound parrySuccessSound;
    private static final Sound parryFailedSound;
    private static Animation parrySuccessAnimation;
    private static Animation parryFailAnimation;

    public static boolean isParried(LivingEntity entity) {
        Map<String, CustomPotionEffect> activeEffects = PotionEffectRegistry.getActiveEffects(entity);
        return parryEnemyDebuffs.stream().map(PotionEffectWrapper::getEffect).allMatch(activeEffects::containsKey);
    }

    public static void forceParry(LivingEntity e, int activeFor, int vulnerableFor, int cooldown) {
        Timer.setCooldown(e.getUniqueId(), activeFor * 50, "parry_effective");
        Timer.setCooldown(e.getUniqueId(), vulnerableFor * 50, "parry_vulnerable");
        Timer.setCooldownIgnoreIfPermission((Entity)e, cooldown * 50, "parry_cooldown");
        e.getWorld().playSound(e.getLocation(), parryActivationSound, 1.0f, 1.0f);
    }

    public static void attemptParry(LivingEntity e) {
        if (!Timer.isCooldownPassed(e.getUniqueId(), "parry_cooldown")) {
            if (e instanceof Player) {
                Player p = (Player)e;
                Timer.sendCooldownStatus(p, "parry_cooldown", TranslationManager.getTranslation("ability_parry"));
            }
            return;
        }
        int cooldown = (int)AccumulativeStatManager.getCachedStats("PARRY_COOLDOWN", (Entity)e, 10000L, true) - 1;
        if (cooldown < 0) {
            return;
        }
        int activeDuration = (int)AccumulativeStatManager.getCachedStats("PARRY_EFFECTIVENESS_DURATION", (Entity)e, 10000L, true);
        if (activeDuration <= 0) {
            return;
        }
        int vulnerableDuration = (int)AccumulativeStatManager.getCachedStats("PARRY_VULNERABLE_DURATION", (Entity)e, 10000L, true);
        Parryer.forceParry(e, activeDuration, vulnerableDuration, cooldown);
    }

    public static double handleParry(EntityDamageByEntityEvent e) {
        Entity entity;
        boolean canParry;
        Entity d = e.getDamager();
        boolean bl = canParry = d instanceof LivingEntity || d instanceof Projectile && parryProjectiles;
        if (canParry && (entity = e.getEntity()) instanceof LivingEntity) {
            Player p;
            LivingEntity v = (LivingEntity)entity;
            if (v instanceof Player && WorldGuardHook.inDisabledRegion((p = (Player)v).getLocation(), p, "vmmo-combat-parry")) {
                return 1.0;
            }
            if (!Timer.isCooldownPassed(v.getUniqueId(), "parry_effective")) {
                if (parrySparks && parrySuccessAnimation != null) {
                    parrySuccessAnimation.animate(v, v.getLocation(), v.getEyeLocation().getDirection(), 0);
                }
                v.getWorld().playSound(v.getLocation(), parrySuccessSound, 1.0f, 1.0f);
                double damageReduction = (int)AccumulativeStatManager.getCachedRelationalStats("PARRY_DAMAGE_REDUCTION", (Entity)v, d, 10000L, true);
                double cooldownReduction = AccumulativeStatManager.getCachedRelationalStats("PARRY_SUCCESS_COOLDOWN_REDUCTION", (Entity)v, d, 10000L, true);
                long cooldown = Timer.getCooldown(v.getUniqueId(), "parry_cooldown");
                if (cooldown > 0L) {
                    Timer.setCooldown(v.getUniqueId(), (int)((double)cooldown * (1.0 - cooldownReduction)), "parry_cooldown");
                }
                Timer.setCooldown(v.getUniqueId(), 0, "parry_vulnerable");
                Timer.setCooldown(v.getUniqueId(), 0, "parry_effective");
                if (d instanceof LivingEntity) {
                    LivingEntity a = (LivingEntity)d;
                    int debuffDuration = (int)AccumulativeStatManager.getCachedRelationalStats("PARRY_ENEMY_DEBUFF_DURATION", (Entity)v, (Entity)a, 10000L, true);
                    for (PotionEffectWrapper wrapper : parryEnemyDebuffs) {
                        PotionEffectWrapper copy = PotionEffectRegistry.getEffect(wrapper.getEffect()).setAmplifier(wrapper.getAmplifier()).setDuration(debuffDuration);
                        if (!wrapper.isVanilla()) {
                            PotionEffectRegistry.addEffect(a, v, new CustomPotionEffect(copy, debuffDuration, copy.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ATTACK);
                            continue;
                        }
                        a.addPotionEffect(new PotionEffect(copy.getVanillaEffect(), debuffDuration, (int)copy.getAmplifier()));
                    }
                    e.setDamage(e.getDamage() * (1.0 - damageReduction));
                } else if (parryProjectilesReflect && !(d instanceof Trident)) {
                    Projectile p2 = (Projectile)d;
                    p2.setVelocity(p2.getVelocity().multiply(-1));
                    p2.setShooter((ProjectileSource)v);
                    double inaccuracy = AccumulativeStatManager.getCachedStats("RANGED_INACCURACY", (Entity)v, 10000L, true);
                    EntityUtils.applyInaccuracy((Entity)p2, v.getEyeLocation().getDirection(), inaccuracy);
                    return 0.0;
                }
                return 1.0 - damageReduction;
            }
            if (!Timer.isCooldownPassed(v.getUniqueId(), "parry_vulnerable")) {
                int debuffDuration = (int)AccumulativeStatManager.getCachedRelationalStats("PARRY_SELF_DEBUFF_DURATION", (Entity)v, d, 10000L, true);
                for (PotionEffectWrapper wrapper : parrySelfDebuffs) {
                    PotionEffectWrapper copy = PotionEffectRegistry.getEffect(wrapper.getEffect()).setAmplifier(wrapper.getAmplifier()).setDuration(debuffDuration);
                    if (!wrapper.isVanilla()) {
                        PotionEffectRegistry.addEffect(v, null, new CustomPotionEffect(copy, debuffDuration, copy.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ATTACK);
                        continue;
                    }
                    v.addPotionEffect(new PotionEffect(copy.getVanillaEffect(), debuffDuration, (int)copy.getAmplifier()));
                }
                if (parryFailAnimation != null) {
                    parryFailAnimation.animate(v, v.getLocation(), v.getEyeLocation().getDirection(), 0);
                }
                v.getWorld().playSound(v.getLocation(), parryFailedSound, 1.0f, 1.0f);
            }
            Timer.setCooldown(v.getUniqueId(), 0, "parry_vulnerable");
            Timer.setCooldown(v.getUniqueId(), 0, "parry_effective");
        }
        return 1.0;
    }

    public static void setParrySuccessAnimation(Animation parrySuccessAnimation) {
        Parryer.parrySuccessAnimation = parrySuccessAnimation;
    }

    public static Animation getParrySuccessAnimation() {
        return parrySuccessAnimation;
    }

    public static void setParryFailAnimation(Animation parryFailAnimation) {
        Parryer.parryFailAnimation = parryFailAnimation;
    }

    public static Animation getParryFailAnimation() {
        return parryFailAnimation;
    }

    static {
        ConfigurationSection selfSection;
        parryEnemyDebuffs = new HashSet<PotionEffectWrapper>();
        parrySelfDebuffs = new HashSet<PotionEffectWrapper>();
        parrySparks = ValhallaMMO.getPluginConfig().getBoolean("parry_sparks");
        parryProjectiles = ValhallaMMO.getPluginConfig().getBoolean("parry_projectiles");
        parryProjectilesReflect = ValhallaMMO.getPluginConfig().getBoolean("parried_projectiles_reflect");
        parryActivationSound = Utils.getSound(ValhallaMMO.getPluginConfig().getString("parry_sound"), Sound.BLOCK_IRON_TRAPDOOR_OPEN, "Invalid parry activation sound given, used default");
        parrySuccessSound = Utils.getSound(ValhallaMMO.getPluginConfig().getString("parry_success_sound"), Sound.ENTITY_ITEM_BREAK, "Invalid parry success sound given, used default");
        parryFailedSound = Utils.getSound(ValhallaMMO.getPluginConfig().getString("parry_failed_sound"), Sound.ITEM_SHIELD_BREAK, "Invalid parry fail sound given, used default");
        parrySuccessAnimation = AnimationRegistry.getAnimation(AnimationRegistry.ENTITY_SPARK_FLASH.id());
        parryFailAnimation = null;
        YamlConfiguration c = ValhallaMMO.getPluginConfig();
        ConfigurationSection enemySection = c.getConfigurationSection("parry_enemy_debuffs");
        if (enemySection != null) {
            for (String effect : enemySection.getKeys(false)) {
                parryEnemyDebuffs.add(PotionEffectRegistry.getEffect(effect).setAmplifier(c.getDouble("parry_enemy_debuffs." + effect)));
            }
        }
        if ((selfSection = c.getConfigurationSection("parry_failed_debuffs")) != null) {
            for (String effect : selfSection.getKeys(false)) {
                parrySelfDebuffs.add(PotionEffectRegistry.getEffect(effect).setAmplifier(c.getDouble("parry_failed_debuffs." + effect)));
            }
        }
    }
}

