/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class SideBarUtils {
    private static final Map<UUID, Sidebar> activeSidebars = new HashMap<UUID, Sidebar>();
    private static final List<Character> colors = List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('l'), Character.valueOf('o'), Character.valueOf('n'), Character.valueOf('m'), Character.valueOf('k'), Character.valueOf('r'));
    private static final ScoreboardManager manager = ValhallaMMO.getInstance().getServer().getScoreboardManager();

    public static void showSideBarToPlayer(Player player, String key, String title, List<String> contents, boolean force) {
        Sidebar sideBar = activeSidebars.get(player.getUniqueId());
        if (sideBar == null) {
            sideBar = new Sidebar(player, key, title, contents);
        } else {
            sideBar.updateContents(contents);
        }
        sideBar.showBoard(force);
        activeSidebars.put(player.getUniqueId(), sideBar);
    }

    public static void hideSideBarFromPlayer(Player player, String key) {
        if (player.getScoreboard().getObjective(key) != null && manager != null) {
            player.setScoreboard(manager.getMainScoreboard());
            activeSidebars.remove(player.getUniqueId());
        }
    }

    private static class Sidebar {
        private final Player p;
        private final Scoreboard scoreboard = manager == null ? null : manager.getNewScoreboard();
        private Objective objective;

        public Sidebar(Player p, String key, String title, List<String> entries) {
            this.p = p;
            if (this.scoreboard != null) {
                this.objective = this.scoreboard.getObjective(key);
                if (this.objective == null) {
                    this.objective = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20) ? this.scoreboard.registerNewObjective(key, Criteria.DUMMY, Utils.chat(title)) : this.scoreboard.registerNewObjective(key, "dummy", Utils.chat(title));
                }
                this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
                this.updateContents(entries);
            }
        }

        public void updateContents(List<String> newContents) {
            if (this.scoreboard == null) {
                return;
            }
            newContents = newContents.subList(0, Math.min(newContents.size(), colors.size()));
            this.scoreboard.getTeams().forEach(Team::unregister);
            for (int i = 0; i < newContents.size(); ++i) {
                String lineContents = newContents.get(i);
                String color = Utils.chat("&" + String.valueOf(colors.get(i)) + "&r");
                Team team = this.scoreboard.getTeam("t" + i);
                if (team == null) {
                    team = this.scoreboard.registerNewTeam("t" + i);
                }
                team.addEntry(color);
                team.setPrefix(lineContents);
                this.objective.getScore(color).setScore(i);
            }
        }

        public void showBoard(boolean force) {
            if (force || this.p.getScoreboard().getObjective("valhalla") == null) {
                this.p.setScoreboard(this.scoreboard);
            }
        }
    }
}

