/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.hooks.MiniMessageHook;
import me.athlaeos.valhallammo.utility.MathEval;
import me.athlaeos.valhallammo.utility.MathUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Utils {
    public static final Particle DUST = Particle.valueOf((String)Utils.oldOrNew("REDSTONE", "DUST"));
    private static final Random random = new Random();
    private static final Map<String, Double> evalCache = new HashMap<String, Double>();
    private static final MathEval math = new MathEval();
    static final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static boolean miniMessageSupported;

    public static Random getRandom() {
        return random;
    }

    public static boolean withinManhattanRange(Location l1, Location l2, double range) {
        return Math.abs(l1.getX() - l2.getX()) <= range && Math.abs(l1.getY() - l2.getY()) <= range && Math.abs(l1.getZ() - l2.getZ()) <= range;
    }

    public static int getManhattanDistance(Location l1, Location l2) {
        return Math.abs(l1.getBlockX() - l2.getBlockX()) + Math.abs(l1.getBlockY() - l2.getBlockY()) + Math.abs(l1.getBlockZ() - l2.getBlockZ());
    }

    public static int getManhattanDistance(int x1, int z1, int x2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(z1 - z2);
    }

    public static Map<String, OfflinePlayer> getPlayersFromUUIDs(Collection<UUID> uuids) {
        HashMap<String, OfflinePlayer> players = new HashMap<String, OfflinePlayer>();
        for (UUID uuid : uuids) {
            OfflinePlayer player = ValhallaMMO.getInstance().getServer().getOfflinePlayer(uuid);
            players.put(player.getName(), player);
        }
        return players;
    }

    public static Map<String, Player> getOnlinePlayersFromUUIDs(Collection<UUID> uuids) {
        HashMap<String, Player> players = new HashMap<String, Player>();
        for (UUID uuid : uuids) {
            Player player = ValhallaMMO.getInstance().getServer().getPlayer(uuid);
            if (player == null) continue;
            players.put(player.getName(), player);
        }
        return players;
    }

    public static Color hexToRgb(String colorStr) {
        return Color.fromRGB((int)Integer.valueOf(colorStr.substring(1, 3), 16), (int)Integer.valueOf(colorStr.substring(3, 5), 16), (int)Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static String rgbToHex(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static int randomAverage(double chance) {
        boolean negative = chance < 0.0;
        int atLeast = negative ? (int)Math.ceil(chance) : (int)Math.floor(chance);
        double remainingChance = chance - (double)atLeast;
        if (Utils.getRandom().nextDouble() <= Math.abs(remainingChance)) {
            atLeast += negative ? -1 : 1;
        }
        return atLeast;
    }

    public static boolean proc(double chance, double luck, boolean ignoreConfig) {
        if (luck == 0.0 || !ignoreConfig && !ValhallaMMO.getPluginConfig().getBoolean("custom_luck", true)) {
            return random.nextDouble() <= chance;
        }
        if (chance >= 1.0) {
            return true;
        }
        if (chance <= 0.0) {
            return false;
        }
        if (luck > 0.0) {
            return random.nextDouble() <= 1.0 - MathUtils.pow(1.0 - chance, luck + 1.0);
        }
        return random.nextDouble() <= MathUtils.pow(chance, -luck + 1.0);
    }

    public static boolean badProc(double chance, double luck, boolean ignoreConfig) {
        return Utils.proc(chance, -luck, ignoreConfig);
    }

    public static boolean proc(LivingEntity e, double chance, boolean ignoreConfig) {
        AttributeInstance luckInstance = e.getAttribute(Attribute.GENERIC_LUCK);
        return Utils.proc(chance, luckInstance == null ? 0.0 : luckInstance.getValue(), ignoreConfig);
    }

    public static boolean badProc(LivingEntity e, double chance, boolean ignoreConfig) {
        AttributeInstance luckInstance = e.getAttribute(Attribute.GENERIC_LUCK);
        return Utils.badProc(chance, luckInstance == null ? 0.0 : luckInstance.getValue(), ignoreConfig);
    }

    public static Collection<Player> selectPlayers(CommandSender source, String selector) throws IllegalArgumentException {
        HashSet<Player> targets = new HashSet<Player>();
        if (selector.startsWith("@")) {
            for (Entity part : Bukkit.selectEntities((CommandSender)source, (String)selector)) {
                if (!(part instanceof Player)) continue;
                targets.add((Player)part);
            }
        } else {
            Player target = ValhallaMMO.getInstance().getServer().getPlayer(selector);
            if (target != null) {
                targets.add(target);
            }
        }
        return targets;
    }

    public static double round6Decimals(double d) {
        return (double)Math.round(d * 1000000.0) / 1000000.0;
    }

    public static double roundToMultiple(double number, double multiple) {
        return multiple * (double)Math.round(number / multiple);
    }

    public static double eval(String expression) {
        if (evalCache.containsKey(expression = expression.replaceAll(",", "."))) {
            return evalCache.get(expression);
        }
        double result = math.evaluate(expression);
        evalCache.put(expression, result);
        return result;
    }

    public static List<String> chat(List<String> messages) {
        ArrayList<String> chat = new ArrayList<String>();
        for (String message : messages) {
            chat.add(Utils.chat(message));
        }
        return chat;
    }

    public static String chat(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return "";
        }
        if (miniMessageSupported) {
            message = MiniMessageHook.convertMiniMessage(message);
        }
        return Utils.vanillaChat(message);
    }

    public static String vanillaChat(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return "";
        }
        char COLOR_CHAR = '\u00a7';
        Matcher matcher = hexPattern.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, COLOR_CHAR + "x" + COLOR_CHAR + group.charAt(0) + COLOR_CHAR + group.charAt(1) + COLOR_CHAR + group.charAt(2) + COLOR_CHAR + group.charAt(3) + COLOR_CHAR + group.charAt(4) + COLOR_CHAR + group.charAt(5));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    public static <T> Map<Integer, List<T>> paginate(int pageSize, List<T> allEntries) {
        HashMap<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
        int maxPages = (int)Math.ceil((double)allEntries.size() / (double)pageSize);
        for (int pageNumber = 0; pageNumber < maxPages; ++pageNumber) {
            pages.put(pageNumber, allEntries.subList(Math.min(pageNumber * pageSize, allEntries.size()), Math.min((pageNumber + 1) * pageSize, allEntries.size())));
        }
        return pages;
    }

    public static void sendMessage(CommandSender whomst, String message) {
        if (!StringUtils.isEmpty((String)message)) {
            if (message.startsWith("ACTIONBAR") && whomst instanceof Player) {
                Player p = (Player)whomst;
                Utils.sendActionBar(p, message.replaceFirst("ACTIONBAR", ""));
            } else if (message.startsWith("TITLE") && whomst instanceof Player) {
                Player p = (Player)whomst;
                String title = message.replaceFirst("TITLE", "");
                String subtitle = "";
                int titleDuration = 40;
                int fadeDuration = 5;
                String subString = StringUtils.substringBetween((String)message, (String)"TITLE(", (String)")");
                if (subString != null) {
                    String[] args = subString.split(";");
                    if (args.length > 0) {
                        title = args[0];
                    }
                    if (args.length > 1) {
                        subtitle = args[1];
                    }
                    if (args.length > 2) {
                        titleDuration = Catch.catchOrElse(() -> Integer.parseInt(args[2]), 100);
                    }
                    if (args.length > 3) {
                        fadeDuration = Catch.catchOrElse(() -> Integer.parseInt(args[2]), 10);
                    }
                }
                Utils.sendTitle(p, title, subtitle, titleDuration, fadeDuration);
            } else {
                whomst.sendMessage(Utils.chat(message));
            }
        }
    }

    public static void sendActionBar(Player whomst, String message) {
        if (!StringUtils.isEmpty((String)ChatColor.stripColor((String)Utils.chat(message)))) {
            whomst.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(message)));
        }
    }

    public static void sendTitle(Player whomst, String title, String subtitle, int duration, int fade) {
        if (!StringUtils.isEmpty((String)title)) {
            whomst.sendTitle(Utils.chat(title), Utils.chat(subtitle), fade, duration, fade);
        }
    }

    public static <T extends Weighted> List<T> weightedSelection(Collection<T> entries, int rolls, double luck, double fortune) {
        double totalWeight = 0.0;
        ArrayList<Weighted> selectedEntries = new ArrayList<Weighted>();
        if (entries.isEmpty()) {
            return selectedEntries;
        }
        ArrayList<Pair<Weighted, Double>> totalEntries = new ArrayList<Pair<Weighted, Double>>();
        for (Weighted entry : entries) {
            totalEntries.add(new Pair<Weighted, Double>(entry, totalWeight += entry.getWeight(luck, fortune)));
        }
        block1: for (int i = 0; i < rolls; ++i) {
            double random = Utils.getRandom().nextDouble() * totalWeight;
            for (Pair pair : totalEntries) {
                if (!((Double)pair.getTwo() >= random)) continue;
                selectedEntries.add((Weighted)pair.getOne());
                continue block1;
            }
        }
        return selectedEntries;
    }

    public static boolean hasNewMappings() {
        return MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5);
    }

    public static String oldOrNew(String o, String n) {
        return Utils.hasNewMappings() ? n : o;
    }

    public static <T> T thisorDefault(T input, T def) {
        return input == null ? def : input;
    }

    public static <T> T random(Collection<T> coll) {
        int num = (int)(Math.random() * (double)coll.size());
        for (T t : coll) {
            if (--num >= 0) continue;
            return t;
        }
        throw new AssertionError();
    }

    public static void repeat(int times, Action<Integer> what) {
        for (int i = 0; i < times; ++i) {
            what.act(i);
        }
    }

    public static ScheduledExecutorService threadPool(String name, int timeoutMs, boolean daemon, int count) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(count, Utils.threadFactory(name, daemon));
        if (timeoutMs > 0) {
            executor.setKeepAliveTime(timeoutMs, TimeUnit.MILLISECONDS);
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    public static ThreadFactory threadFactory(String name, boolean daemon) {
        return r -> {
            Thread thread = new Thread(r);
            thread.setName("ValhallaMMO-Async-" + name + "-Thread");
            thread.setDaemon(daemon);
            return thread;
        };
    }

    public static Sound getSound(String of) {
        Sound ofRegistry;
        NamespacedKey ofKey = NamespacedKey.fromString((String)of);
        Sound sound = ofRegistry = ofKey == null ? null : (Sound)Registry.SOUNDS.get(ofKey);
        if (ofRegistry == null) {
            return Catch.catchOrElse(() -> Sound.valueOf((String)of), null);
        }
        return ofRegistry;
    }

    public static Sound getSound(String of, Sound def, String warningIfNull) {
        Sound s = Utils.getSound(of);
        if (s == null) {
            if (!StringUtils.isEmpty((String)warningIfNull)) {
                ValhallaMMO.logWarning(warningIfNull);
            }
            return def;
        }
        return s;
    }

    static {
        try {
            Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            miniMessageSupported = true;
            ValhallaMMO.logInfo("MiniMessage support initialized");
        }
        catch (ClassNotFoundException ignored) {
            miniMessageSupported = false;
            ValhallaMMO.logInfo("MiniMessage support could not be initialized");
        }
    }
}

