/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version;

import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;

public class SmithingTransformRecipeWrapper {
    public static SmithingRecipe get(NamespacedKey key, ItemStack result, RecipeChoice template, RecipeChoice base, RecipeChoice addition) {
        return new SmithingTransformRecipe(key, result, template, base, addition);
    }

    public static ItemStack getTemplate(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe r = (SmithingTransformRecipe)recipe;
            return SmithingTransformRecipeWrapper.convertChoice(r.getTemplate());
        }
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe r = (SmithingTrimRecipe)recipe;
            return SmithingTransformRecipeWrapper.convertChoice(r.getTemplate());
        }
        return null;
    }

    private static ItemStack convertChoice(RecipeChoice choice) {
        if (choice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice m = (RecipeChoice.MaterialChoice)choice;
            return m.getItemStack();
        }
        if (choice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice m = (RecipeChoice.ExactChoice)choice;
            return m.getItemStack();
        }
        return null;
    }

    public static boolean isTransformRecipe(SmithingRecipe recipe) {
        return recipe instanceof SmithingTransformRecipe;
    }

    public static boolean isTrimRecipe(SmithingRecipe recipe) {
        return recipe instanceof SmithingTrimRecipe;
    }

    public static boolean templatesMatch(SmithingRecipe recipe, ItemStack template) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe t = (SmithingTrimRecipe)recipe;
            if (!ItemUtils.isEmpty(template)) {
                return t.getTemplate().test(template);
            }
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe t = (SmithingTransformRecipe)recipe;
            if (!ItemUtils.isEmpty(template)) {
                return t.getTemplate().test(template);
            }
        }
        return false;
    }
}

