/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version.conversion_dto;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.version.conversion_dto.AlchemyProfile;
import me.athlaeos.valhallammo.version.conversion_dto.ArcheryProfile;
import me.athlaeos.valhallammo.version.conversion_dto.EnchantingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.FarmingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.HeavyArmorProfile;
import me.athlaeos.valhallammo.version.conversion_dto.HeavyWeaponsProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LandscapingProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LightArmorProfile;
import me.athlaeos.valhallammo.version.conversion_dto.LightWeaponsProfile;
import me.athlaeos.valhallammo.version.conversion_dto.MiningProfile;
import me.athlaeos.valhallammo.version.conversion_dto.Profile;
import me.athlaeos.valhallammo.version.conversion_dto.SmithingProfile;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AlphaPDCAdapter {
    private final Gson gson = new Gson();
    private final Map<String, NamespacedKey> alphaKeyMappings = new HashMap<String, NamespacedKey>();
    private final Map<String, Class<? extends Profile>> alphaProfileMappings = new HashMap<String, Class<? extends Profile>>();

    public AlphaPDCAdapter() {
        this.alphaKeyMappings.put("ALCHEMY", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_alchemy"));
        this.alphaKeyMappings.put("ARCHERY", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_archery"));
        this.alphaKeyMappings.put("ENCHANTING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_enchanting"));
        this.alphaKeyMappings.put("FARMING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_farming"));
        this.alphaKeyMappings.put("HEAVYARMOR", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_heavy_armor"));
        this.alphaKeyMappings.put("HEAVYWEAPONS", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_heavy_weapons"));
        this.alphaKeyMappings.put("LANDSCAPING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_landscaping"));
        this.alphaKeyMappings.put("LIGHTARMOR", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_light_armor"));
        this.alphaKeyMappings.put("LIGHTWEAPONS", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_light_weapons"));
        this.alphaKeyMappings.put("MINING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_mining"));
        this.alphaKeyMappings.put("SMITHING", new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_profile_smithing"));
        this.alphaProfileMappings.put("ALCHEMY", AlchemyProfile.class);
        this.alphaProfileMappings.put("ARCHERY", ArcheryProfile.class);
        this.alphaProfileMappings.put("ENCHANTING", EnchantingProfile.class);
        this.alphaProfileMappings.put("FARMING", FarmingProfile.class);
        this.alphaProfileMappings.put("HEAVYARMOR", HeavyArmorProfile.class);
        this.alphaProfileMappings.put("HEAVYWEAPONS", HeavyWeaponsProfile.class);
        this.alphaProfileMappings.put("LANDSCAPING", LandscapingProfile.class);
        this.alphaProfileMappings.put("LIGHTARMOR", LightArmorProfile.class);
        this.alphaProfileMappings.put("LIGHTWEAPONS", LightWeaponsProfile.class);
        this.alphaProfileMappings.put("MINING", MiningProfile.class);
        this.alphaProfileMappings.put("SMITHING", SmithingProfile.class);
    }

    public Profile getProfile(Player p, String type) {
        if (p == null) {
            return null;
        }
        NamespacedKey key = this.alphaKeyMappings.get(type);
        if (key == null) {
            return null;
        }
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            return null;
        }
        String jsonProfile = (String)p.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (jsonProfile == null) {
            ValhallaMMO.logSevere("Profile is still null after creation, this should never occur. Notify plugin author");
            return null;
        }
        return (Profile)this.gson.fromJson(jsonProfile, this.alphaProfileMappings.get(type));
    }
}

