/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.animations.implementations;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class BlockBubbles
extends Animation {
    private static final Map<Material, Particle> bubbleParticles = new HashMap<Material, Particle>();
    private static final Map<Material, Particle> smokeParticles = new HashMap<Material, Particle>();
    private static final Map<Material, Sound> boilSound = new HashMap<Material, Sound>();

    public BlockBubbles(String id) {
        super(id);
    }

    @Override
    public void animate(LivingEntity crafter, Location location, Vector direction, int tick) {
        Block block = location.getBlock();
        Particle bubble = bubbleParticles.getOrDefault(block.getType(), Particle.valueOf((String)Utils.oldOrNew("WATER_BUBBLE", "BUBBLE")));
        Particle smoke = smokeParticles.getOrDefault(block.getType(), Particle.CAMPFIRE_COSY_SMOKE);
        Sound sound = boilSound.get(block.getType());
        if (tick % 20 == 0) {
            for (Location l : MathUtils.getRandomPointsInArea(block.getLocation().add(0.5, 0.8, 0.5), 0.4, 1)) {
                block.getWorld().spawnParticle(smoke, l, 0, 0.0, 0.15, 0.0);
            }
        }
        if (sound != null && tick % 10 == 0) {
            block.getWorld().playSound(block.getLocation().add(0.5, 1.0, 0.5), Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT, 4.0f, 1.0f);
        }
        if (tick % 4 == 0) {
            for (Location l : MathUtils.getRandomPointsInPlane(block.getLocation().add(0.5, 0.95, 0.5), 0.35, 1)) {
                block.getWorld().spawnParticle(bubble, l, 0, 0.0, 0.15, 0.0);
            }
        }
    }

    static {
        bubbleParticles.put(ItemUtils.stringToMaterial("LAVA_CAULDRON", Material.CAULDRON), Particle.FLAME);
        bubbleParticles.put(ItemUtils.stringToMaterial("POWDERED_SNOW_CAULDRON", Material.CAULDRON), Particle.END_ROD);
        bubbleParticles.put(ItemUtils.stringToMaterial("WATER_CAULDRON", Material.CAULDRON), Particle.valueOf((String)Utils.oldOrNew("WATER_BUBBLE", "BUBBLE")));
        Material powderedSnowCauldron = ItemUtils.stringToMaterial("WATER_CAULDRON", null);
        if (powderedSnowCauldron != null) {
            smokeParticles.put(powderedSnowCauldron, Particle.valueOf((String)Utils.oldOrNew("FIREWORKS_SPARK", "FIREWORK")));
        }
        boilSound.put(ItemUtils.stringToMaterial("LAVA_CAULDRON", Material.CAULDRON), Sound.BLOCK_LAVA_AMBIENT);
        boilSound.put(ItemUtils.stringToMaterial("WATER_CAULDRON", Material.CAULDRON), Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT);
        boilSound.put(ItemUtils.stringToMaterial("CAULDRON", Material.CAULDRON), Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT);
    }
}

