/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.MiningProfile;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BlockDigProcess {
    private final Block block;
    private float health = 1.0f;
    private int ticksSinceUpdate = 0;
    private int lastStage = 0;
    private static boolean done = false;
    private static BukkitTask instantBlockBreakerTask = null;
    private static final Map<UUID, Location> blocksToBreakInstantly = new HashMap<UUID, Location>();
    private static final Map<UUID, Location> blocksToBreakInstantly2 = new HashMap<UUID, Location>();

    public void damage(Player by, float damage, boolean force) {
        if (!force && !Timer.isCooldownPassed(by.getUniqueId(), "delay_block_breaking_allowed")) {
            return;
        }
        this.health -= damage;
        this.ticksSinceUpdate = 0;
        if (this.health <= 0.0f) {
            if (!force && damage < 1.0f && CustomBreakSpeedListener.isVanillaBlockBreakDelay()) {
                Timer.setCooldown(by.getUniqueId(), 300, "delay_block_breaking_allowed");
            }
            BlockDigProcess.breakBlockInstantly(by, this.block);
        } else {
            this.lastStage = this.getCracks();
            BlockDigProcess.sendCracks(this.block, this.lastStage);
        }
    }

    public void damage(Player by, float damage) {
        this.damage(by, damage, false);
    }

    public static void breakBlockInstantly(Player by, Block block) {
        if (!blocksToBreakInstantly.isEmpty()) {
            blocksToBreakInstantly.put(by.getUniqueId(), block.getLocation());
        } else {
            blocksToBreakInstantly2.put(by.getUniqueId(), block.getLocation());
        }
        if (instantBlockBreakerTask != null && !done) {
            return;
        }
        done = false;
        instantBlockBreakerTask = ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            try {
                new HashSet<Map.Entry<UUID, Location>>((blocksToBreakInstantly.isEmpty() ? blocksToBreakInstantly2 : blocksToBreakInstantly).entrySet()).forEach(e -> {
                    ItemBuilder optimalTool;
                    Player p = ValhallaMMO.getInstance().getServer().getPlayer((UUID)e.getKey());
                    if (p == null || !p.isOnline()) {
                        (blocksToBreakInstantly.isEmpty() ? blocksToBreakInstantly2 : blocksToBreakInstantly).remove(e.getKey());
                        return;
                    }
                    Block b = ((Location)e.getValue()).getBlock();
                    ItemBuilder tool = null;
                    ItemBuilder originalTool = null;
                    if (ItemUtils.isEmpty(p.getInventory().getItemInMainHand())) {
                        MiningProfile profile = ProfileCache.getOrCache(p, MiningProfile.class);
                        if (profile.getEmptyHandTool() != null) {
                            tool = profile.getEmptyHandTool();
                        }
                    } else {
                        originalTool = tool = EntityCache.getAndCacheProperties((LivingEntity)p).getMainHand();
                    }
                    if (tool != null && !tool.getEmbeddedTools().isEmpty() && (optimalTool = MiningSpeed.getOptimalEmbeddedTool(tool.getEmbeddedTools(), tool.getMeta(), b)) != null) {
                        tool = optimalTool;
                    }
                    if (tool != null && !BlockUtils.hasDrops(b, (Entity)p, originalTool == null ? null : originalTool.getItem()) && ValhallaMMO.getNms().toolPower(tool.getItem(), b) > 1.0f) {
                        LootListener.prepareBlockDrops(b, new ArrayList<ItemStack>(b.getDrops(tool.get())));
                    }
                    ValhallaMMO.getNms().breakBlock(p, b);
                    CustomBreakSpeedListener.getBlockDigProcesses().remove(b.getLocation());
                    for (UUID uuid : (Collection)CustomBreakSpeedListener.getTotalMiningBlocks().getOrDefault(b.getLocation(), new HashSet())) {
                        CustomBreakSpeedListener.getMiningPlayers().remove(uuid);
                    }
                    CustomBreakSpeedListener.getTotalMiningBlocks().remove(b.getLocation());
                    DigPacketInfo.resetBlockSpecificCache(p.getUniqueId());
                    BlockUtils.removeCustomHardness(b);
                    BlockDigProcess.sendCracks(b, -1);
                });
            }
            catch (ConcurrentModificationException ignored) {
                ValhallaMMO.logWarning("Caught CME on block breakage, not good but better than nothing");
            }
            (blocksToBreakInstantly.isEmpty() ? blocksToBreakInstantly2 : blocksToBreakInstantly).clear();
            done = true;
        });
    }

    public int getTicksSinceUpdate() {
        return this.ticksSinceUpdate;
    }

    public static void sendCracks(Block block, int cracks) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> {
            for (Entity p : block.getWorld().getNearbyEntities(block.getLocation(), 20.0, 20.0, 20.0, e -> e instanceof Player)) {
                ValhallaMMO.getNms().blockBreakAnimation((Player)p, block, BlockDigProcess.getID(block), cracks);
            }
        });
    }

    private static int getID(Block block) {
        return (block.getX() & 0xFFF) << 20 | (block.getZ() & 0xFFF) << 8 | block.getY() & 0xFF;
    }

    public BlockDigProcess(Block b) {
        this.block = b;
    }

    public int getCracks() {
        if (this.health <= 0.0f || this.health >= 1.0f) {
            return -1;
        }
        return (int)Math.floor((1.0f - this.health) * 10.0f);
    }

    public void incrementTicksSinceUpdate() {
        ++this.ticksSinceUpdate;
    }

    public void heal(float health) {
        this.health += health;
        int cracks = this.getCracks();
        if (this.lastStage == cracks) {
            return;
        }
        this.lastStage = cracks;
        BlockDigProcess.sendCracks(this.block, cracks);
    }

    public float getHealth() {
        return this.health;
    }
}

