/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.arrow_attributes.ArrowBehaviorRegistry;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ArrowBehaviorLargeFireball
extends DynamicItemModifier {
    private double radius = 3.0;
    private boolean incendiary = false;

    public ArrowBehaviorLargeFireball(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ArrowBehaviorRegistry.addBehavior(context.getItem().getMeta(), ArrowBehaviorRegistry.FIREBALL_LARGE.getName(), this.radius, this.incendiary ? 1.0 : 0.0);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11) {
            this.radius = Math.max(0.0, this.radius + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0 : 0.1));
        } else if (button == 13) {
            this.incendiary = !this.incendiary;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.TNT).name("&6Explosion Radius").lore(String.format("&fExplosion Radius: %.1f", this.radius), String.format("&fLights fire to environment: &e%s", this.incendiary ? "Yes" : "No"), "&6Click to add/subtract 0.1", "&6Shift-Click to add/subtract 1").get()).map(Set.of(new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.FLINT_AND_STEEL).name("&6Lights Fire to Environment").lore(String.format("&fExplosion Radius: %.1f", this.radius), String.format("&fLights fire to environment: &e%s", this.incendiary ? "Yes" : "No"), "&6Click to toggle on/off").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.FIRE_CHARGE).get();
    }

    @Override
    public String getDisplayName() {
        return "&6Arrow Behavior: Large Fireball";
    }

    @Override
    public String getDescription() {
        return "&fTurns the arrow into a large fireball when shot";
    }

    @Override
    public String getActiveDescription() {
        return String.format("&fTurns the arrow into a large fireball when shot. /n&eBlast Radius: %.1f/n&eIncendiary: %s", this.radius, this.incendiary ? "Yes" : "No");
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.CUSTOM_ATTRIBUTES.id());
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setIncendiary(boolean incendiary) {
        this.incendiary = incendiary;
    }

    @Override
    public DynamicItemModifier copy() {
        ArrowBehaviorLargeFireball m = new ArrowBehaviorLargeFireball(this.getName());
        m.setIncendiary(this.incendiary);
        m.setRadius(this.radius);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 2) {
            return "Two arguments are expected: the first a double, the second a yes/no answer";
        }
        try {
            this.radius = Integer.parseInt(args[0]);
            this.incendiary = args[1].equalsIgnoreCase("yes");
        }
        catch (NumberFormatException ignored) {
            return "Two arguments are expected: the first a double, the second a yes/no answer. At least one was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<explosion_radius>");
        }
        if (currentArg == 1) {
            return List.of("<should_ignite_terrain>", "yes", "no");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 2;
    }
}

