/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.entities.damageindicators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.entities.damageindicators.DamageIndicatorStrategy;
import me.athlaeos.valhallammo.entities.damageindicators.implementations.DecentHologramsDPSIndicator;
import me.athlaeos.valhallammo.entities.damageindicators.implementations.TextDisplayDPSIndicator;
import me.athlaeos.valhallammo.hooks.DecentHologramsHook;
import org.bukkit.entity.LivingEntity;

public class DamageIndicatorRegistry {
    private static final List<DamageIndicatorStrategy> strategies = new ArrayList<DamageIndicatorStrategy>();
    private static final Collection<UUID> critIndicator = new HashSet<UUID>();

    public static boolean sendDamageIndicator(LivingEntity l, CustomDamageType damageType, double damage, double mitigated) {
        Iterator<DamageIndicatorStrategy> iterator = strategies.stream().filter(s -> s.use(l)).toList().iterator();
        if (iterator.hasNext()) {
            DamageIndicatorStrategy s2 = iterator.next();
            return critIndicator.remove(l.getUniqueId()) ? s2.sendCriticalDamage(l, damageType, damage, mitigated) : s2.sendDamage(l, damageType, damage, mitigated);
        }
        return false;
    }

    public static void markCriticallyHit(LivingEntity l) {
        critIndicator.add(l.getUniqueId());
    }

    public static List<DamageIndicatorStrategy> getStrategies() {
        return strategies;
    }

    public static void registerStrategy(DamageIndicatorStrategy strategy) {
        strategies.add(strategy);
    }

    static {
        if (ValhallaMMO.isHookFunctional(DecentHologramsHook.class)) {
            strategies.add(new DecentHologramsDPSIndicator());
        }
        if (!MinecraftVersion.currentVersionOlderThan(MinecraftVersion.MINECRAFT_1_19)) {
            strategies.add(new TextDisplayDPSIndicator());
        }
    }
}

