/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.entities.damageindicators.implementations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.entities.Dummy;
import me.athlaeos.valhallammo.entities.damageindicators.DamageIndicatorStrategy;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TextDisplayDPSIndicator
implements DamageIndicatorStrategy {
    private static final boolean dummiesOnly = ValhallaMMO.getPluginConfig().getBoolean("dummies_only");
    private static final String actionBarFormat = TranslationManager.translatePlaceholders(ValhallaMMO.getPluginConfig().getString("damage_indicator_actionbar_format"));
    private static final int indicatorPerChunkLimit = ValhallaMMO.getPluginConfig().getInt("damage_indicator_chunk_limit", 5);
    private static final Map<UUID, Map<CustomDamageType, DPSInstance>> damageIndicatorMap = new HashMap<UUID, Map<CustomDamageType, DPSInstance>>();
    private static final Map<UUID, DPSInstance> expiredInstances = new HashMap<UUID, DPSInstance>();
    private static final String format = TranslationManager.translatePlaceholders(ValhallaMMO.getPluginConfig().getString("damage_indicator_format", ""));
    private static final String critFormat = TranslationManager.translatePlaceholders(ValhallaMMO.getPluginConfig().getString("damage_indicator_crit", ""));

    @Override
    public boolean sendDamage(LivingEntity l, CustomDamageType damageType, double damage, double mitigated) {
        if (damage < 0.05 && mitigated < 0.05) {
            return false;
        }
        return TextDisplayDPSIndicator.update(l, damageType, damage, mitigated, false);
    }

    @Override
    public boolean sendCriticalDamage(LivingEntity l, CustomDamageType damageType, double damage, double mitigated) {
        if (damage < 0.05 && mitigated < 0.05) {
            return false;
        }
        if (Dummy.isDummy(l)) {
            l.playEffect(EntityEffect.ARMOR_STAND_HIT);
        }
        return TextDisplayDPSIndicator.update(l, damageType, damage, mitigated, true);
    }

    @Override
    public boolean use(LivingEntity l) {
        boolean dummy = Dummy.isDummy(l);
        if (MinecraftVersion.currentVersionOlderThan(MinecraftVersion.MINECRAFT_1_19) || dummiesOnly && !dummy) {
            return false;
        }
        if (dummy) {
            l.playEffect(EntityEffect.ARMOR_STAND_HIT);
        }
        return true;
    }

    public static boolean update(LivingEntity damaged, CustomDamageType damageType, double damage, double mitigated, boolean crit) {
        if (damageType == null || format == null) {
            return false;
        }
        Map instances = damageIndicatorMap.getOrDefault(damaged.getUniqueId(), new TreeMap());
        if (instances.containsKey(damageType) && !expiredInstances.containsKey(((DPSInstance)((Object)instances.get((Object)damageType))).id)) {
            ((DPSInstance)((Object)instances.get(damageType))).update(damage, mitigated, crit);
        } else if (ChunkEXPNerf.getCount(damaged.getLocation().getChunk(), null, "damage_indicator_limiter") <= indicatorPerChunkLimit) {
            DPSInstance instance = new DPSInstance(damaged, damageType, damage, mitigated, crit);
            instances.put(damageType, instance);
            damageIndicatorMap.put(damaged.getUniqueId(), instances);
            int index = 0;
            for (CustomDamageType type : damageIndicatorMap.get(damaged.getUniqueId()).keySet()) {
                TextDisplayDPSIndicator.damageIndicatorMap.get((Object)damaged.getUniqueId()).get((Object)type).priority = index++;
            }
            instance.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
        }
        return Dummy.isDummy(damaged);
    }

    private static class DPSInstance
    extends BukkitRunnable {
        private final UUID id;
        private final LivingEntity damaged;
        private final CustomDamageType type;
        private double damage;
        private double mitigated;
        private TextDisplay display;
        private int priority;
        private boolean isCrit = false;
        private static final int BOLD_TIME = 5;
        private static final int LINGER_TIME = 20;
        private static final double RISE_SPEED = 0.03;
        private int remaining = 20;
        private int bold = 5;
        private int linger = 20;

        public DPSInstance(LivingEntity damaged, CustomDamageType type, double damage, double mitigated, boolean crit) {
            this.damaged = damaged;
            this.type = type;
            this.damage = damage;
            this.mitigated = mitigated;
            this.id = UUID.randomUUID();
            ChunkEXPNerf.increment(damaged.getLocation().getChunk(), null, "damage_indicator_limiter");
            int n = this.priority = damageIndicatorMap.get(damaged.getUniqueId()) == null ? 0 : damageIndicatorMap.get(damaged.getUniqueId()).size();
            if (format != null) {
                String mitigationString;
                this.isCrit = crit;
                String string = mitigated < -0.05 || mitigated > 0.05 ? String.format("(%s%,.1f)", mitigated > 0.0 ? "+" : "", mitigated) : (mitigationString = "");
                List<String> lines = Utils.chat(List.of("&l" + format.replace("%icon%", ValhallaMMO.isResourcePackConfigForced() ? type.getHardCodedIndicatorIcon() : (type.getIndicatorIcon() == null ? "" : type.getIndicatorIcon())).replace("%dps%", String.format("%,.1f", damage)).replace("%mitigated%", mitigationString).replace("%crit%", !this.isCrit || critFormat == null ? "" : critFormat)));
                this.display = (TextDisplay)damaged.getWorld().spawn(damaged.getEyeLocation().add(0.0, 0.5 + (double)this.priority * 0.2435, 0.0), TextDisplay.class);
                this.display.setBillboard(Display.Billboard.CENTER);
                this.display.setText(String.join((CharSequence)"\n", lines));
                this.display.setAlignment(TextDisplay.TextAlignment.LEFT);
                this.display.setPersistent(false);
                this.display.setSeeThrough(true);
                this.display.setInterpolationDuration(10);
                Entity lastDamager = EntityDamagedListener.getLastDamager(damaged);
                if (lastDamager instanceof Player) {
                    Player p = (Player)lastDamager;
                    if (actionBarFormat != null) {
                        Utils.sendActionBar(p, "&l" + actionBarFormat.replace("%icon%", ValhallaMMO.isResourcePackConfigForced() ? type.getHardCodedIndicatorIcon() : (type.getIndicatorIcon() == null ? "" : type.getIndicatorIcon())).replace("%dps%", String.format("%,.1f", damage)).replace("%mitigated%", mitigationString).replace("%crit%", !this.isCrit || critFormat == null ? "" : critFormat));
                    }
                }
            }
        }

        public void update(double damage, double mitigated, boolean crit) {
            block2: {
                block1: {
                    if (this.remaining <= 0) break block1;
                    this.damage += damage;
                    this.mitigated += mitigated;
                    this.bold = 5;
                    this.linger = 20;
                    this.isCrit = crit;
                    Entity lastDamager = EntityDamagedListener.getLastDamager(this.damaged);
                    if (!(lastDamager instanceof Player)) break block2;
                    Player p = (Player)lastDamager;
                    if (actionBarFormat == null) break block2;
                    Utils.sendActionBar(p, "&l" + actionBarFormat.replace("%icon%", ValhallaMMO.isResourcePackConfigForced() ? this.type.getHardCodedIndicatorIcon() : (this.type.getIndicatorIcon() == null ? "" : this.type.getIndicatorIcon())).replace("%dps%", String.format("%,.1f", this.damage)).replace("%mitigated%", this.mitigated < 0.05 || this.mitigated > 0.05 ? String.format("(%,.1f)", this.mitigated) : "").replace("%crit%", !this.isCrit || critFormat == null ? "" : critFormat));
                    break block2;
                }
                Map instances = damageIndicatorMap.getOrDefault(this.damaged.getUniqueId(), new TreeMap());
                DPSInstance existingInstance = (DPSInstance)((Object)instances.get(this.type));
                expiredInstances.put(existingInstance.id, existingInstance);
                DPSInstance newInstance = new DPSInstance(this.damaged, this.type, damage, mitigated, crit);
                instances.put(this.type, newInstance);
                damageIndicatorMap.put(this.damaged.getUniqueId(), instances);
                newInstance.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
                int index = 0;
                for (CustomDamageType type : damageIndicatorMap.get(this.damaged.getUniqueId()).keySet()) {
                    TextDisplayDPSIndicator.damageIndicatorMap.get((Object)this.damaged.getUniqueId()).get((Object)type).priority = index++;
                }
            }
        }

        public void run() {
            if (format == null || !this.damaged.isValid() || this.damaged.isDead()) {
                damageIndicatorMap.remove(this.damaged.getUniqueId());
                this.display.remove();
                this.cancel();
                ChunkEXPNerf.increment(this.damaged.getLocation().getChunk(), null, "damage_indicator_limiter", -1);
                return;
            }
            List<String> lines = Utils.chat(List.of((this.bold > 0 ? "&l" : "") + format.replace("%icon%", ValhallaMMO.isResourcePackConfigForced() ? this.type.getHardCodedIndicatorIcon() : (this.type.getIndicatorIcon() == null ? "" : this.type.getIndicatorIcon())).replace("%dps%", String.format("%s%,.1f", this.bold > 0 ? "&l" : "", this.damage)).replace("%mitigated%", this.mitigated < 0.05 || this.mitigated > 0.05 ? String.format("(%s%,.1f)", this.bold > 0 ? "&l" : "", this.mitigated) : "").replace("%crit%", !this.isCrit || critFormat == null ? "" : critFormat)));
            if (this.bold > 0) {
                this.display.setText(String.join((CharSequence)"\n", lines));
                this.display.teleport(this.damaged.getEyeLocation().add(0.0, 0.5 + (double)this.priority * 0.2435, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
                --this.bold;
            } else if (this.linger > 0) {
                this.isCrit = false;
                this.display.setText(String.join((CharSequence)"\n", lines));
                this.display.teleport(this.damaged.getEyeLocation().add(0.0, 0.5 + (double)this.priority * 0.2435 + (double)(20 - this.linger) * 0.03, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
                --this.linger;
            } else {
                this.display.remove();
                this.cancel();
                ChunkEXPNerf.increment(this.damaged.getLocation().getChunk(), null, "damage_indicator_limiter", -1);
                expiredInstances.remove(this.id);
                damageIndicatorMap.get(this.damaged.getUniqueId()).remove(this.type, (Object)this);
                int index = 0;
                for (CustomDamageType type : damageIndicatorMap.get(this.damaged.getUniqueId()).keySet()) {
                    TextDisplayDPSIndicator.damageIndicatorMap.get((Object)this.damaged.getUniqueId()).get((Object)type).priority = index++;
                }
                return;
            }
            if (this.remaining <= 0 && !expiredInstances.containsKey(this.id)) {
                expiredInstances.put(this.id, this);
                damageIndicatorMap.get(this.damaged.getUniqueId()).remove(this.type, (Object)this);
            }
            --this.remaining;
        }
    }
}

