/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.BlastingRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.BrewingRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.CampfireRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.CauldronRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.DisabledRecipesCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.FurnaceRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.GridRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.ImmersiveRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.RecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.SmithingRecipeCategory;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.SmokingRecipeCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class RecipeOverviewMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    public static final NamespacedKey KEY_RECIPE_CATEGORY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_recipe_category");
    public static final NamespacedKey KEY_RECIPE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_recipe");
    public static final RecipeCategory DISABLED = new DisabledRecipesCategory(4);
    public static final RecipeCategory CRAFTING_TABLE = new GridRecipeCategory(10);
    public static final RecipeCategory FURNACE = new FurnaceRecipeCategory(13);
    public static final RecipeCategory IMMERSIVE = new ImmersiveRecipeCategory(16);
    public static final RecipeCategory BREWING = new BrewingRecipeCategory(19);
    public static final RecipeCategory BLASTING = new BlastingRecipeCategory(22);
    public static final RecipeCategory CAULDRON = new CauldronRecipeCategory(25);
    public static final RecipeCategory SMITHING = new SmithingRecipeCategory(28);
    public static final RecipeCategory SMOKING = new SmokingRecipeCategory(31);
    public static final RecipeCategory CAMPFIRE = new CampfireRecipeCategory(40);
    private static final Map<String, RecipeCategory> categories = new HashMap<String, RecipeCategory>();
    private static final ItemStack filler;
    private static final ItemStack createNewButton;
    private static final ItemStack nextPageButton;
    private static final ItemStack previousPageButton;
    private static final ItemStack backToMenuButton;
    private int currentPage = 0;
    private RecipeCategory currentCategory = null;
    private static final Map<String, List<ItemStack>> cachedButtons;

    public static void registerCategory(RecipeCategory category) {
        categories.put(category.getId(), category);
    }

    public static Map<String, RecipeCategory> getCategories() {
        return new HashMap<String, RecipeCategory>(categories);
    }

    public RecipeOverviewMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public RecipeOverviewMenu(PlayerMenuUtility playerMenuUtility, String category) {
        super(playerMenuUtility);
        this.currentCategory = categories.get(category);
    }

    @Override
    public String getMenuName() {
        return this.currentCategory == null ? Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf303\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_recipeoverview")) : Utils.chat(this.currentCategory.getTitle());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedCategory;
        String clickedRecipe;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility).open();
                    return;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the recipe's name be? (type in chat, or 'cancel' to cancel)", s -> !CustomRecipeRegistry.getAllRecipes().contains(s), "&cRecipe with this name already exists! Try again")}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer().replaceAll(" ", "_").toLowerCase(Locale.US);
                                if (answer.contains("cancel")) {
                                    RecipeOverviewMenu.this.playerMenuUtility.getPreviousMenu().open();
                                } else if (CustomRecipeRegistry.getAllRecipes().contains(answer)) {
                                    Utils.sendMessage((CommandSender)this.getWho(), TranslationManager.getTranslation("error_command_recipe_exists"));
                                } else {
                                    RecipeOverviewMenu.this.currentCategory.createNew(answer, (Player)p);
                                }
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                    break;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                }
            }
        }
        if (!StringUtils.isEmpty(clickedRecipe = ItemUtils.getPDCString(KEY_RECIPE, clickedItem, null))) {
            if (e.getClick() == ClickType.MIDDLE) {
                if (ExportCommand.prepareOrUnprepareItem(clickedRecipe)) {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aPrepared " + clickedRecipe + " for exporting");
                } else {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cRemoved " + clickedRecipe + " from exporting");
                }
            } else if (this.currentCategory != null) {
                this.currentCategory.onRecipeButtonClick(clickedRecipe, (Player)e.getWhoClicked());
            }
        }
        if (!StringUtils.isEmpty(clickedCategory = ItemUtils.getPDCString(KEY_RECIPE_CATEGORY, clickedItem, ""))) {
            this.currentCategory = categories.get(clickedCategory);
            if (this.currentCategory != null) {
                new RecipeOverviewMenu(this.playerMenuUtility, this.currentCategory.getId()).open();
                return;
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (this.currentCategory != null) {
            this.setPickRecipeView();
        } else {
            this.setViewCategoriesView();
        }
    }

    private void setPickRecipeView() {
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 45; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.buildButtons(c -> {
            Map pages = Utils.paginate(45, c);
            this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
            if (!pages.isEmpty()) {
                pages.get(this.currentPage - 1).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
            }
        });
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, nextPageButton);
    }

    private void buildButtons(ItemBuilderCallback callback) {
        List<ItemStack> recipes = cachedButtons.get(this.currentCategory.getId());
        if (recipes == null) {
            recipes = this.currentCategory.getRecipeButtons();
            if (!this.currentCategory.equals(DISABLED)) {
                recipes.add(createNewButton);
            }
            cachedButtons.put(this.currentCategory.getId(), recipes);
        }
        callback.onItemsBuilt(recipes);
    }

    public static void resetCache(String category) {
        cachedButtons.remove(category);
        DynamicModifierMenu.resetCache();
    }

    private void setViewCategoriesView() {
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        for (RecipeCategory category : categories.values()) {
            this.inventory.setItem(category.getPosition(), new ItemBuilder(category.getIcon()).stringTag(KEY_RECIPE_CATEGORY, category.getId()).get());
        }
    }

    static {
        RecipeOverviewMenu.registerCategory(DISABLED);
        RecipeOverviewMenu.registerCategory(CRAFTING_TABLE);
        RecipeOverviewMenu.registerCategory(FURNACE);
        RecipeOverviewMenu.registerCategory(IMMERSIVE);
        RecipeOverviewMenu.registerCategory(BREWING);
        RecipeOverviewMenu.registerCategory(BLASTING);
        RecipeOverviewMenu.registerCategory(CAULDRON);
        RecipeOverviewMenu.registerCategory(SMITHING);
        RecipeOverviewMenu.registerCategory(SMOKING);
        RecipeOverviewMenu.registerCategory(CAMPFIRE);
        filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
        createNewButton = new ItemBuilder(RecipeOverviewMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lNew").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        nextPageButton = new ItemBuilder(RecipeOverviewMenu.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(KEY_ACTION, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        previousPageButton = new ItemBuilder(RecipeOverviewMenu.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(KEY_ACTION, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        backToMenuButton = new ItemBuilder(RecipeOverviewMenu.getButtonData("editor_backtomenu", Material.BOOK)).name("&fBack to Menu").stringTag(KEY_ACTION, "backToMenuButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        cachedButtons = new HashMap<String, List<ItemStack>>();
    }

    private static interface ItemBuilderCallback {
        public void onItemsBuilt(List<ItemStack> var1);
    }
}

