/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetLootPredicatesMenu;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.LootPredicateMenu;
import me.athlaeos.valhallammo.gui.implementations.ReplacementPoolEditor;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementEntry;
import me.athlaeos.valhallammo.loot.ReplacementPool;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ReplacementEntryEditor
extends Menu
implements SetModifiersMenu,
SetLootPredicatesMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int predicatesIndex = 1;
    private static final int predicateTypeIndex = 2;
    private static final int dropIndex = 4;
    private static final int tinkerIndex = 6;
    private static final int chanceWeightBaseIndex3 = 19;
    private static final int chanceWeightBaseIndex2 = 20;
    private static final int chanceWeightBaseIndex1 = 21;
    private static final int chanceWeightLuckIndex1 = 23;
    private static final int chanceWeightLuckIndex2 = 24;
    private static final int chanceWeightLuckIndex3 = 25;
    private static final int chanceWeightLootingIndex1 = 14;
    private static final int chanceWeightLootingIndex2 = 15;
    private static final int chanceWeightLootingIndex3 = 16;
    private static final int modifierIndex = 40;
    private static final int deleteIndex = 45;
    private static final int backToMenuIndex = 53;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final ReplacementTable table;
    private final ReplacementPool pool;
    private final ReplacementEntry entry;
    private static final ItemStack togglePredicateModeButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_predicatemode", Material.COMPARATOR)).name("&eFilter Mode").stringTag(BUTTON_ACTION_KEY, "togglePredicateModeButton").lore("&7Determines to what extent filters", "&7should pass.", "&7Should all filters pass", "&7or should any filter pass?", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack modifierButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_entry_modifiers", Material.WRITABLE_BOOK)).name("&dDynamic Item Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack tinkerToggleButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_toggletinker", Material.ANVIL)).name("&eAnvil").stringTag(BUTTON_ACTION_KEY, "tinkerToggleButton").lore("&7If tinkering is enabled, the", "&7replacement table will instead of", "&7replacing loot with another item", "&7tinker said items without replacing").get();
    private static final ItemStack predicatesButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_entry_predicates", Material.WRITABLE_BOOK)).name("&bFilter").stringTag(BUTTON_ACTION_KEY, "predicatesButton").lore("&7The filter decides if this entry", "&7is capable of dropping based on", "&7conditions.", "&eClick to open the menu", "&8&m                <>                ", "%predicates%").get();
    private static final ItemStack setWeightButton1 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton1").lore("&7Determines the weight for this", "&7entry. The higher the weight, the", "&7higher the chance for it to be used. ", "&7Drop chance per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 1", "&eShift-Click to change by 10").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setWeightButton2 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton2").lore("&7Determines the weight for this", "&7entry. The higher the weight, the", "&7higher the chance for it to be used. ", "&7Drop chance per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 100", "&eShift-Click to change by 1000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setWeightButton3 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton3").lore("&7Determines the weight for this", "&7entry. The higher the weight, the", "&7higher the chance for it to be used. ", "&7Drop chance per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 10000", "&eShift-Click to change by 100000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton1 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton1").lore("&7Determines the extra weight for", "&7this entry per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7entry will be selected", "&eClick to change by 1", "&eShift-Click to change by 10").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton2 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton2").lore("&7Determines the extra weight for", "&7this entry per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7entry will be selected", "&eClick to change by 100", "&eShift-Click to change by 1000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton3 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton3").lore("&7Determines the extra weight for", "&7this entry per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7entry will be selected", "&eClick to change by 10000", "&eShift-Click to change by 100000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setLootingWeightButton1 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Looting Weight: ").stringTag(BUTTON_ACTION_KEY, "setLootingWeightButton1").lore("&7Determines the extra weight for", "&7this entry per level of looting", "&7or fortune. The more of these enchant levels", "&7the player has, this more likely this", "&7entry will be selected", "&eClick to change by 1", "&eShift-Click to change by 10").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setLootingWeightButton2 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Looting Weight: ").stringTag(BUTTON_ACTION_KEY, "setLootingWeightButton2").lore("&7Determines the extra weight for", "&7this entry per level of looting", "&7or fortune. The more of these enchant levels", "&7the player has, this more likely this", "&7entry will be selected", "&eClick to change by 100", "&eShift-Click to change by 1000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setLootingWeightButton3 = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Looting Weight: ").stringTag(BUTTON_ACTION_KEY, "setLootingWeightButton3").lore("&7Determines the extra weight for", "&7this entry per level of looting", "&7or fortune. The more of these enchant levels", "&7the player has, this more likely this", "&7entry will be selected", "&eClick to change by 10000", "&eShift-Click to change by 100000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).get();
    private static final ItemStack backToMenuButton = new ItemBuilder(ReplacementEntryEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private boolean confirmDeletion = false;
    private int page = 0;

    public ReplacementEntryEditor(PlayerMenuUtility playerMenuUtility, ReplacementPool parent, ReplacementEntry entry) {
        super(playerMenuUtility);
        this.entry = entry;
        this.pool = parent;
        this.table = LootTableRegistry.getReplacementTables().get(this.pool.getParentTable());
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf319" : TranslationManager.getTranslation("editormenu_lootentry"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        if (this.table == null) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cReplacement Table has already been deleted");
            e.getWhoClicked().closeInventory();
            return;
        }
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new ReplacementPoolEditor(this.playerMenuUtility, this.pool).open();
                    LootTableRegistry.resetReplacementTableCache();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "predicatesButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new LootPredicateMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "togglePredicateModeButton": {
                    int currentMode = Arrays.asList(LootTable.PredicateSelection.values()).indexOf((Object)this.entry.getPredicateSelection());
                    currentMode = e.getClick().isLeftClick() ? (currentMode + 1 >= LootTable.PredicateSelection.values().length ? 0 : ++currentMode) : (currentMode - 1 < 0 ? LootTable.PredicateSelection.values().length - 1 : --currentMode);
                    this.entry.setPredicateSelection(LootTable.PredicateSelection.values()[currentMode]);
                    break;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this loot pool?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    this.pool.getEntries().remove(this.entry.getUuid());
                    new ReplacementPoolEditor(this.playerMenuUtility, this.pool).open();
                    LootTableRegistry.resetReplacementTableCache();
                    return;
                }
                case "tinkerToggleButton": {
                    this.entry.setTinker(!this.entry.tinker());
                    break;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "setWeightButton1": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1)));
                    break;
                }
                case "setWeightButton2": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
                    break;
                }
                case "setWeightButton3": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000 : 10000)));
                    break;
                }
                case "setBonusWeightButton1": {
                    this.entry.setWeightBonusLuck(this.entry.getWeightBonusLuck() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1)));
                    break;
                }
                case "setBonusWeightButton2": {
                    this.entry.setWeightBonusLuck(this.entry.getWeightBonusLuck() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
                    break;
                }
                case "setBonusWeightButton3": {
                    this.entry.setWeightBonusLuck(this.entry.getWeightBonusLuck() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000 : 10000)));
                    break;
                }
                case "setLootingWeightButton1": {
                    this.entry.setWeightBonusLooting(this.entry.getWeightBonusLooting() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1)));
                    break;
                }
                case "setLootingWeightButton2": {
                    this.entry.setWeightBonusLooting(this.entry.getWeightBonusLooting() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
                    break;
                }
                case "setLootingWeightButton3": {
                    this.entry.setWeightBonusLooting(this.entry.getWeightBonusLooting() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000 : 10000)));
                }
            }
        } else if (!ItemUtils.isEmpty(cursor) && e.getRawSlot() == 4) {
            this.entry.setReplaceBy(cursor.clone());
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ItemBuilder dropIcon = new ItemBuilder(this.entry.tinker() ? this.pool.getToReplace().getItem() : this.entry.getReplaceBy());
        if (this.entry.tinker()) {
            dropIcon.name(this.pool.getToReplace().getOption().ingredientDescription(this.pool.getToReplace().getItem()));
        }
        if (!this.entry.getPredicates().isEmpty()) {
            dropIcon.appendLore("&6" + (this.entry.getPredicateSelection() == LootTable.PredicateSelection.ANY ? "Any" : "All") + "&e of the following conditions");
            dropIcon.appendLore("&emust pass:");
            this.entry.getPredicates().forEach(pr -> dropIcon.appendLore(StringUtils.separateStringIntoLines("&f> " + pr.getActiveDescription(), 40)));
        }
        double combinedWeight = this.pool.getEntries().values().stream().mapToDouble(ReplacementEntry::getWeight).sum();
        dropIcon.appendLore("&eWeight: " + this.entry.getWeight() + (this.entry.getWeightBonusLooting() > 0.0 ? String.format(" (+%.1f/fortune)", this.entry.getWeightBonusLooting()) : "") + (this.entry.getWeightBonusLuck() > 0.0 ? String.format(" (+%.1f/luck)", this.entry.getWeightBonusLuck()) : ""), "&6With a combined weight of " + combinedWeight, String.format("&6this has a %.1f%% chance of", this.entry.getWeight() / combinedWeight * 100.0), "&6dropping per roll (ignoring luck and fortune)");
        ArrayList<String> predicateLore = new ArrayList<String>();
        this.pool.getPredicates().forEach(p -> predicateLore.addAll(StringUtils.separateStringIntoLines("&d> " + p.getActiveDescription(), 40)));
        ItemBuilder predicateIcon = new ItemBuilder(predicatesButton).placeholderLore("%predicates%", predicateLore);
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.entry.getModifiers().forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ItemBuilder modifierIcon = new ItemBuilder(modifierButton).placeholderLore("%modifiers%", modifierLore);
        ItemBuilder itemBuilder = new ItemBuilder(togglePredicateModeButton);
        this.inventory.setItem(2, itemBuilder.name("&eFilter Mode: " + (switch (this.pool.getPredicateSelection()) {
            default -> throw new IncompatibleClassChangeError();
            case LootTable.PredicateSelection.ALL -> "&aALL conditions must pass";
            case LootTable.PredicateSelection.ANY -> "&aANY condition must pass";
        })).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(53, backToMenuButton);
        this.inventory.setItem(1, predicateIcon.get());
        this.inventory.setItem(40, modifierIcon.get());
        this.inventory.setItem(4, dropIcon.get());
        this.inventory.setItem(6, new ItemBuilder(tinkerToggleButton).name("&eTinker drop: " + (this.entry.tinker() ? "&6Yes" : "&7No")).get());
        this.inventory.setItem(21, new ItemBuilder(setWeightButton1).name("&eWeight: " + this.entry.getWeight()).get());
        this.inventory.setItem(20, new ItemBuilder(setWeightButton2).name("&eWeight: " + this.entry.getWeight()).get());
        this.inventory.setItem(19, new ItemBuilder(setWeightButton3).name("&eWeight: " + this.entry.getWeight()).get());
        this.inventory.setItem(23, new ItemBuilder(setBonusWeightButton1).name("&eBonus Weight: +" + this.entry.getWeightBonusLuck() + "/luck").get());
        this.inventory.setItem(24, new ItemBuilder(setBonusWeightButton2).name("&eBonus Weight: +" + this.entry.getWeightBonusLuck() + "/luck").get());
        this.inventory.setItem(25, new ItemBuilder(setBonusWeightButton3).name("&eBonus Weight: +" + this.entry.getWeightBonusLuck() + "/luck").get());
        this.inventory.setItem(14, new ItemBuilder(setLootingWeightButton1).name("&eBonus Weight: +" + this.entry.getWeightBonusLooting() + "/looting").get());
        this.inventory.setItem(15, new ItemBuilder(setLootingWeightButton2).name("&eBonus Weight: +" + this.entry.getWeightBonusLooting() + "/looting").get());
        this.inventory.setItem(16, new ItemBuilder(setLootingWeightButton3).name("&eBonus Weight: +" + this.entry.getWeightBonusLooting() + "/looting").get());
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.entry.setModifiers(resultModifiers);
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.entry.getModifiers();
    }

    @Override
    public void setPredicates(Collection<LootPredicate> predicates) {
    }

    @Override
    public Collection<LootPredicate> getPredicates() {
        return this.entry.getPredicates();
    }
}

