/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.hooks;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOptionRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.NexoChoice;
import me.athlaeos.valhallammo.hooks.PluginHook;
import org.bukkit.inventory.ItemStack;

public class NexoHook
extends PluginHook {
    private static boolean hookInitialized = false;

    public NexoHook() {
        super("Nexo");
    }

    @Override
    public void whenPresent() {
        RecipeOptionRegistry.registerOption(new NexoChoice());
        ValhallaMMO.logInfo("Registered Nexo compatibility - hook will initialize when needed");
    }

    public static String getNexoId(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            if (!hookInitialized) {
                NexoHook.initializeHook();
            }
            if (!hookInitialized) {
                return null;
            }
            Class<?> nexoItemsClass = Class.forName("com.nexomc.nexo.api.NexoItems");
            Object result = nexoItemsClass.getMethod("idFromItem", ItemStack.class).invoke(null, item);
            return (String)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void initializeHook() {
        try {
            Class.forName("com.nexomc.nexo.api.NexoItems");
            hookInitialized = true;
        }
        catch (Exception e) {
            ValhallaMMO.logWarning("Failed to initialize Nexo hook: " + e.getMessage());
            hookInitialized = false;
        }
    }

    public static boolean isHookFunctional() {
        return ValhallaMMO.getInstance().getServer().getPluginManager().getPlugin("Nexo") != null;
    }
}

