/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.item.ArmorSet;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.persistence.GsonAdapter;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArmorSetRegistry {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(DynamicItemModifier.class, new GsonAdapter("MOD_TYPE")).registerTypeAdapter(AttributeWrapper.class, new GsonAdapter("ATTRIBUTE_TYPE")).setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();
    private static final NamespacedKey ARMOR_SET = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "armor_set");
    private static final Map<String, ArmorSet> registeredSets = new HashMap<String, ArmorSet>();

    public static void register(ArmorSet set) {
        registeredSets.put(set.getId(), set);
    }

    public static Map<String, ArmorSet> getRegisteredSets() {
        return registeredSets;
    }

    public static void loadFromFile(File f) {
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedReader setsReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
            ArmorSet[] sets = (ArmorSet[])gson.fromJson((Reader)setsReader, ArmorSet[].class);
            if (sets == null) {
                return;
            }
            for (ArmorSet set : sets) {
                ArmorSetRegistry.register(set);
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaMMO.logSevere("Could not load armor sets from armor_sets.json, " + exception.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void saveArmorSets() {
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/armor_sets.json");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));){
            JsonElement element = gson.toJsonTree(new ArrayList<ArmorSet>(registeredSets.values()), new TypeToken<ArrayList<ArmorSet>>(){}.getType());
            gson.toJson(element, (Appendable)writer);
            writer.flush();
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaMMO.logSevere("Could not save armor sets to armor_sets.json, " + exception.getMessage());
        }
    }

    public static void setArmorSet(ItemBuilder item, ArmorSet set) {
        for (ArmorSet s : registeredSets.values()) {
            if (item.getLore() == null) continue;
            item.getLore().remove(Utils.chat(s.getName()));
            item.getLore().removeAll(Utils.chat(s.getLore()));
        }
        if (set == null) {
            item.getMeta().getPersistentDataContainer().remove(ARMOR_SET);
        } else {
            item.stringTag(ARMOR_SET, set.getId());
            if (set.getName() != null) {
                item.appendLore(set.getName());
            }
            if (set.getLore() != null) {
                item.appendLore(set.getLore());
            }
        }
    }

    public static ArmorSet getArmorSet(ItemMeta meta) {
        return registeredSets.get(meta.getPersistentDataContainer().getOrDefault(ARMOR_SET, PersistentDataType.STRING, (Object)""));
    }

    private static void updateItem(ItemBuilder reference, ItemStack i, boolean remove) {
        if (reference == null || ItemUtils.isEmpty(i)) {
            return;
        }
        ArmorSet itemSet = ArmorSetRegistry.getArmorSet(reference.getMeta());
        if (itemSet == null) {
            return;
        }
        ItemMeta meta = i.getItemMeta();
        if (meta == null) {
            return;
        }
        List<String> lore = ItemUtils.getLore(meta);
        List<String> itemSetLore = Utils.chat(itemSet.getLore());
        if (remove) {
            lore.removeAll(itemSetLore);
        } else if (!itemSetLore.isEmpty() && !new HashSet<String>(lore).containsAll(itemSetLore)) {
            if (itemSet.getName() != null && lore.contains(Utils.chat(itemSet.getName()))) {
                int index = lore.indexOf(Utils.chat(itemSet.getName()));
                if (index == lore.size() - 1) {
                    lore.addAll(itemSetLore);
                } else {
                    lore.addAll(index, itemSetLore);
                }
            } else {
                lore.addAll(itemSetLore);
            }
        } else {
            return;
        }
        meta.setLore(lore);
        i.setItemMeta(meta);
    }

    public static Collection<ArmorSet> getActiveArmorSets(LivingEntity e) {
        EntityProperties properties = EntityCache.getAndCacheProperties(e);
        HashMap<ArmorSet, Integer> sets = new HashMap<ArmorSet, Integer>();
        for (ItemBuilder item : properties.getIterable(false, null)) {
            ArmorSet set = ArmorSetRegistry.getArmorSet(item.getMeta());
            if (set == null) continue;
            sets.put(set, sets.getOrDefault(set, 0) + 1);
        }
        return sets.isEmpty() ? Set.of() : (Collection)sets.entrySet().stream().filter(s -> (Integer)s.getValue() >= ((ArmorSet)s.getKey()).getPiecesRequired()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

