/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats.DefaultAttributeAdd;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats.DefaultAttributeRemove;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.item.item_attributes.implementations.AttributeDisplayWrapper;
import me.athlaeos.valhallammo.item.item_attributes.implementations.AttributeHiddenWrapper;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemAttributesRegistry {
    private static final NamespacedKey DEFAULT_STATS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "default_stats");
    private static final NamespacedKey ACTUAL_STATS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "actual_stats");
    private static final Map<Material, Map<String, AttributeWrapper>> vanillaAttributes = new HashMap<Material, Map<String, AttributeWrapper>>();
    private static final Map<String, AttributeWrapper> registeredAttributes = new HashMap<String, AttributeWrapper>();
    private static final Map<String, Double> attributePriorities = new HashMap<String, Double>();

    public static void registerAttributes() {
        ConfigurationSection section = ValhallaMMO.getPluginConfig().getConfigurationSection("attribute_stat_priorities");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                attributePriorities.put(key, ValhallaMMO.getPluginConfig().getDouble("attribute_stat_priorities." + key));
            }
        }
        ItemAttributesRegistry.register(new AttributeHiddenWrapper("CUSTOM_MAX_DURABILITY", StatFormat.INT));
        ModifierRegistry.register(new DefaultAttributeAdd("custom_durability_set", "CUSTOM_MAX_DURABILITY", 1.0, 25.0, Material.DIAMOND));
        ModifierRegistry.register(new DefaultAttributeRemove("custom_durability_remove", "CUSTOM_MAX_DURABILITY", Material.COAL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BOW_STRENGTH", StatFormat.PERCENTILE_BASE_1_P1, "\uee00", i -> i >= 0.0, Material.BOW, Material.CROSSBOW).addModifier(Material.BOW));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARROW_DAMAGE", StatFormat.FLOAT_P2, "\uee01", i -> i >= 0.0).addModifier(Material.ARROW, 0.01, 0.25));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("AMMO_CONSUMPTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee02", i -> i <= 0.0).max(0.0).addModifier(Material.SPECTRAL_ARROW));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARROW_VELOCITY", StatFormat.PERCENTILE_BASE_1_P1, "\uee03", i -> i >= 0.0).addModifier(Material.CROSSBOW));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARROW_ACCURACY", StatFormat.FLOAT_P2, "\uee04", i -> i >= 0.0).addModifier(Material.TARGET, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARROW_PIERCING", StatFormat.INT, "\uee05", i -> i >= 0.0).addModifier(Material.TIPPED_ARROW, 1.0, 5.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("KNOCKBACK", StatFormat.PERCENTILE_BASE_1_P1, "\uee06", i -> i >= 0.0).addModifier(Material.SLIME_BLOCK));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("STUN_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee07", i -> i >= 0.0).addModifier(Material.IRON_BLOCK));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BLEED_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee08", i -> i >= 0.0).addModifier(Material.GOLDEN_AXE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BLEED_DAMAGE", StatFormat.FLOAT_P2, "\uee09", i -> i >= 0.0).addModifier(Material.NETHERITE_AXE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BLEED_DURATION", StatFormat.TIME_SECONDS_BASE_20_P1, "\uee0a", i -> i >= 0.0).addModifier(Material.IRON_AXE, 20.0, 100.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CRIT_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee0b", i -> i >= 0.0).addModifier(Material.GOLDEN_SWORD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CRIT_DAMAGE", StatFormat.PERCENTILE_BASE_1_P1, "\uee0c", i -> i >= 0.0).addModifier(Material.IRON_SWORD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARMOR_PENETRATION_FLAT", StatFormat.FLOAT_P2, "\uee0d", i -> i >= 0.0).addModifier(Material.LEATHER_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIGHT_ARMOR_PENETRATION_FLAT", StatFormat.FLOAT_P2, "\uee0e", i -> i >= 0.0).addModifier(Material.CHAINMAIL_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("HEAVY_ARMOR_PENETRATION_FLAT", StatFormat.FLOAT_P2, "\uee0f", i -> i >= 0.0).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ARMOR_PENETRATION_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee10", i -> i >= 0.0).addModifier(Material.LEATHER_CHESTPLATE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIGHT_ARMOR_PENETRATION_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee11", i -> i >= 0.0).addModifier(Material.CHAINMAIL_CHESTPLATE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("HEAVY_ARMOR_PENETRATION_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee12", i -> i >= 0.0).addModifier(Material.IRON_CHESTPLATE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("HEAVY_ARMOR_DAMAGE", StatFormat.PERCENTILE_BASE_1_P1, "\uee13", i -> i >= 0.0).addModifier(Material.IRON_HELMET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIGHT_ARMOR_DAMAGE", StatFormat.PERCENTILE_BASE_1_P1, "\uee14", i -> i >= 0.0).addModifier(Material.CHAINMAIL_HELMET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("IMMUNITY_BONUS_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee15", i -> i >= 0.0).addModifier(Material.ENCHANTED_GOLDEN_APPLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("IMMUNITY_BONUS_FLAT", StatFormat.INT, "\uee16", i -> i >= 0.0).addModifier(Material.GOLDEN_APPLE, 1.0, 5.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("IMMUNITY_REDUCTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee17", i -> i >= 0.0).addModifier(Material.WITHER_ROSE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_UNARMED", StatFormat.PERCENTILE_BASE_1_P1, "\uee18", i -> i >= 0.0).addModifier(Material.BLAZE_POWDER));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_MELEE", StatFormat.PERCENTILE_BASE_1_P1, "\uee19", i -> i >= 0.0).addModifier(Material.DIAMOND_SWORD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_RANGED", StatFormat.PERCENTILE_BASE_1_P1, "\uee1a", i -> i >= 0.0).addModifier(Material.BOW));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_ALL", StatFormat.PERCENTILE_BASE_1_P1, "\uee1b", i -> i >= 0.0).addModifier(Material.BLAZE_ROD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ATTACK_REACH", StatFormat.DIFFERENCE_FLOAT_P2, "\uee1c", i -> i >= 0.0).addModifier(Material.ENDER_PEARL, 0.1, 1.0).convertTo("PLAYER_ENTITY_INTERACTION_RANGE"));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("VELOCITY_DAMAGE", StatFormat.PERCENTILE_BASE_1_P1, "\uee1d", i -> i >= 0.0).addModifier(Material.DIAMOND_HORSE_ARMOR));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DISMOUNT_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee1e", i -> i >= 0.0).addModifier(Material.SADDLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee1f", i -> i >= 0.0).addModifier(Material.IRON_INGOT));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXPLOSION_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee20", i -> i >= 0.0).addModifier(Material.TNT));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FALL_DAMAGE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee21", i -> i >= 0.0).addModifier(Material.LEATHER_BOOTS));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FIRE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee22", i -> i >= 0.0).addModifier(Material.LAVA_BUCKET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("MAGIC_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee23", i -> i >= 0.0).addModifier(Material.DRAGON_BREATH));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BLEED_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee24", i -> i >= 0.0).addModifier(Material.REDSTONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("STUN_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee25", i -> i >= 0.0).addModifier(Material.NETHERITE_HELMET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("POISON_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee26", i -> i >= 0.0).addModifier(Material.SPIDER_EYE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("PROJECTILE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee27", i -> i >= 0.0).addModifier(Material.ARROW));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("MELEE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee28", i -> i >= 0.0).addModifier(Material.SHIELD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DODGE_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee29", i -> i >= 0.0).addModifier(Material.LEATHER_LEGGINGS));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("HEALING_BONUS", StatFormat.PERCENTILE_BASE_1_P1, "\uee2a", i -> i >= 0.0).addModifier(Material.GLISTERING_MELON_SLICE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FOOD_CONSUMPTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee2b", i -> i <= 0.0).addModifier(Material.APPLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("COOLDOWN_REDUCTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee2c", i -> i >= 0.0).addModifier(Material.CLOCK));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXPLOSION_POWER", StatFormat.PERCENTILE_BASE_1_P1, "\uee2d", i -> i >= 0.0).addModifier(Material.TNT_MINECART));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CRAFTING_SPEED", StatFormat.PERCENTILE_BASE_1_P1, "\uee2e", i -> i >= 0.0).addModifier(Material.CRAFTING_TABLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ALCHEMY_QUALITY", StatFormat.INT, "\uee2f", i -> i >= 0.0).addModifier(Material.BREWING_STAND, 1.0, 10.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ALCHEMY_QUALITY_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee30", i -> i >= 0.0).addModifier(Material.BREWING_STAND));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENCHANTING_QUALITY", StatFormat.INT, "\uee31", i -> i >= 0.0).addModifier(Material.ENCHANTING_TABLE, 1.0, 10.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENCHANTING_QUALITY_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee32", i -> i >= 0.0).addModifier(Material.ENCHANTING_TABLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ANVIL_QUALITY_FLAT", StatFormat.INT, "\uee33", i -> i >= 0.0).addModifier(Material.ANVIL, 1.0, 10.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ANVIL_QUALITY_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee34", i -> i >= 0.0).addModifier(Material.ANVIL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BREWING_INGREDIENT_CONSUMPTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee35", i -> i <= 0.0).addModifier(Material.GLASS_BOTTLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BREWING_SPEED", StatFormat.PERCENTILE_BASE_1_P1, "\uee36", i -> i >= 0.0).addModifier(Material.BLAZE_ROD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("POTION_CONSUMPTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee37", i -> i <= 0.0).addModifier(Material.SPLASH_POTION));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("THROWING_VELOCITY", StatFormat.PERCENTILE_BASE_1_P1, "\uee38", i -> i >= 0.0).addModifier(Material.SNOWBALL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SMITHING_QUALITY", StatFormat.INT, "\uee39", i -> i >= 0.0).addModifier(Material.ANVIL, 1.0, 10.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SMITHING_QUALITY_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee3a", i -> i >= 0.0).addModifier(Material.ANVIL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("MINING_RARE_DROPS", StatFormat.FLOAT_P2, "\uee3b", i -> i >= 0.0).addModifier(Material.GOLDEN_PICKAXE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("MINING_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee3c", i -> i >= 0.0).addModifier(Material.IRON_PICKAXE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("WOODCUTTING_RARE_DROPS", StatFormat.FLOAT_P2, "\uee3d", i -> i >= 0.0).addModifier(Material.GOLDEN_AXE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("WOODCUTTING_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee3e", i -> i >= 0.0).addModifier(Material.IRON_AXE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DIGGING_RARE_DROPS", StatFormat.FLOAT_P2, "\uee3f", i -> i >= 0.0).addModifier(Material.GOLDEN_SHOVEL, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DIGGING_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee40", i -> i >= 0.0).addModifier(Material.IRON_SHOVEL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FARMING_RARE_DROPS", StatFormat.FLOAT_P2, "\uee41", i -> i >= 0.0).addModifier(Material.GOLDEN_HOE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FARMING_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee42", i -> i >= 0.0).addModifier(Material.IRON_HOE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FISHING_LUCK", StatFormat.FLOAT_P2, "\uee43", i -> i >= 0.0).addModifier(Material.FISHING_ROD, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SKILL_EXP_GAIN", StatFormat.PERCENTILE_BASE_1_P1, "\uee44", i -> i >= 0.0).addModifier(Material.BOOK));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("VANILLA_EXP_GAIN", StatFormat.PERCENTILE_BASE_1_P1, "\uee45", i -> i >= 0.0).addModifier(Material.EXPERIENCE_BOTTLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_TAKEN", StatFormat.PERCENTILE_BASE_1_P1, "\uee46", i -> i <= 0.0).addModifier(Material.SKELETON_SKULL));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("REFLECT_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee47", i -> i >= 0.0).addModifier(Material.SHIELD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("REFLECT_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee48", i -> i >= 0.0).addModifier(Material.SHIELD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_LUCK", "\uee4f", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.RABBIT_FOOT, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_ARMOR", "\uee50", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_ARMOR_TOUGHNESS", "\uee52", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_ATTACK_DAMAGE", "\uee54", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.IRON_SWORD, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_ATTACK_SPEED", "\uee55", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_SWORD, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_KNOCKBACK_RESISTANCE", "\uee56", i -> i >= 0.0, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).setOperation(AttributeModifier.Operation.ADD_SCALAR).addModifier(Material.NETHERITE_CHESTPLATE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_MAX_HEALTH", "\uee57", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_APPLE, 0.01, 0.25));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_MOVEMENT_SPEED", "\uee59", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).setOperation(AttributeModifier.Operation.ADD_SCALAR).addModifier(Material.SUGAR));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SNEAK_MOVEMENT_SPEED_BONUS", StatFormat.PERCENTILE_BASE_1_P1, "\uee5c", i -> i >= 0.0).addModifier(Material.GOLDEN_BOOTS));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SPRINT_MOVEMENT_SPEED_BONUS", StatFormat.PERCENTILE_BASE_1_P1, "\uee5d", i -> i >= 0.0).addModifier(Material.LEATHER_BOOTS));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_EXPLOSION", StatFormat.PERCENTILE_BASE_1_P1, "\uee5e", i -> i >= 0.0).addModifier(Material.TNT_MINECART));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_FIRE", StatFormat.PERCENTILE_BASE_1_P1, "\uee5f", i -> i >= 0.0).addModifier(Material.FIRE_CHARGE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_MAGIC", StatFormat.PERCENTILE_BASE_1_P1, "\uee60", i -> i >= 0.0).addModifier(Material.SPLASH_POTION));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_POISON", StatFormat.PERCENTILE_BASE_1_P1, "\uee61", i -> i >= 0.0).addModifier(Material.SPIDER_EYE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_BLUDGEONING", StatFormat.PERCENTILE_BASE_1_P1, "\uee62", i -> i >= 0.0).addModifier(Material.COBBLESTONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_LIGHTNING", StatFormat.PERCENTILE_BASE_1_P1, "\uee63", i -> i >= 0.0).addModifier(Material.PRISMARINE_SHARD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_FREEZING", StatFormat.PERCENTILE_BASE_1_P1, "\uee64", i -> i >= 0.0).addModifier(Material.ICE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_RADIANT", StatFormat.PERCENTILE_BASE_1_P1, "\uee65", i -> i >= 0.0).addModifier(Material.GOLD_INGOT));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_NECROTIC", StatFormat.PERCENTILE_BASE_1_P1, "\uee66", i -> i >= 0.0).addModifier(Material.BONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("COOKING_SPEED", StatFormat.PERCENTILE_BASE_1_P1, "\uee67", i -> i >= 0.0).addModifier(Material.BLAST_FURNACE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("JUMP_HEIGHT", StatFormat.PERCENTILE_BASE_1_P1, "\uee68", i -> i >= 0.0).addModifier(Material.SLIME_BLOCK));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("JUMPS", StatFormat.INT, "\uee69", i -> i >= 0.0).addModifier(Material.STICKY_PISTON, 1.0, 3.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_EXPLOSION_DAMAGE", StatFormat.FLOAT_P2, "\uee6a", i -> i >= 0.0).addModifier(Material.TNT, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_FIRE_DAMAGE", StatFormat.FLOAT_P2, "\uee6b", i -> i >= 0.0).addModifier(Material.FIRE_CHARGE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_MAGIC_DAMAGE", StatFormat.FLOAT_P2, "\uee6c", i -> i >= 0.0).addModifier(Material.END_CRYSTAL, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_POISON_DAMAGE", StatFormat.FLOAT_P2, "\uee6d", i -> i >= 0.0).addModifier(Material.SPIDER_EYE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_BLUDGEONING_DAMAGE", StatFormat.FLOAT_P2, "\uee6e", i -> i >= 0.0).addModifier(Material.COBBLESTONE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_LIGHTNING_DAMAGE", StatFormat.FLOAT_P2, "\uee6f", i -> i >= 0.0).addModifier(Material.PRISMARINE_SHARD, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_FREEZING_DAMAGE", StatFormat.FLOAT_P2, "\uee70", i -> i >= 0.0).addModifier(Material.ICE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_RADIANT_DAMAGE", StatFormat.FLOAT_P2, "\uee71", i -> i >= 0.0).addModifier(Material.GOLD_INGOT, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("EXTRA_NECROTIC_DAMAGE", StatFormat.FLOAT_P2, "\uee72", i -> i >= 0.0).addModifier(Material.BONE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BLUDGEONING_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee73", i -> i >= 0.0).addModifier(Material.COBBLESTONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIGHTNING_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee74", i -> i >= 0.0).addModifier(Material.PRISMARINE_SHARD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FREEZING_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee75", i -> i >= 0.0).addModifier(Material.ICE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("RADIANT_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee76", i -> i >= 0.0).addModifier(Material.GOLD_INGOT));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("NECROTIC_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee77", i -> i >= 0.0).addModifier(Material.BONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DURABILITY_MULTIPLIER", StatFormat.PERCENTILE_BASE_1_P1, "\uee79", i -> i >= 0.0).addModifier(Material.DIAMOND));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENTITY_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee7a", i -> i >= 0.0).addModifier(Material.CHEST));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIGHT_ARMOR", StatFormat.FLOAT_P2, "\uee6b", i -> i >= 0.0).addModifier(Material.CHAINMAIL_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("HEAVY_ARMOR", StatFormat.FLOAT_P2, "\uee6c", i -> i >= 0.0).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CRIT_CHANCE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee6d", i -> i >= 0.0).addModifier(Material.REDSTONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CRIT_DAMAGE_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee6e", i -> i >= 0.0).addModifier(Material.REDSTONE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LAPIS_SAVE_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee8f", i -> i <= 0.0).addModifier(Material.LAPIS_LAZULI));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENCHANTING_REFUND_CHANCE", StatFormat.PERCENTILE_BASE_1_P1, "\uee90", i -> i >= 0.0).addModifier(Material.ENCHANTING_TABLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENCHANTING_REFUND_FRACTION", StatFormat.PERCENTILE_BASE_1_P1, "\uee91", i -> i >= 0.0).addModifier(Material.EXPERIENCE_BOTTLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LINGERING_DURATION_MULTIPLIER", StatFormat.PERCENTILE_BASE_1_P1, "\uee92", i -> i >= 0.0).addModifier(Material.LINGERING_POTION));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LINGERING_RADIUS_MULTIPLIER", StatFormat.PERCENTILE_BASE_1_P1, "\uee93", i -> i >= 0.0).addModifier(Material.LINGERING_POTION));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SPLASH_INTENSITY_MINIMUM", StatFormat.PERCENTILE_BASE_1_P1, "\uee94", i -> i >= 0.0).addModifier(Material.SPLASH_POTION));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ENTITY_RARE_DROPS", StatFormat.PERCENTILE_BASE_1_P1, "\uee95", i -> i >= 0.0).addModifier(Material.CHEST));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DIG_SPEED", StatFormat.PERCENTILE_BASE_1_P1, "\uee96", i -> i >= 0.0).addModifier(Material.DIAMOND_PICKAXE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("MINING_SPEED", StatFormat.FLOAT_P2, "\uee97", i -> i >= 0.0).addModifier(Material.GOLDEN_PICKAXE, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("CROSSBOW_MAGAZINE", StatFormat.INT, "\uee99", i -> i >= 0.0).addModifier(Material.CROSSBOW, 1.0, 5.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_SCALE", "\uee9a", i -> i >= 0.0, StatFormat.DIFFERENCE_FLOAT_P2, StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).setOperation(AttributeModifier.Operation.ADD_SCALAR).addModifier(Material.RED_MUSHROOM, 0.01, 0.1));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("PLAYER_BLOCK_INTERACTION_RANGE", "\uee9b", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.SCAFFOLDING, 0.01, 0.25));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_STEP_HEIGHT", "\uee9c", i -> i >= 0.0, StatFormat.FLOAT_P2, StatFormat.PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.RABBIT_FOOT, 0.01, 0.1));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_GRAVITY", "\ueea0", i -> i <= 0.0, StatFormat.DIFFERENCE_FLOAT_P2, StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.BEDROCK, 0.01, 0.1));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_SAFE_FALL_DISTANCE", "\ueea1", i -> i >= 0.0, StatFormat.DIFFERENCE_FLOAT_P2, StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.LEATHER_BOOTS, 0.01, 0.1));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("GENERIC_FALL_DAMAGE_MULTIPLIER", "\ueea2", i -> i <= 0.0, StatFormat.DIFFERENCE_FLOAT_P2, StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1, StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.NETHERITE_BOOTS, 0.01, 0.1));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("ATTACK_REACH_MULTIPLIER", StatFormat.PERCENTILE_BASE_1_P1, "\uee9d", i -> i >= 0.0).addModifier(Material.ENDER_PEARL, 0.1, 1.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SHIELD_DISARMING", StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1, "\uee9e", i -> i >= 0.0).addModifier(Material.NETHERITE_AXE, 1.0, 10.0));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("LIFE_STEAL", StatFormat.PERCENTILE_BASE_1_P2, "\uee9f", i -> i >= 0.0).addModifier(Material.GHAST_TEAR, 0.001, 0.01));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("PVP_RESISTANCE", StatFormat.PERCENTILE_BASE_1_P1, "\ueea3", i -> i >= 0.0).addModifier(Material.IRON_CHESTPLATE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_PLAYER", StatFormat.PERCENTILE_BASE_1_P1, "\ueea4", i -> i >= 0.0).addModifier(Material.IRON_SWORD));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_MOUNTED", StatFormat.PERCENTILE_BASE_1_P1, "\ueea5", i -> i >= 0.0).addModifier(Material.SADDLE));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("WATER_MOVEMENT_EFFICIENCY", StatFormat.PERCENTILE_BASE_1_P1, "\ueea6", i -> i >= 0.0).addModifier(Material.CONDUIT));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("SUBMERGED_MINING_SPEED", StatFormat.PERCENTILE_BASE_1_P1, "\ueea7", i -> i >= 0.0).addModifier(Material.HEART_OF_THE_SEA));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FLIGHT_SPEED_BONUS", StatFormat.PERCENTILE_BASE_1_P1, "\ueea8", i -> i >= 0.0).addModifier(Material.FEATHER));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("OXYGEN_BONUS", StatFormat.PERCENTILE_BASE_1_P1, "\ueea9", i -> i >= 0.0).addModifier(Material.TURTLE_HELMET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("BACK_PROTECTION", StatFormat.PERCENTILE_BASE_1_P1, "\ueeaa", i -> i >= 0.0).addModifier(Material.TURTLE_HELMET));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("FRONT_PROTECTION", StatFormat.PERCENTILE_BASE_1_P1, "\ueeab", i -> i >= 0.0).addModifier(Material.OBSERVER));
        ItemAttributesRegistry.register(new AttributeDisplayWrapper("DAMAGE_ABSORPTION", StatFormat.FLOAT_P2, "\ueeac", i -> i >= 0.0).addModifier(Material.OBSIDIAN));
        ItemAttributesRegistry.addVanillaStat(Material.WOODEN_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(4.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.WOODEN_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(2.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(2.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.WOODEN_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(2.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(2.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.WOODEN_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(7.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.8), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(2.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.WOODEN_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(2.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.STONE_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(5.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.STONE_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(4.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.STONE_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(3.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(4.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.STONE_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(9.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.8), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(4.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.STONE_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(2.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(4.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat("COPPER_SWORD", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(5.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat("COPPER_PICKAXE", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(5.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat("COPPER_SHOVEL", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(3.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(5.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat("COPPER_AXE", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(9.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.8), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(5.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat("COPPER_HOE", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(2.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(5.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(4.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(2.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(12.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(2.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(12.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(7.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.8), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(12.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(12.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(6.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(4.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(6.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(4.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(6.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(9.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.9), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(6.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(3.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(6.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(7.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(5.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(8.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(5.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(8.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(9.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(8.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(4.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(8.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_SWORD, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(8.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.6));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_PICKAXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(6.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.2), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(9.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_SHOVEL, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(6.5), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(9.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_AXE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(10.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(9.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_HOE, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(1.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(4.0), ItemAttributesRegistry.getCopy("MINING_SPEED").setValue(9.0).setHidden(true));
        ItemAttributesRegistry.addVanillaStat(Material.LEATHER_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.LEATHER_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0));
        ItemAttributesRegistry.addVanillaStat(Material.LEATHER_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.LEATHER_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.CHAINMAIL_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.CHAINMAIL_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(5.0));
        ItemAttributesRegistry.addVanillaStat(Material.CHAINMAIL_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(4.0));
        ItemAttributesRegistry.addVanillaStat(Material.CHAINMAIL_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(5.0));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0));
        ItemAttributesRegistry.addVanillaStat(Material.GOLDEN_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(6.0));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(5.0));
        ItemAttributesRegistry.addVanillaStat(Material.IRON_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat("COPPER_HELMET", ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat("COPPER_CHESTPLATE", ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(4.0));
        ItemAttributesRegistry.addVanillaStat("COPPER_LEGGINGS", ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0));
        ItemAttributesRegistry.addVanillaStat("COPPER_BOOTS", ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(8.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(6.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.DIAMOND_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_KNOCKBACK_RESISTANCE").setValue(0.1).setOperation(AttributeModifier.Operation.ADD_NUMBER));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_CHESTPLATE, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(8.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_KNOCKBACK_RESISTANCE").setValue(0.1).setOperation(AttributeModifier.Operation.ADD_NUMBER));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_LEGGINGS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(6.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_KNOCKBACK_RESISTANCE").setValue(0.1).setOperation(AttributeModifier.Operation.ADD_NUMBER));
        ItemAttributesRegistry.addVanillaStat(Material.NETHERITE_BOOTS, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_ARMOR_TOUGHNESS").setValue(3.0), ItemAttributesRegistry.getCopy("GENERIC_KNOCKBACK_RESISTANCE").setValue(0.1).setOperation(AttributeModifier.Operation.ADD_NUMBER));
        ItemAttributesRegistry.addVanillaStat(Material.TURTLE_HELMET, ItemAttributesRegistry.getCopy("GENERIC_ARMOR").setValue(2.0));
        ItemAttributesRegistry.addVanillaStat(Material.TRIDENT, ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(9.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(1.1));
        ItemAttributesRegistry.addVanillaStat(Material.BOW, ItemAttributesRegistry.getCopy("BOW_STRENGTH").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat(Material.CROSSBOW, ItemAttributesRegistry.getCopy("BOW_STRENGTH").setValue(1.0));
        ItemAttributesRegistry.addVanillaStat("MACE", ItemAttributesRegistry.getCopy("GENERIC_ATTACK_DAMAGE").setValue(6.0), ItemAttributesRegistry.getCopy("GENERIC_ATTACK_SPEED").setValue(0.6));
    }

    public static void reload() {
        registeredAttributes.clear();
        ItemAttributesRegistry.registerAttributes();
    }

    public static void register(AttributeWrapper wrapper) {
        registeredAttributes.put(wrapper.getAttribute(), wrapper);
    }

    public static void setDefaultStats(ItemBuilder item, Map<String, AttributeWrapper> stats) {
        if (item == null) {
            return;
        }
        if (stats == null || stats.isEmpty()) {
            ItemAttributesRegistry.clean(item);
            return;
        }
        item.stringTag(DEFAULT_STATS, ItemAttributesRegistry.serializeStats(stats.values()));
    }

    public static void clean(ItemBuilder item) {
        item.getMeta().getPersistentDataContainer().remove(DEFAULT_STATS);
        item.getMeta().getPersistentDataContainer().remove(ACTUAL_STATS);
        item.getMeta().setAttributeModifiers(null);
        registeredAttributes.values().forEach(a -> a.onRemove(item));
    }

    public static Map<String, AttributeWrapper> getStats(ItemMeta meta, boolean def) {
        HashMap<String, AttributeWrapper> attributes;
        block9: {
            block8: {
                attributes = new HashMap<String, AttributeWrapper>();
                if (meta == null) {
                    return attributes;
                }
                String stored = ItemUtils.getPDCString(def ? DEFAULT_STATS : ACTUAL_STATS, meta, null);
                if (StringUtils.isEmpty(stored)) break block8;
                for (String attributeDetails : stored.split(";")) {
                    String[] args = attributeDetails.split(":");
                    if (args.length < 2) continue;
                    try {
                        String attribute = args[0];
                        double value = StringUtils.parseDouble(args[1]);
                        AttributeModifier.Operation operation = args.length > 2 ? AttributeModifier.Operation.valueOf((String)args[2]) : AttributeModifier.Operation.ADD_NUMBER;
                        boolean hidden = args.length > 3 && args[3].equals("true");
                        AttributeWrapper wrapper = registeredAttributes.get(attribute);
                        if (wrapper == null) continue;
                        wrapper = wrapper.copy();
                        wrapper.setValue(value);
                        wrapper.setHidden(hidden);
                        wrapper.setOperation(operation);
                        attributes.put(attribute, wrapper);
                    }
                    catch (IllegalArgumentException attribute) {
                        // empty catch block
                    }
                }
                break block9;
            }
            Material type = ItemUtils.getStoredType(meta);
            if (type == null) break block9;
            Multimap otherAttributes = meta.getAttributeModifiers();
            if (otherAttributes == null) {
                attributes.putAll(ItemAttributesRegistry.getVanillaStats(type));
            } else {
                for (Attribute attribute : otherAttributes.keys()) {
                    AttributeWrapper wrapper;
                    AttributeMappings mapping = AttributeMappings.getAttributeMapping(attribute.toString());
                    if (mapping == null || (wrapper = registeredAttributes.get(mapping.getAttribute1_19())) == null) continue;
                    for (AttributeModifier modifier : otherAttributes.get((Object)attribute)) {
                        wrapper = wrapper.copy();
                        wrapper.setValue(modifier.getAmount());
                        wrapper.setOperation(modifier.getOperation());
                        attributes.put(mapping.getAttribute1_19(), wrapper);
                    }
                }
            }
        }
        return attributes;
    }

    public static boolean hasCustomStats(ItemMeta meta) {
        return ItemUtils.getPDCString(DEFAULT_STATS, meta, null) != null || ItemUtils.getPDCString(ACTUAL_STATS, meta, null) != null;
    }

    public static Map<String, AttributeWrapper> getVanillaStats(Material m) {
        Map<String, AttributeWrapper> stats = vanillaAttributes.get(m);
        if (stats != null) {
            return new HashMap<String, AttributeWrapper>(stats);
        }
        return new HashMap<String, AttributeWrapper>();
    }

    public static void setActualStats(ItemBuilder item, Map<String, AttributeWrapper> stats) {
        if (item == null) {
            return;
        }
        if (stats == null || stats.isEmpty()) {
            ItemAttributesRegistry.clean(item);
            return;
        }
        item.getMeta().setAttributeModifiers(null);
        for (AttributeWrapper wrapper2 : stats.values()) {
            if (!registeredAttributes.containsKey(wrapper2.getAttribute())) continue;
            wrapper2.onRemove(item);
        }
        Map<String, AttributeWrapper> defaultStats = ItemAttributesRegistry.getStats(item.getMeta(), true);
        HashSet<String> exclude = new HashSet<String>();
        ArrayList<AttributeWrapper> orderedWrappers = new ArrayList<AttributeWrapper>(stats.values());
        orderedWrappers.sort(Comparator.comparingDouble(wrapper -> attributePriorities.getOrDefault(((AttributeWrapper)wrapper).getAttribute(), 0.0)).thenComparing(wrapper -> ((AttributeWrapper)wrapper).getAttribute()));
        Collections.reverse(orderedWrappers);
        for (AttributeWrapper wrapper3 : orderedWrappers) {
            if (!defaultStats.containsKey(wrapper3.getAttribute())) {
                exclude.add(wrapper3.getAttribute());
                continue;
            }
            if (wrapper3.isVanilla()) {
                Attribute attribute = wrapper3.getVanillaAttribute();
                double value = wrapper3.getValue();
                if (attribute == Attribute.GENERIC_ATTACK_SPEED && wrapper3.getOperation() == AttributeModifier.Operation.ADD_NUMBER) {
                    value -= 4.0;
                } else if (attribute == Attribute.GENERIC_ATTACK_DAMAGE && wrapper3.getOperation() == AttributeModifier.Operation.ADD_NUMBER) {
                    value -= 1.0;
                }
                EquipmentSlot slot = ItemUtils.getEquipmentSlot(item.getMeta());
                if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.ATTRIBUTE_FOR_HELMET)) {
                    slot = EquipmentSlot.HEAD;
                } else if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.ATTRIBUTE_FOR_BOTH_HANDS)) {
                    item.getMeta().addAttributeModifier(attribute, new AttributeModifier(UUID.randomUUID(), wrapper3.getAttribute().replaceFirst("_", ".").toLowerCase(Locale.US), value, wrapper3.getOperation(), EquipmentSlot.OFF_HAND));
                }
                item.getMeta().addAttributeModifier(attribute, new AttributeModifier(UUID.randomUUID(), wrapper3.getAttribute().replaceFirst("_", ".").toLowerCase(Locale.US), value, wrapper3.getOperation(), slot));
            }
            wrapper3.onApply(item);
        }
        HashSet<AttributeWrapper> applied = new HashSet<AttributeWrapper>(stats.values());
        applied.removeIf(wrapper -> exclude.contains(wrapper.getAttribute()));
        item.stringTag(ACTUAL_STATS, ItemAttributesRegistry.serializeStats(applied));
    }

    private static String serializeStats(Collection<AttributeWrapper> wrappers) {
        ArrayList<AttributeWrapper> sorted = new ArrayList<AttributeWrapper>(wrappers);
        sorted.sort(Comparator.comparing(AttributeWrapper::getAttribute));
        StringBuilder saved = new StringBuilder();
        for (AttributeWrapper wrapper : sorted) {
            if (!saved.isEmpty()) {
                saved.append(';');
            }
            saved.append(wrapper.getAttribute()).append(':').append(wrapper.getValue()).append(':').append(wrapper.getOperation()).append(':').append(wrapper.isHidden());
        }
        return saved.toString();
    }

    public static Map<String, AttributeWrapper> applyVanillaStats(ItemBuilder item) {
        Map<String, AttributeWrapper> vanillaStats = ItemAttributesRegistry.getVanillaStats(item.getItem().getType());
        if (!vanillaStats.isEmpty()) {
            ItemAttributesRegistry.setDefaultStats(item, vanillaStats);
            ItemAttributesRegistry.setActualStats(item, vanillaStats);
            return vanillaStats;
        }
        return new HashMap<String, AttributeWrapper>();
    }

    public static AttributeWrapper getAttribute(ItemMeta meta, String attribute, boolean def) {
        return ItemAttributesRegistry.getStats(meta, def).get(attribute);
    }

    public static AttributeWrapper getAnyAttribute(ItemMeta meta, String attribute) {
        AttributeWrapper current = ItemAttributesRegistry.getStats(meta, false).get(attribute);
        if (current != null) {
            return current;
        }
        AttributeWrapper def = ItemAttributesRegistry.getStats(meta, true).get(attribute);
        if (def != null) {
            return def;
        }
        return ItemAttributesRegistry.getVanillaStats(ItemUtils.getStoredType(meta)).get(attribute);
    }

    public static void addDefaultStat(ItemBuilder item, AttributeWrapper wrapper) {
        Map<String, AttributeWrapper> defaultStats = ItemAttributesRegistry.getStats(item.getMeta(), true);
        if (defaultStats.isEmpty()) {
            defaultStats = ItemAttributesRegistry.applyVanillaStats(item);
        }
        defaultStats.put(wrapper.getAttribute(), wrapper);
        ItemAttributesRegistry.setDefaultStats(item, defaultStats);
        Map<String, AttributeWrapper> actualStats = ItemAttributesRegistry.getStats(item.getMeta(), false);
        actualStats.put(wrapper.getAttribute(), wrapper);
        ItemAttributesRegistry.setActualStats(item, actualStats);
    }

    public static void removeStat(ItemBuilder item, AttributeWrapper wrapper) {
        Map<String, AttributeWrapper> defaultStats = ItemAttributesRegistry.getStats(item.getMeta(), true);
        if (defaultStats.isEmpty()) {
            defaultStats = ItemAttributesRegistry.applyVanillaStats(item);
        }
        defaultStats.remove(wrapper.getAttribute());
        ItemAttributesRegistry.setDefaultStats(item, defaultStats);
        Map<String, AttributeWrapper> actualStats = ItemAttributesRegistry.getStats(item.getMeta(), false);
        actualStats.remove(wrapper.getAttribute());
        wrapper.onRemove(item);
        ItemAttributesRegistry.setActualStats(item, actualStats);
    }

    public static void setStat(ItemBuilder item, String attribute, double value, boolean hidden, boolean def) {
        Map<String, AttributeWrapper> stats = ItemAttributesRegistry.getStats(item.getMeta(), def);
        AttributeWrapper wrapper = stats.get(attribute);
        if (wrapper == null) {
            return;
        }
        wrapper = wrapper.copy();
        wrapper.setValue(value);
        wrapper.setHidden(hidden);
        stats.put(wrapper.getAttribute(), wrapper);
        if (def) {
            ItemAttributesRegistry.setDefaultStats(item, stats);
        }
        ItemAttributesRegistry.setActualStats(item, stats);
    }

    public static void addVanillaStat(Material item, AttributeWrapper ... wrappers) {
        Map modifiers = vanillaAttributes.getOrDefault(item, new HashMap());
        for (AttributeWrapper wrapper : wrappers) {
            modifiers.put(wrapper.getAttribute(), wrapper);
        }
        vanillaAttributes.put(item, modifiers);
    }

    public static void addVanillaStat(String item, AttributeWrapper ... wrappers) {
        Material m = ItemUtils.stringToMaterial(item, null);
        if (m != null) {
            ItemAttributesRegistry.addVanillaStat(m, wrappers);
        }
    }

    public static Map<String, AttributeWrapper> getRegisteredAttributes() {
        return Collections.unmodifiableMap(registeredAttributes);
    }

    public static Map<Material, Map<String, AttributeWrapper>> getVanillaAttributes() {
        return vanillaAttributes;
    }

    public static AttributeWrapper getCopy(String name) {
        if (!registeredAttributes.containsKey(name)) {
            throw new IllegalArgumentException("Attribute " + name + " does not exist!");
        }
        return registeredAttributes.get(name).copy();
    }
}

