/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.arrow_attributes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.DragonFireballArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.ExplodingArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.IncendiaryArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.LargeFireballArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.LightningArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.NoGravityArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.SmallFireballArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.TeleportingArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.VeryExplosiveArrow;
import me.athlaeos.valhallammo.item.arrow_attributes.implementations.VoidImmunityArrow;
import me.athlaeos.valhallammo.item.item_attributes.ArrowBehavior;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArrowBehaviorRegistry {
    private static final NamespacedKey BEHAVIOR = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "arrow_behavior");
    private static final Map<String, ArrowBehavior> registeredBehaviors = new HashMap<String, ArrowBehavior>();
    public static final ArrowBehavior EXPLODING = new ExplodingArrow("explosive_arrow");
    public static final ArrowBehavior EXPLODING_REPEATEDLY = new VeryExplosiveArrow("very_explosive_arrow");
    public static final ArrowBehavior INCENDIARY = new IncendiaryArrow("incendiary_arrow");
    public static final ArrowBehavior TELEPORTING = new TeleportingArrow("ender_arrow");
    public static final ArrowBehavior IMMUNITY_REMOVAL = new VoidImmunityArrow("no_iframes_arrow");
    public static final ArrowBehavior LIGHTNING = new LightningArrow("lightning_arrow");
    public static final ArrowBehavior FIREBALL_SMALL = new SmallFireballArrow("small_fireball_arrow");
    public static final ArrowBehavior FIREBALL_LARGE = new LargeFireballArrow("large_fireball_arrow");
    public static final ArrowBehavior FIREBALL_DRAGON = new DragonFireballArrow("dragon_fireball_arrow");
    public static final ArrowBehavior ANTIGRAVITY = new NoGravityArrow("gravityless_arrow");

    public static void registerBehavior(ArrowBehavior behavior) {
        registeredBehaviors.put(behavior.getName(), behavior);
    }

    public static ArrowBehavior getBehavior(String behavior) {
        if (!registeredBehaviors.containsKey(behavior)) {
            throw new IllegalArgumentException("Arrow behavior " + behavior + " does not exist");
        }
        return registeredBehaviors.get(behavior);
    }

    public static void addBehavior(ItemMeta arrow, String behavior, double ... args) {
        if (!registeredBehaviors.containsKey(behavior)) {
            return;
        }
        Map<String, BehaviorDetails> attributes = ArrowBehaviorRegistry.getBehaviors(arrow);
        attributes.put(behavior, new BehaviorDetails(behavior, args));
        ArrowBehaviorRegistry.setBehaviors(arrow, attributes);
    }

    public static void setBehaviors(ItemMeta meta, Map<String, BehaviorDetails> attributes) {
        if (meta == null) {
            return;
        }
        if (attributes.isEmpty()) {
            meta.getPersistentDataContainer().remove(BEHAVIOR);
        } else {
            HashSet<String> attributeStrings = new HashSet<String>();
            for (BehaviorDetails a : attributes.values()) {
                StringBuilder s = new StringBuilder(a.getName());
                for (double i : a.getArgs()) {
                    s.append(":").append(i);
                }
                attributeStrings.add(s.toString());
            }
            meta.getPersistentDataContainer().set(BEHAVIOR, PersistentDataType.STRING, (Object)String.join((CharSequence)";", attributeStrings));
        }
    }

    public static Map<String, BehaviorDetails> getBehaviors(ItemMeta arrow) {
        HashMap<String, BehaviorDetails> attributes = new HashMap<String, BehaviorDetails>();
        if (arrow == null) {
            return attributes;
        }
        String value = ItemUtils.getPDCString(BEHAVIOR, arrow, null);
        if (StringUtils.isEmpty(value)) {
            return attributes;
        }
        for (String s : value.split(";")) {
            String[] args = s.split(":");
            if (args.length > 1) {
                String name = args[0];
                if (!registeredBehaviors.containsKey(name)) continue;
                double[] doubleArgs = new double[args.length - 1];
                for (int i = 0; i < args.length - 1; ++i) {
                    try {
                        doubleArgs[i] = StringUtils.parseDouble(args[i + 1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                attributes.put(args[0], new BehaviorDetails(args[0], doubleArgs));
                continue;
            }
            attributes.put(s, new BehaviorDetails(s, new double[0]));
        }
        return attributes;
    }

    public static void execute(EntityDamageByEntityEvent e, Collection<BehaviorDetails> details) {
        details.forEach(b -> ArrowBehaviorRegistry.getBehavior(b.name).onDamage(e, b.args));
    }

    public static void execute(PlayerPickupArrowEvent e, Collection<BehaviorDetails> details) {
        details.forEach(b -> ArrowBehaviorRegistry.getBehavior(b.name).onPickup(e, b.args));
    }

    public static void execute(ProjectileLaunchEvent e, Collection<BehaviorDetails> details) {
        details.forEach(b -> ArrowBehaviorRegistry.getBehavior(b.name).onLaunch(e, b.args));
    }

    public static void execute(ProjectileHitEvent e, Collection<BehaviorDetails> details) {
        details.forEach(b -> ArrowBehaviorRegistry.getBehavior(b.name).onHit(e, b.args));
    }

    public static void execute(EntityShootBowEvent e, Collection<BehaviorDetails> details) {
        details.forEach(b -> ArrowBehaviorRegistry.getBehavior(b.name).onShoot(e, b.args));
    }

    static {
        ArrowBehaviorRegistry.registerBehavior(EXPLODING);
        ArrowBehaviorRegistry.registerBehavior(INCENDIARY);
        ArrowBehaviorRegistry.registerBehavior(TELEPORTING);
        ArrowBehaviorRegistry.registerBehavior(IMMUNITY_REMOVAL);
        ArrowBehaviorRegistry.registerBehavior(LIGHTNING);
        ArrowBehaviorRegistry.registerBehavior(FIREBALL_SMALL);
        ArrowBehaviorRegistry.registerBehavior(FIREBALL_LARGE);
        ArrowBehaviorRegistry.registerBehavior(FIREBALL_DRAGON);
        ArrowBehaviorRegistry.registerBehavior(ANTIGRAVITY);
        ArrowBehaviorRegistry.registerBehavior(EXPLODING_REPEATEDLY);
    }

    public record BehaviorDetails(String name, double[] args) {
        public String getName() {
            return this.name;
        }

        public double[] getArgs() {
            return this.args;
        }
    }
}

