/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.arrow_attributes.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.item_attributes.ArrowBehavior;
import me.athlaeos.valhallammo.particle.implementations.GenericParticle;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.projectiles.ProjectileSource;

public class IncendiaryArrow
extends ArrowBehavior {
    public IncendiaryArrow(String name) {
        super(name);
    }

    @Override
    public void onShoot(EntityShootBowEvent e, double ... args) {
        Entity entity = e.getProjectile();
        if (entity instanceof Projectile) {
            Projectile p = (Projectile)entity;
            AnimationUtils.trailProjectile(p, new GenericParticle(Particle.FLAME), 50);
        }
    }

    @Override
    public void onHit(ProjectileHitEvent e, double ... args) {
        if (args.length >= 2) {
            int fireTicks = (int)args[0];
            int radius = (int)args[1];
            double density = args.length > 2 ? args[2] : 1.0;
            Location hit = this.getHitLocation(e);
            if (hit.getWorld() == null) {
                return;
            }
            ProjectileSource projectileSource = e.getEntity().getShooter();
            if (projectileSource instanceof Entity) {
                Entity s = (Entity)projectileSource;
                double multiplier = AccumulativeStatManager.getCachedStats("EXPLOSION_RADIUS_MULTIPLIER", s, 10000L, true);
                radius *= (int)(1.0 + multiplier);
            }
            for (Block b : BlockUtils.getBlocksTouchingAnything(hit.getBlock(), radius, radius, radius)) {
                if (!b.getType().isAir() || !(Utils.getRandom().nextDouble() < density)) continue;
                BlockIgniteEvent igniteEvent = new BlockIgniteEvent(b, BlockIgniteEvent.IgniteCause.ARROW, (Entity)e.getEntity());
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)igniteEvent);
                if (igniteEvent.isCancelled()) continue;
                b.setType(Material.FIRE);
            }
            for (Entity entity : hit.getWorld().getNearbyEntities(hit, (double)radius, (double)radius, (double)radius)) {
                if (!(entity instanceof LivingEntity) || entity.getFireTicks() >= fireTicks) continue;
                entity.setFireTicks(fireTicks);
            }
            e.getEntity().remove();
        }
    }

    @Override
    public void onLaunch(ProjectileLaunchEvent e, double ... args) {
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent e, double ... args) {
    }

    @Override
    public void onPickup(PlayerPickupArrowEvent e, double ... args) {
    }
}

