/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.item_attributes.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class AttributeDisplayWrapper
extends AttributeWrapper {
    private final Collection<Material> compatibleWith = new HashSet<Material>();
    private final Predicate<Double> isPositive;
    private final String defaultIcon;
    private final StatFormat add_number;
    private final StatFormat add_scalar;
    private final StatFormat multiply_scalar_1;
    private double displayStatOffset = 0.0;

    public AttributeDisplayWrapper(String attribute, StatFormat format, String defaultIcon, Predicate<Double> isPositive) {
        super(attribute, format);
        this.isPositive = isPositive;
        this.defaultIcon = defaultIcon;
        this.add_number = null;
        this.add_scalar = null;
        this.multiply_scalar_1 = null;
    }

    public AttributeDisplayWrapper(String attribute, StatFormat format, String defaultIcon, Predicate<Double> isPositive, Material ... compatibleWith) {
        super(attribute, format);
        this.compatibleWith.addAll(Set.of(compatibleWith));
        this.isPositive = isPositive;
        this.defaultIcon = defaultIcon;
        this.add_number = null;
        this.add_scalar = null;
        this.multiply_scalar_1 = null;
    }

    public AttributeDisplayWrapper offset(double displayStatOffset) {
        this.displayStatOffset = displayStatOffset;
        return this;
    }

    public AttributeDisplayWrapper(String attribute, String defaultIcon, Predicate<Double> isPositive, StatFormat add_number, StatFormat add_scalar, StatFormat multiply_scalar_1) {
        super(attribute, null);
        this.isPositive = isPositive;
        this.defaultIcon = defaultIcon;
        this.add_number = add_number;
        this.add_scalar = add_scalar;
        this.multiply_scalar_1 = multiply_scalar_1;
    }

    @Override
    public boolean isCompatible(ItemStack i) {
        return this.compatibleWith.isEmpty() || this.compatibleWith.contains(i.getType());
    }

    @Override
    public void onApply(ItemBuilder i) {
        boolean customFlag = CustomFlag.hasFlag(i.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES);
        boolean vanillaFlag = i.getMeta().hasItemFlag(ItemFlag.HIDE_ATTRIBUTES);
        if (this.isHidden || this.isVanilla && (!customFlag || !vanillaFlag) || !this.isVanilla && vanillaFlag && !customFlag) {
            this.onRemove(i);
        } else {
            String translation = this.getAttributeName();
            if (StringUtils.isEmpty(translation)) {
                return;
            }
            i.appendLore(this.getLoreDisplay().trim());
        }
    }

    @Override
    public String getLoreDisplay() {
        String string;
        if (this.format == null) {
            switch (this.operation) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD_SCALAR: {
                    string = this.add_scalar.format(this.value + this.displayStatOffset);
                    break;
                }
                case ADD_NUMBER: {
                    string = this.add_number.format(this.value + this.displayStatOffset);
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    string = this.multiply_scalar_1.format(this.value + this.displayStatOffset);
                    break;
                }
            }
        } else {
            string = this.format.format(this.value + this.displayStatOffset);
        }
        String format = string;
        String translation = this.getAttributeName();
        String prefix = this.prefix(this.isPositive.test(this.value + this.displayStatOffset));
        return Utils.chat(prefix + translation.replace("%value%", format).replace("%icon%", this.getAttributeIcon() + prefix));
    }

    @Override
    public void onRemove(ItemBuilder i) {
        String translation = TranslationManager.getTranslation("attribute_" + this.attribute.toLowerCase(Locale.US));
        if (StringUtils.isEmpty(translation)) {
            return;
        }
        ItemUtils.removeIfLoreContains(i, translation.replace("%icon%", "").replace("%value%", "").trim());
    }

    @Override
    public String getAttributeIcon() {
        return StringUtils.isEmpty(super.getAttributeIcon()) ? (ValhallaMMO.isResourcePackConfigForced() ? "&f" + this.defaultIcon + " " : super.getAttributeIcon()) : super.getAttributeIcon();
    }

    @Override
    public AttributeWrapper copy() {
        if (this.format == null) {
            return new AttributeDisplayWrapper(this.attribute, this.defaultIcon, this.isPositive, this.add_number, this.add_scalar, this.multiply_scalar_1).offset(this.displayStatOffset).setOperation(this.operation).setValue(this.value).convertTo(this.convertTo);
        }
        return new AttributeDisplayWrapper(this.attribute, this.format, this.defaultIcon, this.isPositive, this.compatibleWith.toArray(new Material[0])).offset(this.displayStatOffset).setOperation(this.operation).setValue(this.value).convertTo(this.convertTo);
    }

    public String prefix(boolean positive) {
        return TranslationManager.getTranslation("stat_attribute_" + (positive ? "positive" : "negative") + "_prefix");
    }

    @Override
    public StatFormat getFormat() {
        StatFormat statFormat;
        if (this.format == null) {
            switch (this.operation) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD_SCALAR: {
                    statFormat = this.add_scalar;
                    break;
                }
                case ADD_NUMBER: {
                    statFormat = this.add_number;
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    statFormat = this.multiply_scalar_1;
                    break;
                }
            }
        } else {
            statFormat = this.format;
        }
        return statFormat;
    }

    public String toString() {
        String string;
        if (this.format == null) {
            switch (this.operation) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD_SCALAR: {
                    string = this.add_scalar.format(this.value + this.displayStatOffset);
                    break;
                }
                case ADD_NUMBER: {
                    string = this.add_number.format(this.value + this.displayStatOffset);
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    string = this.multiply_scalar_1.format(this.value + this.displayStatOffset);
                    break;
                }
            }
        } else {
            string = this.format.format(this.value + this.displayStatOffset);
        }
        return string;
    }

    public Predicate<Double> getIsPositive() {
        return this.isPositive;
    }

    public double getDisplayStatOffset() {
        return this.displayStatOffset;
    }
}

