/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomDurabilityManager;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.EntityEffect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class CraftingTableListener
implements Listener {
    private static final Map<UUID, Map<Integer, ItemBuilder>> matrixMetaCache = new HashMap<UUID, Map<Integer, ItemBuilder>>();
    private static final boolean vanillaRepairing = ValhallaMMO.getPluginConfig().getBoolean("inventory_repairing_vanilla");
    private static final boolean valhallaRepairing = ValhallaMMO.getPluginConfig().getBoolean("inventory_repairing_valhalla");

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraft(CraftItemEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player crafter = (Player)humanEntity;
            if (e.getRecipe() instanceof ShapedRecipe || e.getRecipe() instanceof ShapelessRecipe) {
                ItemStack cursor;
                DynamicGridRecipe recipe = CustomRecipeRegistry.getGridRecipesByKey().get(((Keyed)e.getRecipe()).getKey());
                if (recipe == null) {
                    return;
                }
                CraftingInventory inventory = e.getInventory();
                if (ValhallaMMO.isWorldBlacklisted(crafter.getWorld().getName()) || WorldGuardHook.inDisabledRegion(inventory.getLocation(), "vmmo-crafting-craftingtable") || inventory.getResult() == null) {
                    e.setCancelled(true);
                    return;
                }
                PowerProfile profile = ProfileCache.getOrCache(crafter, PowerProfile.class);
                ItemStack result = this.verifyIngredients(crafter, profile, recipe, inventory.getMatrix());
                if (ItemUtils.isEmpty(result)) {
                    Pair<DynamicGridRecipe, ItemStack> corrected = this.correctRecipe(crafter, profile, recipe, inventory.getMatrix());
                    if (corrected == null) {
                        e.setCancelled(true);
                        return;
                    }
                    recipe = corrected.getOne();
                    result = corrected.getTwo().clone();
                }
                ItemBuilder prepareResultBuilder = new ItemBuilder(result);
                DynamicItemModifier.modify(ModifierContext.builder(prepareResultBuilder).crafter(crafter).items(inventory.getMatrix()).validate().get(), recipe.getModifiers());
                if (CustomFlag.hasFlag(prepareResultBuilder.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    e.setCancelled(true);
                    return;
                }
                inventory.setResult(prepareResultBuilder.get());
                PlayerInventory playerInventory = crafter.getInventory();
                ClickType clickType = e.getClick();
                int amountCrafted = 1;
                boolean toolRequired = recipe.getToolRequirement().getToolRequirementType() != ToolRequirementType.NOT_REQUIRED && recipe.getToolRequirement().getRequiredToolID() >= 0;
                boolean verifyClicks = false;
                switch (clickType) {
                    case DROP: 
                    case CONTROL_DROP: {
                        if (ItemUtils.isEmpty(e.getCursor())) break;
                        e.setCancelled(true);
                        return;
                    }
                    case LEFT: {
                        if (!(ItemUtils.isEmpty(e.getCursor()) || ItemUtils.isEmpty(inventory.getResult()) || e.getCursor().isSimilar(inventory.getResult()) && e.getCursor().getAmount() + inventory.getResult().getAmount() <= ValhallaMMO.getNms().getMaxStackSize(e.getCursor().getItemMeta(), e.getCursor().getType()))) {
                            e.setCancelled(true);
                            return;
                        }
                        verifyClicks = true;
                        break;
                    }
                    case SHIFT_LEFT: 
                    case SHIFT_RIGHT: {
                        int maxCraftable = 99;
                        Map matrixMeta = matrixMetaCache.getOrDefault(e.getWhoClicked().getUniqueId(), new HashMap());
                        for (int i = 0; i < inventory.getMatrix().length; ++i) {
                            ItemStack slot = inventory.getMatrix()[i];
                            if (ItemUtils.isEmpty(slot) || toolRequired && ToolRequirementType.getToolID(((ItemBuilder)matrixMeta.get(i)).getMeta()) >= 0 || maxCraftable <= slot.getAmount()) continue;
                            maxCraftable = slot.getAmount();
                        }
                        int available = ItemUtils.maxInventoryFit(crafter, result);
                        amountCrafted = Math.min(available, maxCraftable);
                        if (amountCrafted != 0) break;
                        e.setCancelled(true);
                        return;
                    }
                    default: {
                        e.setCancelled(true);
                        return;
                    }
                }
                if (toolRequired) {
                    if (recipe.getToolIndex() >= 0) {
                        int toolIndex = -1;
                        List<ItemStack> matrix = Arrays.asList(inventory.getMatrix());
                        for (ItemStack i : inventory.getMatrix()) {
                            if (ItemUtils.isEmpty(i) || !recipe.getToolRequirement().canCraft(ToolRequirementType.getToolID(ItemUtils.getItemMeta(i)))) continue;
                            toolIndex = matrix.indexOf(i);
                            break;
                        }
                        if (toolIndex < 0) {
                            e.setCancelled(true);
                            return;
                        }
                        ItemStack tool = ItemUtils.damageItem(crafter, inventory.getMatrix()[toolIndex], amountCrafted, EntityEffect.BREAK_EQUIPMENT_MAIN_HAND) ? null : inventory.getMatrix()[toolIndex].clone();
                        inventory.getMatrix()[toolIndex].setAmount(amountCrafted);
                        int finalToolIndex = toolIndex;
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                            ItemStack[] m = inventory.getMatrix();
                            m[finalToolIndex] = tool;
                            inventory.setMatrix(m);
                        }, 1L);
                    } else {
                        int matchingIndex = -1;
                        for (int i = 0; i < playerInventory.getContents().length; ++i) {
                            ItemStack item = playerInventory.getContents()[i];
                            if (ItemUtils.isEmpty(item) || !recipe.getToolRequirement().canCraft(ToolRequirementType.getToolID(ItemUtils.getItemMeta(item)))) continue;
                            matchingIndex = i;
                            break;
                        }
                        if (matchingIndex < 0) {
                            e.setCancelled(true);
                            return;
                        }
                        ItemStack foundItem = crafter.getInventory().getItem(matchingIndex);
                        if (!ItemUtils.isEmpty(foundItem) && ItemUtils.damageItem(crafter, foundItem, amountCrafted, EntityEffect.BREAK_EQUIPMENT_MAIN_HAND, true)) {
                            crafter.getInventory().setItem(matchingIndex, null);
                        }
                    }
                }
                ItemBuilder resultBuilder = new ItemBuilder(result);
                DynamicItemModifier.modify(ModifierContext.builder(resultBuilder).crafter(crafter).executeUsageMechanics().validate().count(amountCrafted).items(inventory.getMatrix()).get(), recipe.getModifiers());
                if (CustomFlag.hasFlag(resultBuilder.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    e.setCancelled(true);
                    return;
                }
                ItemStack finalResult = resultBuilder.get();
                if (!(!verifyClicks || ItemUtils.isEmpty(cursor = e.getCursor()) || cursor.isSimilar(finalResult) && cursor.getAmount() + finalResult.getAmount() <= ValhallaMMO.getNms().getMaxStackSize(cursor.getItemMeta(), cursor.getType()))) {
                    e.setCancelled(true);
                    return;
                }
                inventory.setResult(finalResult);
                if (!ItemUtils.isEmpty(result)) {
                    recipe.getValidations().forEach(v -> {
                        Validation validation = ValidationRegistry.getValidation(v);
                        if (inventory.getLocation() == null || validation == null) {
                            return;
                        }
                        validation.execute(inventory.getLocation().getBlock());
                    });
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        ComplexRecipe r;
        Player crafter;
        CraftingInventory inventory;
        Recipe crafted;
        block35: {
            block37: {
                block36: {
                    ItemStack firstItem;
                    block39: {
                        block38: {
                            PowerProfile profile;
                            boolean incompatible;
                            boolean isRepair;
                            block34: {
                                block33: {
                                    crafted = e.getRecipe();
                                    inventory = e.getInventory();
                                    if (crafted == null) break block33;
                                    if (!(crafted instanceof Keyed)) break block34;
                                    Keyed k = (Keyed)crafted;
                                    if (!CustomRecipeRegistry.getDisabledRecipes().contains(k.getKey())) break block34;
                                }
                                inventory.setResult(null);
                                return;
                            }
                            crafter = e.getViewers().isEmpty() ? null : (Player)e.getViewers().get(0);
                            HashMap<Integer, ItemBuilder> matrixMeta = new HashMap<Integer, ItemBuilder>();
                            for (int i2 = 0; i2 < inventory.getMatrix().length; ++i2) {
                                ItemStack slot = inventory.getMatrix()[i2];
                                if (ItemUtils.isEmpty(slot)) continue;
                                matrixMeta.put(i2, new ItemBuilder(slot));
                            }
                            if (crafter != null) {
                                matrixMetaCache.put(crafter.getUniqueId(), matrixMeta);
                            }
                            boolean bl = isRepair = e.isRepair() || Arrays.stream(e.getInventory().getMatrix()).filter(i -> !ItemUtils.isEmpty(i) && i.getType().getMaxDurability() > 0).count() >= 2L;
                            if (!isRepair) break block35;
                            boolean anyCustom = false;
                            boolean anyNotCustom = true;
                            for (int i3 = 0; i3 < inventory.getMatrix().length; ++i3) {
                                ItemBuilder cachedItem;
                                ItemStack slot = inventory.getMatrix()[i3];
                                if (ItemUtils.isEmpty(slot) || (cachedItem = (ItemBuilder)matrixMeta.get(i3)) == null) continue;
                                if (!anyCustom && SmithingItemPropertyManager.hasSmithingQuality(cachedItem.getMeta())) {
                                    anyCustom = true;
                                }
                                if (!anyNotCustom || !SmithingItemPropertyManager.hasSmithingQuality(cachedItem.getMeta())) continue;
                                anyNotCustom = false;
                            }
                            if (!vanillaRepairing && !anyCustom && anyNotCustom || !valhallaRepairing && anyCustom && !anyNotCustom) {
                                inventory.setResult(null);
                                return;
                            }
                            boolean bl2 = incompatible = anyCustom && anyNotCustom;
                            if (incompatible) break block36;
                            if (ItemUtils.isEmpty(inventory.getResult())) {
                                return;
                            }
                            if (!ItemUtils.allMatchInTypeAndData(Arrays.asList(inventory.getMatrix()))) {
                                inventory.setResult(null);
                                return;
                            }
                            int combinedDurability = 0;
                            int firstItemMaxDurability = -1;
                            firstItem = null;
                            ItemBuilder firstBuilder = null;
                            for (int i4 = 0; i4 < inventory.getMatrix().length; ++i4) {
                                ItemBuilder first;
                                ItemStack item = inventory.getMatrix()[i4];
                                if (ItemUtils.isEmpty(item) || (first = (ItemBuilder)matrixMeta.get(i4)) == null) continue;
                                if (firstItemMaxDurability < 0) {
                                    firstItemMaxDurability = CustomDurabilityManager.getDurability(first, true);
                                    firstItem = item.clone();
                                    firstBuilder = first;
                                }
                                combinedDurability += CustomDurabilityManager.getDurability(first, false);
                            }
                            if (ItemUtils.isEmpty(firstItem)) break block37;
                            int newDurability = Math.min(combinedDurability + (int)Math.floor(0.05 * (double)firstItemMaxDurability), firstItemMaxDurability);
                            CustomDurabilityManager.setDurability(firstBuilder, newDurability, firstItemMaxDurability);
                            firstItem = firstBuilder.get();
                            PowerProfile powerProfile = profile = crafter == null ? null : ProfileCache.getOrCache(crafter, PowerProfile.class);
                            if (profile == null) break block38;
                            if (profile.hasInventoryRepairingKeepEnchanting()) break block39;
                        }
                        firstItem.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)firstItem).removeEnchantment(arg_0));
                    }
                    inventory.setResult(firstItem);
                    break block37;
                }
                inventory.setResult(null);
            }
            return;
        }
        if (crafted instanceof Keyed) {
            Keyed k = (Keyed)crafted;
            if (!(crafted instanceof ComplexRecipe) && !CustomRecipeRegistry.getGridRecipesByKey().containsKey(k.getKey())) {
                return;
            }
        }
        if ((crafted instanceof ShapedRecipe || crafted instanceof ShapelessRecipe) && !e.getViewers().isEmpty()) {
            DynamicGridRecipe recipe = CustomRecipeRegistry.getGridRecipesByKey().get(((Keyed)crafted).getKey());
            if (recipe == null) {
                return;
            }
            if (crafter == null || ValhallaMMO.isWorldBlacklisted(crafter.getWorld().getName())) {
                inventory.setResult(null);
                return;
            }
            PowerProfile profile = ProfileCache.getOrCache(crafter, PowerProfile.class);
            ItemStack result = this.verifyIngredients(crafter, profile, recipe, inventory.getMatrix());
            if (ItemUtils.isEmpty(result)) {
                Pair<DynamicGridRecipe, ItemStack> corrected = this.correctRecipe(crafter, profile, recipe, inventory.getMatrix());
                if (corrected == null) {
                    inventory.setResult(null);
                    return;
                }
                recipe = corrected.getOne();
                result = corrected.getTwo();
            }
            if (recipe.getValidations().stream().anyMatch(v -> {
                Validation validation = ValidationRegistry.getValidation(v);
                if (inventory.getLocation() == null) {
                    return false;
                }
                if (validation != null) {
                    boolean invalid;
                    boolean bl = invalid = !validation.validate(inventory.getLocation().getBlock());
                    if (invalid) {
                        Utils.sendMessage((CommandSender)crafter, validation.validationError());
                    }
                    return invalid;
                }
                return false;
            }) || inventory.getLocation() != null && inventory.getLocation().getWorld() != null && ValhallaMMO.isWorldBlacklisted(inventory.getLocation().getWorld().getName()) || WorldGuardHook.inDisabledRegion(inventory.getLocation(), "vmmo-crafting-craftingtable") || !crafter.hasPermission("valhalla.allrecipes") && !recipe.isUnlockedForEveryone() && !profile.getUnlockedRecipes().contains(recipe.getName()) && !crafter.hasPermission("valhalla.recipe." + recipe.getName())) {
                inventory.setResult(null);
                return;
            }
            ItemBuilder resultBuilder = new ItemBuilder(result);
            DynamicItemModifier.modify(ModifierContext.builder(resultBuilder).crafter(crafter).items(inventory.getMatrix()).validate().get(), recipe.getModifiers());
            inventory.setResult(resultBuilder.get());
        } else if (crafted instanceof ComplexRecipe && (r = (ComplexRecipe)crafted).getKey().getKey().equals("tipped_arrow") && !ItemUtils.isEmpty(inventory.getResult()) && Arrays.stream(inventory.getMatrix()).noneMatch(ItemUtils::isEmpty)) {
            ItemStack[] m = inventory.getMatrix();
            if (m[0].isSimilar(m[1]) && m[0].isSimilar(m[2]) && m[0].isSimilar(m[3]) && m[0].isSimilar(m[5]) && m[0].isSimilar(m[6]) && m[0].isSimilar(m[7]) && m[0].isSimilar(m[8])) {
                ItemBuilder potionBuilder;
                ItemStack arrow = m[0].clone();
                arrow.setAmount(8);
                arrow.setType(Material.TIPPED_ARROW);
                ItemBuilder arrowBuilder = ItemUtils.isEmpty(arrow) ? null : new ItemBuilder(arrow);
                ItemStack potion = m[4].clone();
                ItemBuilder itemBuilder = potionBuilder = ItemUtils.isEmpty(potion) ? null : new ItemBuilder(potion);
                if (arrowBuilder == null || potionBuilder == null) {
                    return;
                }
                if (CustomFlag.hasFlag(potionBuilder.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES)) {
                    CustomFlag.addItemFlag(arrowBuilder.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES);
                }
                if (potionBuilder.getMeta().hasItemFlag(ItemFlag.HIDE_POTION_EFFECTS)) {
                    arrowBuilder.getMeta().addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                }
                Map<String, PotionEffectWrapper> defaultEffects = PotionEffectRegistry.getStoredEffects(potionBuilder.getMeta(), true);
                Map<String, PotionEffectWrapper> actualEffects = PotionEffectRegistry.getStoredEffects(potionBuilder.getMeta(), false);
                if (defaultEffects.isEmpty()) {
                    return;
                }
                PotionEffectRegistry.setDefaultStoredEffects(arrowBuilder, defaultEffects);
                PotionEffectRegistry.setActualStoredEffects(arrowBuilder, actualEffects);
                PotionEffectRegistry.updateItemName(arrowBuilder, true, false);
                arrowBuilder.color(((PotionMeta)potionBuilder.getMeta()).getColor());
                arrowBuilder.flag(potionBuilder.getMeta().getItemFlags().toArray(new ItemFlag[0]));
                arrow = arrowBuilder.get();
                inventory.setResult(arrow);
            } else {
                inventory.setResult(null);
            }
        }
    }

    private ItemStack verifyIngredients(Player clicker, PowerProfile profile, DynamicGridRecipe recipe, ItemStack[] matrix) {
        ItemBuilder result = new ItemBuilder(recipe.getResult().clone());
        if (!(clicker.hasPermission("valhalla.allrecipes") || recipe.isUnlockedForEveryone() || profile.getUnlockedRecipes().contains(recipe.getName()) || clicker.hasPermission("valhalla.recipe." + recipe.getName()))) {
            return null;
        }
        Map matrixMeta = matrixMetaCache.getOrDefault(clicker.getUniqueId(), new HashMap());
        if (recipe.tinker()) {
            SlotEntry tinkerEntry = recipe.getGridTinkerEquipment();
            for (int i = 0; i < matrix.length; ++i) {
                ItemBuilder builder;
                ItemStack slot = matrix[i];
                if (ItemUtils.isEmpty(slot) || (builder = (ItemBuilder)matrixMeta.get(i)) == null) continue;
                if (recipe.requireValhallaTools() && EquipmentClass.getMatchingClass(builder.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(builder.getMeta())) {
                    return null;
                }
                if (!this.defaultChoice(tinkerEntry).matches(tinkerEntry.getItem(), slot)) continue;
                result = new ItemBuilder(slot.clone());
                break;
            }
        }
        ArrayList<SlotEntry> allIngredients = new ArrayList<SlotEntry>(recipe.getItems().values());
        SlotEntry toolEntry = recipe.getItems().get(recipe.getToolIndex());
        block1: for (int i = 0; i < matrix.length; ++i) {
            ItemBuilder builder;
            ItemStack slot = matrix[i];
            if (ItemUtils.isEmpty(slot) || (builder = (ItemBuilder)matrixMeta.get(i)) == null) continue;
            for (SlotEntry entry : new ArrayList<SlotEntry>(allIngredients)) {
                IngredientChoice choice;
                if (toolEntry != null) {
                    if (recipe.getToolRequirement().getToolRequirementType() == ToolRequirementType.NONE_MANDATORY) {
                        if (ToolRequirementType.getToolID(builder.getMeta()) >= 0) {
                            return null;
                        }
                    } else if (recipe.getToolRequirement().getToolRequirementType() != ToolRequirementType.NOT_REQUIRED && recipe.getToolRequirement().getRequiredToolID() >= 0 && recipe.getToolRequirement().canCraft(ToolRequirementType.getToolID(builder.getMeta()))) {
                        allIngredients.removeIf(e -> e.isSimilar(entry));
                        continue;
                    }
                }
                if (!(choice = this.defaultChoice(entry)).matches(entry.getItem(), slot) || !entry.isSimilar(entry) || !allIngredients.remove(entry)) continue;
                continue block1;
            }
        }
        if (!allIngredients.isEmpty()) {
            return null;
        }
        return result.get();
    }

    private IngredientChoice defaultChoice(SlotEntry entry) {
        return Objects.requireNonNullElse(entry.getOption(), new MaterialChoice());
    }

    private Pair<DynamicGridRecipe, ItemStack> correctRecipe(Player crafter, PowerProfile profile, DynamicGridRecipe original, ItemStack[] grid) {
        int ingredients = original.getItems().size();
        ItemStack originalCorrect = this.verifyIngredients(crafter, profile, original, grid);
        if (!ItemUtils.isEmpty(originalCorrect)) {
            return new Pair<DynamicGridRecipe, ItemStack>(original, originalCorrect);
        }
        for (DynamicGridRecipe recipe : (Collection)CustomRecipeRegistry.getGridRecipesByIngredientQuantity().getOrDefault(ingredients, new HashSet())) {
            ItemStack result;
            if (recipe.getName().equals(original.getName()) || !original.isShapeless() && !recipe.isShapeless() && !this.matchesShape(original, recipe) || ItemUtils.isEmpty(result = this.verifyIngredients(crafter, profile, recipe, grid))) continue;
            return new Pair<DynamicGridRecipe, ItemStack>(recipe, result);
        }
        return null;
    }

    private boolean matchesShape(DynamicGridRecipe d1, DynamicGridRecipe d2) {
        String[] shape2;
        if (d1.isShapeless() || d2.isShapeless()) {
            return false;
        }
        String[] shape1 = d1.getRecipeShapeStrings().getShape();
        if (shape1.length != (shape2 = d2.getRecipeShapeStrings().getShape()).length) {
            return false;
        }
        if (shape1.length == 0) {
            return false;
        }
        boolean inverse = false;
        int index = 0;
        block0: for (int i = 0; i < shape1.length * 2 && index < shape1.length; ++i) {
            String s2;
            String s1 = shape1[index];
            String string = s2 = inverse ? new StringBuilder(shape2[index]).reverse().toString() : shape2[index];
            if (s1.length() != s2.length()) {
                return false;
            }
            char[] s1Chars = s1.toCharArray();
            char[] s2Chars = s2.toCharArray();
            for (int c = 0; c < s1Chars.length; ++c) {
                if (s1Chars[c] == ' ' && s2Chars[c] == ' ' || s1Chars[c] != ' ' && s2Chars[c] != ' ') continue;
                if (!inverse) {
                    inverse = true;
                    index = 0;
                    continue block0;
                }
                return false;
            }
            ++index;
        }
        return true;
    }
}

