/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HandSwitchListener
implements Listener {
    private static final Map<UUID, DelayedHandUpdate> taskLimiters = new HashMap<UUID, DelayedHandUpdate>();
    private static final Collection<UUID> playersWhoSwitchedItems = new HashSet<UUID>();
    private static final Map<UUID, Material> previousOffhandItems = new HashMap<UUID, Material>();

    private void updateHands(Player who) {
        DelayedHandUpdate update = taskLimiters.get(who.getUniqueId());
        if (update != null) {
            update.refresh();
        } else {
            update = new DelayedHandUpdate(who);
            update.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
        }
        taskLimiters.put(who.getUniqueId(), update);
    }

    private static void reset(LivingEntity l) {
        EntityCache.resetHands(l);
        AccumulativeStatManager.uncache((Entity)l);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSwapHands(PlayerItemHeldEvent e) {
        if (Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "hand_equipment_reset")) {
            Timer.setCooldown(e.getPlayer().getUniqueId(), 500, "hand_equipment_reset");
            playersWhoSwitchedItems.add(e.getPlayer().getUniqueId());
            this.updateHands(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSwapHands(PlayerSwapHandItemsEvent e) {
        if (Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "hand_equipment_reset")) {
            Timer.setCooldown(e.getPlayer().getUniqueId(), 500, "hand_equipment_reset");
            playersWhoSwitchedItems.add(e.getPlayer().getUniqueId());
            this.updateHands(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemBreak(PlayerItemBreakEvent e) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            HandSwitchListener.reset((LivingEntity)e.getPlayer());
            playersWhoSwitchedItems.remove(e.getPlayer().getUniqueId());
        }, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent e) {
        if (playersWhoSwitchedItems.remove(e.getPlayer().getUniqueId()) || this.offhandChanged(e.getPlayer())) {
            if (ItemUtils.isEmpty(e.getPlayer().getInventory().getItemInOffHand())) {
                previousOffhandItems.remove(e.getPlayer().getUniqueId());
            } else {
                previousOffhandItems.put(e.getPlayer().getUniqueId(), e.getPlayer().getInventory().getItemInOffHand().getType());
            }
            HandSwitchListener.reset((LivingEntity)e.getPlayer());
        }
    }

    private boolean offhandChanged(Player p) {
        if (previousOffhandItems.containsKey(p.getUniqueId())) {
            if (ItemUtils.isEmpty(p.getInventory().getItemInOffHand())) {
                return true;
            }
            return previousOffhandItems.get(p.getUniqueId()) == p.getInventory().getItemInOffHand().getType();
        }
        return !ItemUtils.isEmpty(p.getInventory().getItemInOffHand());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAttack(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity;
            if (playersWhoSwitchedItems.remove(e.getDamager().getUniqueId())) {
                HandSwitchListener.reset(l);
            }
        }
    }

    private static class DelayedHandUpdate
    extends BukkitRunnable {
        private static final int delay = 10;
        private int timer = 10;
        private final Player who;

        public DelayedHandUpdate(Player who) {
            this.who = who;
        }

        public void run() {
            if (this.timer <= 0) {
                HandSwitchListener.reset((LivingEntity)this.who);
                taskLimiters.remove(this.who.getUniqueId());
                playersWhoSwitchedItems.remove(this.who.getUniqueId());
                this.cancel();
            } else {
                --this.timer;
            }
        }

        public void refresh() {
            this.timer = 10;
        }
    }
}

